/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.shared.basic.ValidationUtilities;
import com.extjs.gxt.ui.client.event.ComponentEvent;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.Validator;

public class HyperlinkField
extends VarcharField {
    public HyperlinkField(String label, boolean mandatory) {
        super(label, mandatory);
        this.setAutoValidate(false);
        this.setValidator(new HyperlinkValidator());
        this.setValidateOnBlur(true);
        this.setEmptyText("Hyperlink");
        this.getMessages().setBlankText("Hyperlink required");
    }

    protected void onFocus(ComponentEvent be) {
        super.onFocus(be);
        this.clearInvalid();
    }

    protected class HyperlinkValidator
    implements Validator {
        private static final String PROTOCOL_PART = "://";
        private static final String DEFAULT_PROTOCOL = "http://";

        protected HyperlinkValidator() {
        }

        public String validate(Field<?> field, String fieldValue) {
            String validatedValue = fieldValue;
            if (!validatedValue.contains(PROTOCOL_PART)) {
                validatedValue = DEFAULT_PROTOCOL + fieldValue;
                field.setRawValue(validatedValue);
            }
            if (!ValidationUtilities.HyperlinkValidationHelper.isProtocolValid(validatedValue)) {
                return "Hyperlink should start with one of the following protocols: " + ValidationUtilities.HyperlinkValidationHelper.getValidProtocolsAsString();
            }
            if (!ValidationUtilities.HyperlinkValidationHelper.isFormatValid(validatedValue)) {
                return "Hyperlink has improper format";
            }
            return null;
        }
    }
}

