/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.authorization.predicate;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.openbis.generic.server.authorization.IAuthorizationDataProvider;
import ch.systemsx.cisd.openbis.generic.server.authorization.RoleWithIdentifier;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.AbstractPredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.DataSetCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.ExperimentAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.server.authorization.predicate.SampleAugmentedCodePredicate;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.BasicEntityDescription;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.dto.PersonPE;
import java.util.List;

public class BasicEntityDescriptionPredicate
extends AbstractPredicate<BasicEntityDescription> {
    private final ExperimentAugmentedCodePredicate experimentPredicate = new ExperimentAugmentedCodePredicate();
    private final SampleAugmentedCodePredicate samplePredicate = new SampleAugmentedCodePredicate();
    private final DataSetCodePredicate dataSetPredicate = new DataSetCodePredicate();

    @Override
    public void init(IAuthorizationDataProvider provider) {
        this.experimentPredicate.init(provider);
        this.samplePredicate.init(provider);
        this.dataSetPredicate.init(provider);
    }

    @Override
    public String getCandidateDescription() {
        return "basic entity description";
    }

    @Override
    protected Status doEvaluation(PersonPE person, List<RoleWithIdentifier> allowedRoles, BasicEntityDescription value) {
        EntityKind entityKind = value.getEntityKind();
        String entityIdentifier = value.getEntityIdentifier();
        switch (entityKind) {
            case EXPERIMENT: {
                return this.experimentPredicate.doEvaluation(person, allowedRoles, entityIdentifier);
            }
            case SAMPLE: {
                return this.samplePredicate.doEvaluation(person, allowedRoles, entityIdentifier);
            }
            case DATA_SET: {
                return this.dataSetPredicate.doEvaluation(person, allowedRoles, entityIdentifier);
            }
        }
        return Status.OK;
    }
}

