/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.shared.translator;

import ch.systemsx.cisd.openbis.common.types.BooleanOrUnknown;
import ch.systemsx.cisd.openbis.generic.shared.basic.PermlinkUtilities;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ContainerDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DatabaseInstance;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ExperimentType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.LinkDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Metaproject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PhysicalDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PlaceholderDataSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Project;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Space;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DataSetTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExternalDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.LinkDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.managed_property.IManagedPropertyEvaluatorFactory;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataSetTypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DataStoreTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletionTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.EntityPropertyTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExperimentTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.ExternalDataManagementSystemTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.PersonTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SampleTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.SpaceTranslator;
import ch.systemsx.cisd.openbis.generic.shared.translator.TypeTranslator;
import ch.systemsx.cisd.openbis.generic.shared.util.HibernateUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class DataSetTranslator {
    private DataSetTranslator() {
    }

    public static DatasetDescription translateToDescription(AbstractExternalData data) {
        Sample sample;
        Experiment experiment;
        DatasetDescription description = new DatasetDescription();
        description.setDataSetCode(data.getCode());
        description.setDataStoreCode(data.getDataStore().getCode());
        description.setRegistrationTimestamp(data.getRegistrationDate());
        description.setOrderInContainer(data.getOrderInContainer());
        PhysicalDataSet dataSet = data.tryGetAsDataSet();
        if (dataSet != null) {
            description.setDataSetLocation(dataSet.getLocation());
            description.setSpeedHint(dataSet.getSpeedHint());
            description.setFileFormatType(dataSet.getFileFormatType().getCode());
        }
        description.setDataSetSize(data.getSize());
        DataSetType dataSetType = data.getDataSetType();
        if (dataSetType != null) {
            description.setDatasetTypeCode(dataSetType.getCode());
        }
        if ((experiment = data.getExperiment()) != null) {
            ExperimentType experimentType;
            description.setExperimentCode(experiment.getCode());
            description.setExperimentIdentifier(experiment.getIdentifier());
            Project project = experiment.getProject();
            if (project != null) {
                description.setProjectCode(project.getCode());
                Space space = project.getSpace();
                if (space != null) {
                    description.setSpaceCode(space.getCode());
                    DatabaseInstance instance = space.getInstance();
                    if (instance != null) {
                        description.setDatabaseInstanceCode(instance.getCode());
                    }
                }
            }
            if ((experimentType = experiment.getExperimentType()) != null) {
                description.setExperimentTypeCode(experimentType.getCode());
            }
        }
        if ((sample = data.getSample()) != null) {
            description.setSampleCode(sample.getCode());
            description.setSampleIdentifier(sample.getIdentifier());
            SampleType sampleType = sample.getSampleType();
            if (sampleType != null) {
                description.setSampleTypeCode(sampleType.getCode());
            }
        }
        return description;
    }

    public static List<AbstractExternalData> translate(List<? extends DataPE> list, String defaultDataStoreBaseURL, String baseIndexURL, Map<Long, Set<Metaproject>> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ArrayList<AbstractExternalData> result = new ArrayList<AbstractExternalData>(list.size());
        for (DataPE dataPE : list) {
            AbstractExternalData data = DataSetTranslator.translate(dataPE, baseIndexURL, true, (Collection<Metaproject>)metaprojects.get(dataPE.getId()), managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields.PROPERTIES);
            result.add(data);
        }
        return result;
    }

    public static AbstractExternalData translateWithoutRevealingData(AbstractExternalData data) {
        AbstractExternalData externalData = null;
        externalData = data.isContainer() ? new ContainerDataSet(true) : (data.isLinkData() ? new LinkDataSet(true) : new PhysicalDataSet(true));
        externalData.setId(data.getId());
        externalData.setCode(data.getCode());
        externalData.setDataSetProperties(new ArrayList<IEntityProperty>());
        return externalData;
    }

    public static AbstractExternalData translateWithoutRevealingData(DataPE dataPE) {
        AbstractExternalData externalData = null;
        if (dataPE.isContainer()) {
            externalData = new ContainerDataSet(true);
        } else if (dataPE.isLinkData()) {
            externalData = new LinkDataSet(true);
        } else if (dataPE instanceof ExternalDataPE) {
            externalData = new PhysicalDataSet(true);
        } else {
            throw new IllegalArgumentException("Data set " + dataPE.getCode() + " is neither a container nor a real data set.");
        }
        externalData.setId(HibernateUtils.getId(dataPE));
        externalData.setCode(dataPE.getCode());
        externalData.setDataSetProperties(new ArrayList<IEntityProperty>());
        return externalData;
    }

    public static AbstractExternalData translate(DataPE dataPE, String baseIndexURL, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields ... withExperimentFields) {
        return DataSetTranslator.translate(dataPE, baseIndexURL, true, metaprojects, managedPropertyEvaluatorFactory, withExperimentFields);
    }

    public static AbstractExternalData translate(DataPE dataPE, String baseIndexURL, boolean withDetails, Collection<Metaproject> metaprojects, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory, ExperimentTranslator.LoadableFields ... withExperimentFields) {
        AbstractExternalData externalData = null;
        if (dataPE.isContainer()) {
            externalData = DataSetTranslator.translateContainerDataSetProperties(dataPE, baseIndexURL, withDetails, managedPropertyEvaluatorFactory);
        } else if (dataPE.isLinkData()) {
            externalData = DataSetTranslator.translateLinkDataSetProperties(dataPE);
        } else if (dataPE instanceof ExternalDataPE) {
            externalData = DataSetTranslator.translateDataSetProperties((ExternalDataPE)dataPE);
        } else {
            throw new IllegalArgumentException("Data set " + dataPE.getCode() + " is neither a container nor a real data set.");
        }
        SamplePE sampleOrNull = dataPE.tryGetSample();
        ExperimentPE experiment = dataPE.getExperiment();
        Experiment translatedExperiment = ExperimentTranslator.translate(experiment, baseIndexURL, null, managedPropertyEvaluatorFactory, withExperimentFields);
        externalData.setId(HibernateUtils.getId(dataPE));
        externalData.setCode(dataPE.getCode());
        externalData.setDataProducerCode(dataPE.getDataProducerCode());
        externalData.setDataSetType(DataSetTypeTranslator.translate(dataPE.getDataSetType(), new HashMap<PropertyTypePE, PropertyType>()));
        externalData.setDerived(dataPE.isDerived());
        Integer orderInContainer = dataPE.getOrderInContainer();
        if (orderInContainer != null) {
            externalData.setOrderInContainer(orderInContainer);
        }
        externalData.setContainer(DataSetTranslator.tryToTranslateContainer(dataPE.getContainer(), baseIndexURL, managedPropertyEvaluatorFactory));
        HashSet<AbstractExternalData> parents = new HashSet<AbstractExternalData>();
        externalData.setParents(parents);
        for (DataPE parentPE : dataPE.getParents()) {
            parents.add(DataSetTranslator.translateBasicProperties(parentPE));
        }
        DataSetTranslator.setChildren(dataPE, externalData);
        externalData.setProductionDate(dataPE.getProductionDate());
        externalData.setModificationDate(dataPE.getModificationDate());
        externalData.setVersion(dataPE.getVersion());
        externalData.setRegistrator(PersonTranslator.translate(dataPE.getRegistrator()));
        externalData.setModifier(PersonTranslator.translate(dataPE.getModifier()));
        externalData.setRegistrationDate(dataPE.getRegistrationDate());
        externalData.setSample(sampleOrNull == null ? null : DataSetTranslator.fillSample(new Sample(), sampleOrNull, translatedExperiment, withDetails, managedPropertyEvaluatorFactory));
        externalData.setDataStore(DataStoreTranslator.translate(dataPE.getDataStore()));
        externalData.setPermlink(PermlinkUtilities.createPermlinkURL(baseIndexURL, EntityKind.DATA_SET, externalData.getIdentifier()));
        DataSetTranslator.setProperties(dataPE, externalData, managedPropertyEvaluatorFactory);
        externalData.setExperiment(translatedExperiment);
        if (!dataPE.isContainer()) {
            externalData.setPostRegistered(dataPE.getPostRegistration().size() == 0);
        }
        if (metaprojects != null) {
            externalData.setMetaprojects(metaprojects);
        }
        externalData.setDeletion(DeletionTranslator.translate(dataPE.getDeletion()));
        return externalData;
    }

    private static ContainerDataSet tryToTranslateContainer(DataPE containerOrNull, String baseIndexURL, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        return containerOrNull != null ? (ContainerDataSet)DataSetTranslator.translate(containerOrNull, baseIndexURL, false, null, managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]) : null;
    }

    private static AbstractExternalData translateContainerDataSetProperties(DataPE dataPE, String baseIndexURL, boolean withComponents, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ContainerDataSet containerDataSet = new ContainerDataSet();
        if (withComponents) {
            DataSetTranslator.setContainedDataSets(dataPE, containerDataSet, baseIndexURL, managedPropertyEvaluatorFactory);
        }
        return containerDataSet;
    }

    private static LinkDataSet translateLinkDataSetProperties(DataPE dataPE) {
        LinkDataSet linkDataSet = new LinkDataSet();
        LinkDataPE linkDataPE = dataPE.tryAsLinkData();
        linkDataSet.setExternalDataManagementSystem(ExternalDataManagementSystemTranslator.translate(linkDataPE.getExternalDataManagementSystem()));
        linkDataSet.setExternalCode(linkDataPE.getExternalCode());
        return linkDataSet;
    }

    private static AbstractExternalData translateDataSetProperties(ExternalDataPE externalDataPE) {
        PhysicalDataSet dataSet = new PhysicalDataSet();
        dataSet.setSize(externalDataPE.getSize());
        dataSet.setOrderInContainer(externalDataPE.getOrderInContainer());
        dataSet.setComplete(BooleanOrUnknown.tryToResolve(externalDataPE.getComplete()));
        dataSet.setStatus(externalDataPE.getStatus());
        dataSet.setPresentInArchive(externalDataPE.isPresentInArchive());
        dataSet.setStorageConfirmation(externalDataPE.isStorageConfirmation());
        dataSet.setSpeedHint(externalDataPE.getSpeedHint());
        dataSet.setFileFormatType(TypeTranslator.translate(externalDataPE.getFileFormatType()));
        dataSet.setLocation(externalDataPE.getLocation());
        dataSet.setAccessTimestamp(externalDataPE.getAccessDate());
        dataSet.setShareId(externalDataPE.getShareId());
        dataSet.setLocatorType(TypeTranslator.translate(externalDataPE.getLocatorType()));
        return dataSet;
    }

    private static void setProperties(DataPE dataPE, AbstractExternalData externalData, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        if (HibernateUtils.isInitialized(dataPE.getProperties())) {
            externalData.setDataSetProperties(EntityPropertyTranslator.translate(dataPE.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
        } else {
            externalData.setDataSetProperties(new ArrayList<IEntityProperty>());
        }
    }

    private static Sample fillSample(Sample sample, SamplePE samplePE, Experiment experiment, boolean loadSampleProperties, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        sample.setId(HibernateUtils.getId(samplePE));
        sample.setPermId(samplePE.getPermId());
        SampleTranslator.setCodes(sample, samplePE);
        sample.setSampleType(TypeTranslator.translate(samplePE.getSampleType()));
        sample.setIdentifier(samplePE.getSampleIdentifier().toString());
        sample.setRegistrationDate(samplePE.getRegistrationDate());
        sample.setRegistrator(PersonTranslator.translate(samplePE.getRegistrator()));
        sample.setModifier(PersonTranslator.translate(samplePE.getModifier()));
        sample.setSpace(SpaceTranslator.translate(samplePE.getSpace()));
        sample.setExperiment(experiment);
        if (loadSampleProperties) {
            sample.setProperties(EntityPropertyTranslator.translate(samplePE.getProperties(), new HashMap<PropertyTypePE, PropertyType>(), managedPropertyEvaluatorFactory));
        }
        return sample;
    }

    private static void setChildren(DataPE dataPE, AbstractExternalData externalData) {
        ArrayList<AbstractExternalData> children = new ArrayList<AbstractExternalData>();
        if (HibernateUtils.isInitialized(dataPE.getChildRelationships())) {
            for (DataPE childPE : dataPE.getChildren()) {
                children.add(DataSetTranslator.translateBasicProperties(childPE));
            }
        }
        externalData.setChildren(children);
    }

    private static void setContainedDataSets(DataPE dataPE, ContainerDataSet containerDataSet, String baseIndexURL, IManagedPropertyEvaluatorFactory managedPropertyEvaluatorFactory) {
        ArrayList<AbstractExternalData> containedDataSets = new ArrayList<AbstractExternalData>();
        if (HibernateUtils.isInitialized(dataPE.getContainedDataSets())) {
            for (DataPE childPE : dataPE.getContainedDataSets()) {
                containedDataSets.add(DataSetTranslator.translate(childPE, baseIndexURL, null, managedPropertyEvaluatorFactory, new ExperimentTranslator.LoadableFields[0]));
            }
        }
        containerDataSet.setContainedDataSets(containedDataSets);
    }

    public static AbstractExternalData translateBasicProperties(DataPE dataPE) {
        AbstractExternalData result = null;
        if (dataPE.isContainer()) {
            result = new ContainerDataSet();
        } else if (dataPE.isExternalData()) {
            result = new PhysicalDataSet();
        } else if (dataPE.isLinkData()) {
            result = new LinkDataSet();
        } else {
            assert (dataPE.isPlaceholder());
            result = new PlaceholderDataSet();
        }
        result.setId(HibernateUtils.getId(dataPE));
        result.setCode(dataPE.getCode());
        result.setDataSetType(DataSetTypeTranslator.translate(dataPE.getDataSetType(), new HashMap<PropertyTypePE, PropertyType>()));
        return result;
    }

    public static List<DatasetDescription> translateToDescriptions(List<? extends DataPE> datasets) {
        ArrayList<DatasetDescription> result = new ArrayList<DatasetDescription>();
        for (DataPE dataPE : datasets) {
            result.add(DataSetTranslator.translateToDescription(dataPE));
        }
        return result;
    }

    public static DatasetDescription translateToDescription(DataPE dataSet) {
        SamplePE sample;
        assert (dataSet != null);
        DatasetDescription description = new DatasetDescription();
        description.setDataSetCode(dataSet.getCode());
        description.setOrderInContainer(dataSet.getOrderInContainer());
        description.setRegistrationTimestamp(dataSet.getRegistrationDate());
        if (dataSet.isExternalData()) {
            ExternalDataPE externalData = dataSet.tryAsExternalData();
            description.setDataSetLocation(externalData.getLocation());
            description.setDataSetSize(externalData.getSize());
            description.setSpeedHint(externalData.getSpeedHint());
            description.setFileFormatType(externalData.getFileFormatType().getCode());
            description.setStorageConfirmed(externalData.isStorageConfirmation());
        }
        if ((sample = dataSet.tryGetSample()) != null) {
            description.setSampleCode(sample.getCode());
            description.setSampleIdentifier(sample.getIdentifier());
            description.setSampleTypeCode(sample.getSampleType().getCode());
        }
        ExperimentPE experiment = dataSet.getExperiment();
        description.setExperimentIdentifier(experiment.getIdentifier());
        description.setExperimentTypeCode(experiment.getExperimentType().getCode());
        description.setExperimentCode(experiment.getCode());
        ProjectPE project = experiment.getProject();
        description.setProjectCode(project.getCode());
        SpacePE group = project.getSpace();
        description.setSpaceCode(group.getCode());
        description.setDatabaseInstanceCode(group.getDatabaseInstance().getCode());
        DataSetTypePE dataSetType = dataSet.getDataSetType();
        description.setMainDataSetPath(dataSetType.getMainDataSetPath());
        description.setMainDataSetPattern(dataSetType.getMainDataSetPattern());
        description.setDatasetTypeCode(dataSetType.getCode());
        description.setDataStoreCode(dataSet.getDataStore().getCode());
        return description;
    }
}

