/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.generic.server;

import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.ISampleDAO;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataTypeCode;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterial;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewMaterialsWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSamplesWithTypes;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.EntityTypePropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.MaterialTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.ProjectPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.PropertyTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifierFactory;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.properties.EntityKind;
import ch.systemsx.cisd.openbis.plugin.generic.server.IdentifersExtractor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;

class EntityExistenceChecker {
    private final IDAOFactory daoFactory;
    private final AbstractExistenceManager<ExperimentIdentifier, ExperimentPE> experimentExistenceManager;
    private final AbstractExistenceManager<MaterialIdentifier, MaterialPE> materialExistenceManager;
    private final AbstractExistenceManager<SampleIdentifier, SamplePE> sampleExistenceManager;
    private final AbstractExistenceManager<SpaceIdentifier, SpacePE> spaceExistenceManager;
    private final Map<String, Map<String, PropertyTypePE>> materialTypeToPropertyTypesMap = new HashMap<String, Map<String, PropertyTypePE>>();
    private final Map<String, Map<String, PropertyTypePE>> sampleTypeToPropertyTypesMap = new HashMap<String, Map<String, PropertyTypePE>>();
    private final Set<String> errors;

    EntityExistenceChecker(final IDAOFactory daoFactory) {
        this.daoFactory = daoFactory;
        this.errors = new TreeSet<String>();
        this.experimentExistenceManager = new AbstractExistenceManager<ExperimentIdentifier, ExperimentPE>(this.errors, "experiment"){

            @Override
            protected ExperimentPE tryGetEntity(ExperimentIdentifier identifier) {
                ProjectPE project = daoFactory.getProjectDAO().tryFindProject(daoFactory.getHomeDatabaseInstance().getCode(), identifier.getSpaceCode(), identifier.getProjectCode());
                if (project == null) {
                    EntityExistenceChecker.this.errors.add("Unknown experiment because of unknown project: " + identifier);
                    return null;
                }
                ExperimentPE experiment = daoFactory.getExperimentDAO().tryFindByCodeAndProject(project, identifier.getExperimentCode());
                return experiment;
            }
        };
        this.materialExistenceManager = new AbstractExistenceManager<MaterialIdentifier, MaterialPE>(this.errors, "material"){

            @Override
            protected MaterialPE tryGetEntity(MaterialIdentifier identifier) {
                return daoFactory.getMaterialDAO().tryFindMaterial(identifier);
            }
        };
        this.sampleExistenceManager = new AbstractExistenceManager<SampleIdentifier, SamplePE>(this.errors, "sample"){

            @Override
            protected SamplePE tryGetEntity(SampleIdentifier identifier) {
                String sampleCode = identifier.getSampleCode();
                ISampleDAO sampleDAO = daoFactory.getSampleDAO();
                if (identifier.isSpaceLevel()) {
                    SpaceIdentifier spaceLevel = identifier.getSpaceLevel();
                    if (!EntityExistenceChecker.this.spaceExistenceManager.exists(spaceLevel)) {
                        return null;
                    }
                    return sampleDAO.tryFindByCodeAndSpace(sampleCode, (SpacePE)EntityExistenceChecker.this.spaceExistenceManager.tryGet(spaceLevel));
                }
                return sampleDAO.tryFindByCodeAndDatabaseInstance(sampleCode, daoFactory.getHomeDatabaseInstance());
            }
        };
        this.spaceExistenceManager = new AbstractExistenceManager<SpaceIdentifier, SpacePE>(this.errors, "space"){

            @Override
            protected SpacePE tryGetEntity(SpaceIdentifier identifier) {
                DatabaseInstancePE homeDatabaseInstance = daoFactory.getHomeDatabaseInstance();
                return daoFactory.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(identifier.getSpaceCode(), homeDatabaseInstance);
            }
        };
    }

    public List<String> getErrors() {
        return new ArrayList<String>(this.errors);
    }

    void checkNewMaterials(List<NewMaterialsWithTypes> newMaterialsWithType) {
        for (NewMaterialsWithTypes newMaterialsWithTypes : newMaterialsWithType) {
            MaterialType materialType = (MaterialType)newMaterialsWithTypes.getEntityType();
            this.assertMaterialTypeExists(materialType);
            List newMaterials = newMaterialsWithTypes.getNewEntities();
            for (NewMaterial newMaterial : newMaterials) {
                IEntityProperty[] properties = newMaterial.getProperties();
                this.assertValidPropertyTypes(materialType, this.materialTypeToPropertyTypesMap, properties);
                String code = newMaterial.getCode();
                this.materialExistenceManager.add(new MaterialIdentifier(code, materialType.getCode()));
            }
        }
    }

    private void assertMaterialTypeExists(MaterialType materialType) {
        String materialTypeCode = materialType.getCode();
        if (!this.materialTypeToPropertyTypesMap.containsKey(materialTypeCode)) {
            MaterialTypePE type = (MaterialTypePE)this.daoFactory.getEntityTypeDAO(EntityKind.MATERIAL).tryToFindEntityTypeByCode(materialTypeCode);
            if (type == null) {
                this.errors.add("Unknown material type: " + materialTypeCode);
                return;
            }
            this.addPropertyTypesTo(this.materialTypeToPropertyTypesMap, materialTypeCode, type.getMaterialTypePropertyTypes());
        }
    }

    void checkNewSamples(List<NewSamplesWithTypes> newSamplesWithType) {
        for (NewSamplesWithTypes newSamplesWithTypes : newSamplesWithType) {
            SampleType sampleType = (SampleType)newSamplesWithTypes.getEntityType();
            this.assertSampleTypeExists(sampleType);
            List newSamples = newSamplesWithTypes.getNewEntities();
            for (NewSample newSample : newSamples) {
                String containerIdentifier;
                IdentifersExtractor extractor = new IdentifersExtractor(newSample);
                ExperimentIdentifier experimentIdentifier = extractor.getExperimentIdentifierOrNull();
                if (experimentIdentifier != null) {
                    this.experimentExistenceManager.exists(experimentIdentifier);
                }
                if ((containerIdentifier = newSample.getContainerIdentifierForNewSample()) != null) {
                    String defaultSpaceIdentifier = newSample.getDefaultSpaceIdentifier();
                    SampleIdentifier sampleIdentifier = SampleIdentifierFactory.parse(containerIdentifier, defaultSpaceIdentifier);
                    this.sampleExistenceManager.exists(sampleIdentifier);
                }
                this.sampleExistenceManager.add(extractor.getNewSampleIdentifier());
                IEntityProperty[] properties = newSample.getProperties();
                this.assertValidPropertyTypes(sampleType, this.sampleTypeToPropertyTypesMap, properties);
            }
        }
    }

    private void assertSampleTypeExists(SampleType sampleType) {
        String sampleTypeCode = sampleType.getCode();
        if (!this.sampleTypeToPropertyTypesMap.containsKey(sampleTypeCode)) {
            SampleTypePE type = this.daoFactory.getSampleTypeDAO().tryFindSampleTypeByCode(sampleTypeCode);
            if (type == null) {
                this.errors.add("Unknown sample type: " + sampleTypeCode);
                return;
            }
            this.addPropertyTypesTo(this.sampleTypeToPropertyTypesMap, sampleTypeCode, type.getSampleTypePropertyTypes());
        }
    }

    private void addPropertyTypesTo(Map<String, Map<String, PropertyTypePE>> entityTypeToPropertyTypesMap, String typeCode, Set<? extends EntityTypePropertyTypePE> entityTypePropertyTypes) {
        HashMap<String, PropertyTypePE> propertyTypes = new HashMap<String, PropertyTypePE>();
        for (EntityTypePropertyTypePE entityTypePropertyTypePE : entityTypePropertyTypes) {
            PropertyTypePE propertyType = entityTypePropertyTypePE.getPropertyType();
            propertyTypes.put(propertyType.getCode(), propertyType);
        }
        entityTypeToPropertyTypesMap.put(typeCode, propertyTypes);
    }

    private void assertValidPropertyTypes(EntityType entityType, Map<String, Map<String, PropertyTypePE>> entityTypeToPropertyTypesMap, IEntityProperty[] properties) {
        String entityTypeCode = entityType.getCode();
        Map<String, PropertyTypePE> propertyTypes = entityTypeToPropertyTypesMap.get(entityTypeCode);
        if (propertyTypes == null) {
            return;
        }
        IEntityProperty[] iEntityPropertyArray = properties;
        int n = properties.length;
        int n2 = 0;
        while (n2 < n) {
            IEntityProperty property = iEntityPropertyArray[n2];
            String propertyTypeCode = this.getPropertyTypeCode(property);
            PropertyTypePE propertyTypePE = propertyTypes.get(propertyTypeCode);
            if (propertyTypePE == null) {
                String typeName = entityType instanceof SampleType ? "Sample" : "Material";
                this.errors.add(String.valueOf(typeName) + " type " + entityTypeCode + " has no property type " + propertyTypeCode + " assigned.");
            } else if (propertyTypePE.getType().getCode().equals(DataTypeCode.MATERIAL)) {
                String value = property.getValue();
                MaterialTypePE materialType = propertyTypePE.getMaterialType();
                try {
                    MaterialIdentifier materialIdentifier = MaterialIdentifier.tryCreate(value, materialType);
                    if (materialIdentifier == null) {
                        this.errors.add("Material identifier not in the form '<material code> (<material type code>)': " + value);
                    } else {
                        this.materialExistenceManager.exists(materialIdentifier);
                    }
                }
                catch (Exception ex) {
                    this.errors.add(ex.getMessage());
                }
            }
            ++n2;
        }
    }

    private String getPropertyTypeCode(IEntityProperty property) {
        String code = property.getPropertyType().getCode().toUpperCase();
        int indexOfColon = code.indexOf(58);
        return indexOfColon < 0 ? code : code.substring(0, indexOfColon);
    }

    private static abstract class AbstractExistenceManager<T, E> {
        private final Map<T, Status> identifierToStatusMap = new HashMap<T, Status>();
        private final Map<T, E> identifierToEntityMap = new HashMap<T, E>();
        private final String name;
        private final Set<String> errors;

        public AbstractExistenceManager(Set<String> errors, String name) {
            this.errors = errors;
            this.name = name;
        }

        public void add(T identifier) {
            this.identifierToStatusMap.put(identifier, Status.KNOWN);
        }

        public E tryGet(T identifier) {
            return this.identifierToEntityMap.get(identifier);
        }

        public boolean exists(T identifier) {
            int size = this.errors.size();
            Status status = this.identifierToStatusMap.get(identifier);
            if (Status.KNOWN.equals((Object)status)) {
                return true;
            }
            if (status == null) {
                E entity = this.tryGetEntity(identifier);
                if (entity != null) {
                    this.identifierToStatusMap.put(identifier, Status.KNOWN);
                    this.identifierToEntityMap.put(identifier, entity);
                    return true;
                }
                this.identifierToStatusMap.put(identifier, Status.UNKNOWN);
            }
            if (size == this.errors.size()) {
                this.errors.add("Unknown " + this.name + ": " + identifier);
            }
            return false;
        }

        protected abstract E tryGetEntity(T var1);

        private static enum Status {
            KNOWN,
            UNKNOWN;

        }
    }
}

