/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.imagereaders;

import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.base.io.ByteBufferRandomAccessFile;
import ch.systemsx.cisd.base.io.IRandomAccessFile;
import ch.systemsx.cisd.base.io.RandomAccessFileImpl;
import ch.systemsx.cisd.imagereaders.AbstractImageReader;
import ch.systemsx.cisd.imagereaders.IReadParams;
import ch.systemsx.cisd.imagereaders.ImageID;
import java.io.File;
import java.util.Map;

public abstract class AbstractMetaDataAwareImageReader
extends AbstractImageReader {
    public AbstractMetaDataAwareImageReader(String libraryName, String readerName) {
        super(libraryName, readerName);
    }

    @Override
    public Map<String, Object> readMetaData(File file, ImageID imageID, IReadParams params) throws IOExceptionUnchecked {
        RandomAccessFileImpl raf = new RandomAccessFileImpl(file, "r");
        try {
            Map<String, Object> map = this.readMetaData((IRandomAccessFile)raf, imageID, params);
            return map;
        }
        finally {
            raf.close();
        }
    }

    @Override
    public Map<String, Object> readMetaData(byte[] bytes, ImageID imageID, IReadParams params) {
        ByteBufferRandomAccessFile raf = new ByteBufferRandomAccessFile(bytes);
        return this.readMetaData((IRandomAccessFile)raf, imageID, params);
    }

    @Override
    public boolean isMetaDataAware() {
        return true;
    }
}

