/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.etlserver.plugins;

import ch.systemsx.cisd.common.collection.SimpleComparator;
import ch.systemsx.cisd.etlserver.IAutoArchiverPolicy;
import ch.systemsx.cisd.etlserver.plugins.BaseGroupingPolicy;
import ch.systemsx.cisd.etlserver.plugins.grouping.DatasetListWithTotal;
import ch.systemsx.cisd.etlserver.plugins.grouping.Grouping;
import ch.systemsx.cisd.etlserver.plugins.grouping.IGroupKeyProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Properties;

public class ByExperimentPolicy
extends BaseGroupingPolicy
implements IAutoArchiverPolicy {
    private final List<IGroupKeyProvider> providers = new ArrayList<IGroupKeyProvider>();

    public ByExperimentPolicy(Properties properties) {
        super(properties);
        this.providers.add(Grouping.ExperimentAndDataSetType);
        this.providers.add(Grouping.Experiment);
        this.providers.add(Grouping.Project);
    }

    @Override
    public List<AbstractExternalData> filterDataSetsWithSizes(List<AbstractExternalData> dataSets) {
        for (AbstractExternalData ds : dataSets) {
            if (ds.getSize() < this.maxArchiveSize) continue;
            return Collections.singletonList(ds);
        }
        for (IGroupKeyProvider provider : this.providers) {
            DatasetListWithTotal best;
            long size;
            Collection<DatasetListWithTotal> result = this.splitDataSetsInGroupsAccordingToCriteria(dataSets, provider);
            if (result.size() <= 0 || (size = (best = Collections.max(result)).getCumulatedSize()) <= this.minArchiveSize) continue;
            if (size < this.maxArchiveSize) {
                return best.getList();
            }
            this.sortBySamples(best);
            return this.splitDatasets(best);
        }
        return Collections.emptyList();
    }

    private void sortBySamples(DatasetListWithTotal datasets) {
        datasets.sort((Comparator<AbstractExternalData>)new SimpleComparator<AbstractExternalData, String>(){

            @Override
            public String evaluate(AbstractExternalData data) {
                String sid1 = data.getSampleIdentifier();
                return sid1 == null ? "" : sid1;
            }
        });
    }

    private List<AbstractExternalData> splitDatasets(Iterable<AbstractExternalData> datasets) {
        DatasetListWithTotal result = new DatasetListWithTotal();
        for (AbstractExternalData ds : datasets) {
            if (result.getCumulatedSize() + ds.getSize() > this.maxArchiveSize) continue;
            result.add(ds);
        }
        return result.getList();
    }
}

