/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.logging.ISimpleLogger;
import ch.systemsx.cisd.common.utilities.IPause;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import ch.systemsx.cisd.common.utilities.IWaitingCondition;
import ch.systemsx.cisd.common.utilities.WaitingHelper;
import java.io.File;

public class FileBasedPause
implements IPause {
    private File pauseFile;
    private ITimeAndWaitingProvider timeAndWaitingProvider;
    private WaitingHelper waitingHelper;
    private String pausedActionDescriptionOrNull;

    public FileBasedPause(File pauseFile, long pauseFilePollingTime, ITimeAndWaitingProvider timeAndWaitingProvider, ISimpleLogger loggerOrNull, String pausedActionDescriptionOrNull) {
        this.pauseFile = pauseFile;
        this.timeAndWaitingProvider = timeAndWaitingProvider;
        this.pausedActionDescriptionOrNull = pausedActionDescriptionOrNull;
        this.waitingHelper = new WaitingHelper(null, pauseFilePollingTime, timeAndWaitingProvider, loggerOrNull, false);
    }

    @Override
    public long pause() {
        long startTime = this.timeAndWaitingProvider.getTimeInMilliseconds();
        this.waitingHelper.waitOn(new IWaitingCondition(){

            @Override
            public boolean conditionFulfilled() {
                return !FileBasedPause.this.pauseFile.exists();
            }

            public String toString() {
                if (this.conditionFulfilled()) {
                    return "Pause file '" + FileBasedPause.this.pauseFile + "' has been removed." + (FileBasedPause.this.pausedActionDescriptionOrNull == null ? "" : " The following action continues: " + FileBasedPause.this.pausedActionDescriptionOrNull);
                }
                return "Pause file '" + FileBasedPause.this.pauseFile + "' is present." + (FileBasedPause.this.pausedActionDescriptionOrNull == null ? "" : " The following action is paused: " + FileBasedPause.this.pausedActionDescriptionOrNull);
            }
        });
        return this.timeAndWaitingProvider.getTimeInMilliseconds() - startTime;
    }
}

