/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.ZipBasedHierarchicalContent;
import ch.systemsx.cisd.openbis.common.io.hierarchical_content.api.IHierarchicalContent;
import ch.systemsx.cisd.openbis.dss.archiveverifier.batch.VerificationError;
import ch.systemsx.cisd.openbis.dss.archiveverifier.verifier.ZipFileIntegrityVerifier;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.ZipDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import de.schlichtherle.io.rof.ReadOnlyFile;
import de.schlichtherle.io.rof.SimpleReadOnlyFile;
import de.schlichtherle.util.zip.BasicZipFile;
import de.schlichtherle.util.zip.ZipEntry;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.apache.commons.io.IOUtils;

public class ZipPackageManager
extends AbstractPackageManager {
    static final String COMPRESS_KEY = "compressing";
    private boolean compress;

    public ZipPackageManager(Properties properties) {
        this.compress = PropertyUtils.getBoolean(properties, COMPRESS_KEY, true);
    }

    @Override
    public String getName(String dataSetCode) {
        return String.valueOf(dataSetCode) + ".zip";
    }

    @Override
    protected AbstractDataSetPackager createPackager(File packageFile, DataSetExistenceChecker existenceChecker) {
        return new ZipDataSetPackager(packageFile, this.compress, this.getContentProvider(), existenceChecker);
    }

    @Override
    public List<VerificationError> verify(File packageFile) {
        return new ZipFileIntegrityVerifier().verify(packageFile);
    }

    @Override
    public Status extract(File packageFile, File toDirectory) {
        BasicZipFile zipFile = null;
        FileOutputStream fileOutputStream = null;
        try {
            zipFile = new BasicZipFile((ReadOnlyFile)new SimpleReadOnlyFile(packageFile), "UTF-8", true, false);
            Enumeration entries = zipFile.entries();
            while (entries.hasMoreElements()) {
                ZipEntry entry = (ZipEntry)entries.nextElement();
                File outputFile = new File(toDirectory, entry.getName());
                if (!entry.isDirectory()) {
                    if ("meta-data.tsv".equals(entry.getName())) continue;
                    outputFile.getParentFile().mkdirs();
                    BufferedInputStream inputStream = new BufferedInputStream(zipFile.getInputStream(entry));
                    fileOutputStream = new FileOutputStream(outputFile);
                    BufferedOutputStream outputStream = new BufferedOutputStream(fileOutputStream);
                    try {
                        IOUtils.copyLarge((InputStream)inputStream, (OutputStream)outputStream);
                        continue;
                    }
                    finally {
                        IOUtils.closeQuietly((InputStream)inputStream);
                        IOUtils.closeQuietly((OutputStream)outputStream);
                    }
                }
                if (outputFile.isFile()) {
                    throw new EnvironmentFailureException("Could not extract directory '" + outputFile + "' because it exists already as a plain file.");
                }
                outputFile.mkdirs();
            }
            Status status = Status.OK;
            return status;
        }
        catch (Exception ex) {
            Status status = Status.createError(ex.toString());
            return status;
        }
        finally {
            if (zipFile != null) {
                try {
                    zipFile.close();
                }
                catch (IOException ex) {
                    throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
                }
            }
            IOUtils.closeQuietly(fileOutputStream);
        }
    }

    @Override
    public IHierarchicalContent asHierarchialContent(File packageFile, boolean onlyMetaData) {
        return new ZipBasedHierarchicalContent(packageFile);
    }
}

