/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.archiver;

import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.mail.EMailAddress;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.common.mail.IMailClientProvider;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.common.time.DateTimeUtils;
import ch.systemsx.cisd.common.utilities.ITimeAndWaitingProvider;
import java.io.File;
import java.io.FileFilter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.Properties;
import org.apache.log4j.Logger;

public class FileDeleter {
    public static final String FILE_TYPE = ".deletionrequest";
    public static final String TIMESTAMP_FORMAT = "yyyyMMdd-HHmmss";
    public static final String DELETION_POLLING_TIME_KEY = "deletion-polling-time";
    private static final long DEFAULT_DELETION_POLLING_TIME = 600000L;
    public static final String DELETION_TIME_OUT_KEY = "deletion-time-out";
    private static final long DEFAULT_DELETION_TIME_OUT = 86400000L;
    public static final String EMAIL_ADDRESS_KEY = "email-address";
    public static final String EMAIL_FROM_ADDRESS_KEY = "email-from-address";
    public static final String EMAIL_SUBJECT_KEY = "email-subject";
    public static final String EMAIL_TEMPLATE_KEY = "email-template";
    public static final String FILE_LIST_VARIABLE = "file-list";
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, FileDeleter.class);
    static final Template THREAD_NAME_TEMPLATE = new Template("File Deleter (${directory})");
    private static final FileFilter FILE_FILTER = new FileFilter(){

        @Override
        public boolean accept(File file) {
            return file.getName().endsWith(FileDeleter.FILE_TYPE);
        }
    };
    private final SimpleDateFormat timestampFormat = new SimpleDateFormat("yyyyMMdd-HHmmss");
    private final File directory;
    private final ITimeAndWaitingProvider timeProvider;
    private final IMailClientProvider eMailClientProvider;
    private final long pollingTime;
    private final long timeOut;
    private String emailOrNull;
    private String emailTemplate;
    private String emailSubject;
    private String emailFromAddressOrNull;
    private int counter;
    private boolean started;
    private long threadStartTime;

    public FileDeleter(File directory, ITimeAndWaitingProvider timeProvider, IMailClientProvider eMailClientProvider, Properties properties) {
        this.eMailClientProvider = eMailClientProvider;
        assert (directory.isDirectory());
        this.directory = directory;
        this.timeProvider = timeProvider;
        this.pollingTime = DateTimeUtils.getDurationInMillis(properties, DELETION_POLLING_TIME_KEY, 600000L);
        this.timeOut = DateTimeUtils.getDurationInMillis(properties, DELETION_TIME_OUT_KEY, 86400000L);
        this.emailOrNull = PropertyUtils.getProperty(properties, EMAIL_ADDRESS_KEY);
        if (this.emailOrNull != null) {
            this.emailTemplate = PropertyUtils.getMandatoryProperty(properties, EMAIL_TEMPLATE_KEY);
            this.emailSubject = PropertyUtils.getMandatoryProperty(properties, EMAIL_SUBJECT_KEY);
            this.emailFromAddressOrNull = properties.getProperty(EMAIL_FROM_ADDRESS_KEY);
        }
    }

    public synchronized void start() {
        if (this.started) {
            return;
        }
        this.started = true;
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileDeleter.this.polling();
            }
        };
        Template template = THREAD_NAME_TEMPLATE.createFreshCopy();
        template.attemptToBind("directory", this.directory.toString());
        new Thread(null, runnable, template.createText()).start();
    }

    public void requestDeletion(File file) {
        operationLog.info((Object)("Schedule for deletion: " + file));
        String timestamp = new SimpleDateFormat(TIMESTAMP_FORMAT).format(new Date(this.timeProvider.getTimeInMilliseconds()));
        String deletionRequestFileName = String.valueOf(timestamp) + "_" + ++this.counter + FILE_TYPE;
        File deletionRequestFile = new File(this.directory, deletionRequestFileName);
        File stagedDeletionRequestFile = new File(this.directory, String.valueOf(deletionRequestFileName) + ".staged");
        FileUtilities.writeToFile(stagedDeletionRequestFile, file.getAbsolutePath());
        stagedDeletionRequestFile.renameTo(deletionRequestFile);
        operationLog.info((Object)("Deletion request file for '" + file + "': " + deletionRequestFile));
    }

    public void stop() {
        this.started = false;
    }

    private void polling() {
        this.threadStartTime = this.timeProvider.getTimeInMilliseconds();
        while (this.started) {
            Object[] files = this.directory.listFiles(FILE_FILTER);
            Arrays.sort(files);
            StringBuilder builder = new StringBuilder();
            Object[] objectArray = files;
            int n = files.length;
            int n2 = 0;
            while (n2 < n) {
                Object deletionRequestFile = objectArray[n2];
                this.handle((File)deletionRequestFile, builder);
                ++n2;
            }
            if (this.emailOrNull != null && builder.length() > 0) {
                Template template = new Template(this.emailTemplate);
                template.attemptToBind(FILE_LIST_VARIABLE, builder.toString());
                String emailMessage = template.createText();
                IMailClient mailClient = this.eMailClientProvider.getMailClient();
                mailClient.sendEmailMessage(this.emailSubject, emailMessage, new EMailAddress(this.emailOrNull), new EMailAddress(this.emailFromAddressOrNull), new EMailAddress[0]);
            }
            this.timeProvider.sleep(this.pollingTime);
        }
    }

    private void handle(File deletionRequestFile, StringBuilder builder) {
        Long fileTime = this.getFileTime(deletionRequestFile);
        if (fileTime != null) {
            long time = this.timeProvider.getTimeInMilliseconds();
            long deletionTime = time - fileTime;
            File file = new File(FileUtilities.loadToString(deletionRequestFile).trim());
            if (this.delete(file)) {
                operationLog.info((Object)("Successfully deleted: " + file));
                if (!deletionRequestFile.delete()) {
                    operationLog.warn((Object)("Couldn't delete deletion request file: " + deletionRequestFile));
                }
            } else if (deletionTime > this.timeOut) {
                String message = file + "\n   Deletion requested at " + new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(fileTime) + " (" + DateTimeUtils.renderDuration(deletionTime) + " elapsed)";
                operationLog.warn((Object)message);
                long timeSinceStart = time - this.threadStartTime;
                if (timeSinceStart > this.timeOut && timeSinceStart % this.timeOut < this.pollingTime) {
                    builder.append(message).append('\n');
                }
            }
        }
    }

    private Long getFileTime(File trackingFile) {
        try {
            return this.timestampFormat.parse(trackingFile.getName().split("_")[0]).getTime();
        }
        catch (ParseException parseException) {
            return null;
        }
    }

    protected boolean delete(File file) {
        IFileOperations fileOperations;
        block3: {
            try {
                fileOperations = FileOperations.getMonitoredInstanceForCurrentThread();
                if (!fileOperations.delete(file)) break block3;
                return true;
            }
            catch (Throwable throwable) {
                return false;
            }
        }
        return !fileOperations.exists(file);
    }
}

