/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.locator;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.IViewLocatorResolver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.locator.ViewLocator;
import ch.systemsx.cisd.openbis.generic.client.web.client.exception.UserFailureException;
import com.google.gwt.user.client.rpc.AsyncCallback;
import java.util.ArrayList;

public class ViewLocatorResolverRegistry {
    private final ArrayList<IViewLocatorResolver> handlers = new ArrayList();

    public void registerHandler(IViewLocatorResolver handler) {
        this.handlers.add(handler);
    }

    public void handleLocator(ViewLocator locator) throws UserFailureException {
        for (IViewLocatorResolver handler : this.handlers) {
            if (!handler.canHandleLocator(locator)) continue;
            handler.resolve(locator);
            break;
        }
    }

    public void locatorExists(ViewLocator locator, AsyncCallback<Void> callback) {
        for (IViewLocatorResolver handler : this.handlers) {
            if (!handler.canHandleLocator(locator)) continue;
            handler.locatorExists(locator, callback);
            return;
        }
        callback.onFailure(null);
    }

    public boolean canResolve(ViewLocator locator) throws UserFailureException {
        for (IViewLocatorResolver handler : this.handlers) {
            if (!handler.canHandleLocator(locator)) continue;
            return true;
        }
        return false;
    }
}

