/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script;

import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.AbstractRegistrationForm;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.DescriptionField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.MultilineVarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.ScriptField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.field.VarcharField;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property_type.ScriptTypeSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.EntityKindSelectionWidget;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.IValidable;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.script.ScriptExecutionFramework;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.AbstractRegistrationDialog;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.widget.FieldUtil;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PluginType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Script;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ScriptType;
import com.extjs.gxt.ui.client.event.BaseEvent;
import com.extjs.gxt.ui.client.event.ButtonEvent;
import com.extjs.gxt.ui.client.event.Events;
import com.extjs.gxt.ui.client.event.Listener;
import com.extjs.gxt.ui.client.event.SelectionChangedEvent;
import com.extjs.gxt.ui.client.event.SelectionChangedListener;
import com.extjs.gxt.ui.client.event.SelectionListener;
import com.extjs.gxt.ui.client.widget.Component;
import com.extjs.gxt.ui.client.widget.form.Field;
import com.extjs.gxt.ui.client.widget.form.FormPanel;
import com.extjs.gxt.ui.client.widget.form.SimpleComboValue;
import com.extjs.gxt.ui.client.widget.form.TextField;
import com.extjs.gxt.ui.client.widget.form.Validator;
import com.extjs.gxt.ui.client.widget.toolbar.LabelToolItem;
import com.extjs.gxt.ui.client.widget.toolbar.ToolBar;
import com.google.gwt.user.client.Element;
import com.google.gwt.user.client.ui.Widget;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractScriptEditRegisterForm
extends AbstractRegistrationForm {
    protected final IViewContext<ICommonClientServiceAsync> viewContext;
    protected final ScriptTypeSelectionWidget scriptTypeChooserOrNull;
    protected final TextField<String> nameField;
    protected final DescriptionField descriptionField;
    protected final MultilineVarcharField scriptField;
    protected EntityKindSelectionWidget entityKindField;
    protected ScriptExecutionFramework scriptExecution;
    protected VarcharField entityKindListField;
    private static Map<ScriptType, Validator> validatorsByScriptType = new HashMap<ScriptType, Validator>();
    private static final String NEWLINE = "\n";

    static {
        validatorsByScriptType.put(ScriptType.DYNAMIC_PROPERTY, new DynamicPropertyScriptValidator());
        validatorsByScriptType.put(ScriptType.MANAGED_PROPERTY, new ManagedPropertyScriptValidator());
        validatorsByScriptType.put(ScriptType.ENTITY_VALIDATION, new EntityValidationScriptValidator());
    }

    protected abstract void saveScript();

    protected abstract void setValues();

    protected abstract Script getScript();

    protected AbstractScriptEditRegisterForm(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKindOrNull) {
        this(viewContext, null, entityKindOrNull);
    }

    public AbstractScriptEditRegisterForm(IViewContext<ICommonClientServiceAsync> viewContext, ScriptTypeSelectionWidget scriptTypeChooser, EntityKind entityKindOrNull) {
        this(viewContext, null, scriptTypeChooser, entityKindOrNull);
    }

    protected AbstractScriptEditRegisterForm(IViewContext<ICommonClientServiceAsync> viewContext, TechId scriptIdOrNull, ScriptTypeSelectionWidget scriptTypeChooserOrNull, EntityKind entityKindOrNull) {
        super(viewContext, AbstractScriptEditRegisterForm.createId(scriptIdOrNull), 120, 500);
        this.viewContext = viewContext;
        this.scriptTypeChooserOrNull = scriptTypeChooserOrNull;
        if (scriptTypeChooserOrNull != null) {
            ToolBar toolBar = null;
            toolBar = new ToolBar();
            this.setTopComponent((Component)toolBar);
            scriptTypeChooserOrNull.setWidth(200);
            toolBar.add((Component)new LabelToolItem(String.valueOf(scriptTypeChooserOrNull.getFieldLabel()) + ":"));
            toolBar.add((Component)scriptTypeChooserOrNull);
            scriptTypeChooserOrNull.addSelectionChangedListener(this.createScriptTypeChangedListener());
        }
        this.nameField = new VarcharField(viewContext.getMessage("name", new Object[0]), true);
        this.nameField.setId(String.valueOf(this.getId()) + "-script-registration-name");
        this.scriptExecution = new ScriptExecutionFramework(viewContext, this.asValidable(this.formPanel), entityKindOrNull);
        this.entityKindListField = new VarcharField(viewContext.getMessage("entity_kind", new Object[0]), false);
        this.entityKindListField.setVisible(false);
        this.entityKindField = new EntityKindSelectionWidget(viewContext, entityKindOrNull, scriptIdOrNull == null, true);
        this.entityKindField.addSelectionChangedListener((SelectionChangedListener)new SelectionChangedListener<SimpleComboValue<String>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<String>> se) {
                AbstractScriptEditRegisterForm.this.scriptExecution.updateEntityKind(AbstractScriptEditRegisterForm.this.entityKindField.tryGetEntityKind());
            }
        });
        this.entityKindField.setId(String.valueOf(this.getId()) + "-script-registration-entity-kind");
        this.descriptionField = AbstractRegistrationDialog.createDescriptionField(viewContext);
        this.descriptionField.setId(String.valueOf(this.getId()) + "-script-registration-description");
        this.scriptField = AbstractScriptEditRegisterForm.createScriptField(viewContext);
        this.scriptField.setId(String.valueOf(this.getId()) + "-script-registration-script-content");
        Listener<BaseEvent> scriptParametersListener = new Listener<BaseEvent>(){

            public void handleEvent(BaseEvent be) {
                PluginType pluginTypeOrNull = null;
                AbstractScriptEditRegisterForm.this.scriptExecution.update((String)AbstractScriptEditRegisterForm.this.nameField.getValue(), (String)AbstractScriptEditRegisterForm.this.scriptField.getValue(), pluginTypeOrNull);
            }
        };
        this.scriptField.addListener(Events.Change, (Listener)scriptParametersListener);
        this.nameField.addListener(Events.Change, (Listener)scriptParametersListener);
    }

    private SelectionChangedListener<SimpleComboValue<ScriptType>> createScriptTypeChangedListener() {
        return new SelectionChangedListener<SimpleComboValue<ScriptType>>(){

            public void selectionChanged(SelectionChangedEvent<SimpleComboValue<ScriptType>> se) {
                SimpleComboValue selectedItem = (SimpleComboValue)se.getSelectedItem();
                if (selectedItem != null) {
                    AbstractScriptEditRegisterForm.this.onPluginOrScriptTypeChanged(PluginType.JYTHON, (ScriptType)selectedItem.getValue());
                }
            }
        };
    }

    protected void onPluginOrScriptTypeChanged(PluginType pluginType, ScriptType scriptType) {
        boolean pluginTypeIsPython = pluginType == PluginType.JYTHON;
        this.nameField.setVisible(pluginTypeIsPython);
        FieldUtil.setMandatoryFlag(this.nameField, pluginTypeIsPython);
        this.entityKindField.setVisible(pluginTypeIsPython);
        this.entityKindListField.setVisible(!pluginTypeIsPython);
        this.scriptField.setVisible(pluginTypeIsPython);
        this.scriptField.setEnabled(pluginTypeIsPython);
        this.rightPanel.setVisible(scriptType == ScriptType.DYNAMIC_PROPERTY || scriptType == ScriptType.ENTITY_VALIDATION);
        this.scriptExecution.setScriptType(scriptType);
        if (pluginTypeIsPython) {
            this.scriptField.setValidator(validatorsByScriptType.get(scriptType));
        } else {
            this.scriptField.setValidator(null);
        }
        this.scriptExecution.update((String)this.nameField.getValue(), (String)this.scriptField.getValue(), pluginType);
    }

    private IValidable asValidable(final FormPanel panel) {
        return new IValidable(){

            @Override
            public boolean isValid() {
                return panel.isValid();
            }
        };
    }

    private static MultilineVarcharField createScriptField(IViewContext<ICommonClientServiceAsync> viewContext) {
        ScriptField field = new ScriptField(viewContext);
        field.setFireChangeEventOnSetValue(true);
        return field;
    }

    public static String createId(TechId id) {
        String editOrRegister = id == null ? "register" : "edit_" + id;
        return "openbis_script-" + editOrRegister + "_form";
    }

    @Override
    protected void resetPanel() {
        super.resetPanel();
        this.nameField.reset();
    }

    private final void addFormFields() {
        this.formPanel.add((Widget)this.nameField);
        this.formPanel.add((Widget)this.entityKindListField);
        this.formPanel.add((Widget)this.entityKindField);
        this.formPanel.add((Widget)this.descriptionField);
        this.formPanel.add((Widget)this.scriptField);
        this.rightPanel.add(this.scriptExecution.getWidget());
        this.redefineSaveListeners();
    }

    void redefineSaveListeners() {
        this.saveButton.removeAllListeners();
        this.addSaveButtonConfirmationListener();
        this.saveButton.addSelectionListener((SelectionListener)new SelectionListener<ButtonEvent>(){

            public final void componentSelected(ButtonEvent ce) {
                if (AbstractScriptEditRegisterForm.this.formPanel.isValid()) {
                    AbstractScriptEditRegisterForm.this.saveScript();
                }
            }
        });
    }

    @Override
    protected final void submitValidForm() {
    }

    protected final void onRender(Element target, int index) {
        super.onRender(target, index);
        this.setLoading(true);
        this.loadForm();
    }

    protected abstract void loadForm();

    protected void initGUI() {
        this.setValues();
        this.addFormFields();
        this.setLoading(false);
        this.layout();
    }

    private static class DynamicPropertyScriptValidator
    implements Validator {
        private static final String CALCULATE_DEFINITION = "def calculate():";
        private static final String CALCULATE_DEFINITION_NOT_FOUND_MSG = "Multiline script should contain definition of 'calculate()' function.";

        private DynamicPropertyScriptValidator() {
        }

        public String validate(Field<?> field, String fieldValue) {
            if (fieldValue.contains(AbstractScriptEditRegisterForm.NEWLINE)) {
                String[] lines;
                String[] stringArray = lines = fieldValue.split(AbstractScriptEditRegisterForm.NEWLINE);
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line = stringArray[n2];
                    if (line.startsWith(CALCULATE_DEFINITION)) {
                        return null;
                    }
                    ++n2;
                }
                return CALCULATE_DEFINITION_NOT_FOUND_MSG;
            }
            return null;
        }
    }

    private static class EntityValidationScriptValidator
    implements Validator {
        private static final String VALIDATE_DEFINITION = "def validate(";
        private static final String VALIDATE_DEFINITION_NOT_FOUND_MSG = "Script should contain definition of function 'validate(entity, is_new)'";

        private EntityValidationScriptValidator() {
        }

        public String validate(Field<?> field, String fieldValue) {
            String[] lines;
            String[] stringArray = lines = fieldValue.split(AbstractScriptEditRegisterForm.NEWLINE);
            int n = lines.length;
            int n2 = 0;
            while (n2 < n) {
                String line = stringArray[n2];
                if (line.startsWith(VALIDATE_DEFINITION)) {
                    return null;
                }
                ++n2;
            }
            return VALIDATE_DEFINITION_NOT_FOUND_MSG;
        }
    }

    private static class ManagedPropertyScriptValidator
    implements Validator {
        private ManagedPropertyScriptValidator() {
        }

        public String validate(Field<?> field, String value) {
            return null;
        }
    }
}

