/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.server.resultset;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.IOriginalDataProvider;
import ch.systemsx.cisd.openbis.generic.client.web.server.resultset.ITableModelProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelColumnHeader;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TypedTableModel;
import java.io.Serializable;
import java.util.Collections;
import java.util.List;

public final class DataProviderAdapter<T extends Serializable>
implements IOriginalDataProvider<TableModelRowWithObject<T>> {
    private final ITableModelProvider<T> provider;
    private TypedTableModel<T> tableModel;

    public DataProviderAdapter(ITableModelProvider<T> provider) {
        this.provider = provider;
    }

    @Override
    public List<TableModelRowWithObject<T>> getOriginalData(int maxSize) throws UserFailureException {
        this.tableModel = this.provider.getTableModel(maxSize);
        return this.tableModel.getRows();
    }

    @Override
    public List<TableModelColumnHeader> getHeaders() {
        return this.tableModel == null ? Collections.emptyList() : this.tableModel.getHeader();
    }
}

