/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.logging.LogInitializer;
import ch.systemsx.cisd.common.process.ProcessExecutionHelper;
import ch.systemsx.cisd.common.string.Template;
import ch.systemsx.cisd.dbmigration.postgresql.DumpPreparator;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.FullTextIndexerRunnable;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.HibernateSearchContext;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IFullTextIndexUpdater;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexMode;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.time.StopWatch;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.springframework.context.support.AbstractApplicationContext;
import org.springframework.context.support.ClassPathXmlApplicationContext;

public final class IndexCreationUtil {
    static final String DATABASE_NAME_PREFIX = "openbis_";
    private static final Template DROP_DATABASE_TEMPLATE = new Template("drop database if exists ${duplicated-database}");
    private static final Template CREATE_DATABASE_TEMPLATE = new Template("create database ${duplicated-database} with owner ${owner} template ${database}");
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, IndexCreationUtil.class);
    private static HibernateSearchContext hibernateSearchContext;
    private static AbstractApplicationContext applicationContext;

    private IndexCreationUtil() {
    }

    private static final AbstractApplicationContext getApplicationContext() {
        if (applicationContext == null) {
            ClassPathXmlApplicationContext appC = new ClassPathXmlApplicationContext(new String[]{"applicationContext.xml"}, true);
            applicationContext = appC;
        }
        return applicationContext;
    }

    private static final void createAndRunFullTextIndexer() throws Exception {
        AbstractApplicationContext factory = IndexCreationUtil.getApplicationContext();
        IFullTextIndexUpdater updater = IndexCreationUtil.createDummyUpdater();
        FullTextIndexerRunnable fullTextIndexer = new FullTextIndexerRunnable((SessionFactory)factory.getBean("hibernate-session-factory"), hibernateSearchContext, updater);
        fullTextIndexer.run();
    }

    private static final IFullTextIndexUpdater createDummyUpdater() {
        return new IFullTextIndexUpdater(){

            @Override
            public void clear() {
            }

            @Override
            public void start() {
            }

            @Override
            public void scheduleUpdate(IndexUpdateOperation entities) {
            }
        };
    }

    private static final HibernateSearchContext createHibernateSearchContext(String indexFolder) {
        HibernateSearchContext context = new HibernateSearchContext();
        context.setIndexBase(indexFolder);
        context.setIndexMode(IndexMode.INDEX_FROM_SCRATCH);
        return context;
    }

    public static void main(String ... args) throws Exception {
        Parameters parameters = IndexCreationUtil.parseArguments(args);
        LogInitializer.init();
        if (parameters.getDuplicatedDatabaseKind() != null) {
            IndexCreationUtil.dumpDatabase(parameters);
        }
        IndexCreationUtil.performIsolatedIndexing(parameters);
        IndexCreationUtil.releaseResources();
    }

    private static void dumpDatabase(Parameters parameters) {
        String databaseKind = parameters.getDatabaseKind();
        String duplicatedDatabaseKind = parameters.getDuplicatedDatabaseKind();
        String indexFolder = parameters.getIndexFolder();
        String databaseName = DATABASE_NAME_PREFIX + databaseKind;
        String duplicatedDatabaseName = DATABASE_NAME_PREFIX + duplicatedDatabaseKind;
        boolean ok = IndexCreationUtil.duplicateDatabase(duplicatedDatabaseName, databaseName);
        if (!ok) {
            throw new IllegalStateException("Execution failed");
        }
        File dumpFile = parameters.getDumpFile();
        operationLog.info((Object)("Dump '" + duplicatedDatabaseName + "' into '" + dumpFile + "'."));
        DumpPreparator.createDatabaseDump(duplicatedDatabaseName, dumpFile);
        databaseKind = duplicatedDatabaseKind;
        FileUtilities.deleteRecursively(new File(indexFolder));
    }

    private static Parameters parseArguments(String ... args) {
        Parameters parameters = null;
        try {
            parameters = new Parameters(args);
        }
        catch (IllegalArgumentException e) {
            System.out.println(Parameters.getUsage());
            throw e;
        }
        return parameters;
    }

    private static void releaseResources() {
        applicationContext.stop();
        applicationContext.close();
        applicationContext.destroy();
    }

    private static void performIsolatedIndexing(Parameters parameters) throws Exception {
        String databaseKind = parameters.getDatabaseKind();
        String indexFolder = parameters.getIndexFolder();
        System.setProperty("database.kind", databaseKind);
        System.setProperty("hibernate.search.index-mode", "NO_INDEX");
        System.setProperty("hibernate.search.index-base", indexFolder);
        System.setProperty("database.create-from-scratch", parameters.getFromScratch());
        IndexCreationUtil.performAndTimeIndexing(databaseKind, indexFolder);
    }

    private static void performAndTimeIndexing(String databaseKind, String indexFolder) throws Exception {
        hibernateSearchContext = IndexCreationUtil.createHibernateSearchContext(indexFolder);
        hibernateSearchContext.afterPropertiesSet();
        operationLog.info((Object)"=========== Start indexing ===========");
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        IndexCreationUtil.createAndRunFullTextIndexer();
        stopWatch.stop();
        operationLog.info((Object)("Index of database 'openbis_" + databaseKind + "' successfully built in '" + indexFolder + "' after " + (stopWatch.getTime() + 30000L) / 60000L + " minutes."));
    }

    static boolean duplicateDatabase(String destinationDatabase, String sourceDatabase) {
        operationLog.info((Object)("Duplicate database '" + sourceDatabase + "' as '" + destinationDatabase + "'."));
        Template dropCmd = DROP_DATABASE_TEMPLATE.createFreshCopy();
        dropCmd.bind("duplicated-database", destinationDatabase);
        boolean ok = IndexCreationUtil.execute(dropCmd);
        if (!ok) {
            return false;
        }
        Template createCmd = CREATE_DATABASE_TEMPLATE.createFreshCopy();
        createCmd.bind("database", sourceDatabase);
        createCmd.bind("duplicated-database", destinationDatabase);
        createCmd.bind("owner", System.getProperty("user.name"));
        return IndexCreationUtil.execute(createCmd);
    }

    private static boolean execute(Template template) {
        String sql = template.createText();
        String psql = DumpPreparator.getPSQLExecutable();
        List<String> cmd = Arrays.asList(psql, "-U", "postgres", "-c", sql);
        boolean ok = ProcessExecutionHelper.runAndLog(cmd, operationLog, operationLog);
        if (!ok) {
            operationLog.error((Object)("Sql command execution failed: " + template.createText()));
        }
        return ok;
    }

    private static class Parameters {
        private String duplicatedDatabaseKind;
        private File dumpFile;
        private String databaseKind;
        private String indexFolder = "sourceTest/lucene/indices";
        private String fromScratch;

        static String getUsage() {
            return "Usage: java " + IndexCreationUtil.class.getName() + " [-d <duplicated database kind> <dump file>] <database kind> [<index folder>]";
        }

        Parameters(String[] args) {
            ArrayList<String> arguments = new ArrayList<String>(Arrays.asList(args));
            if (arguments.size() > 0 && ((String)arguments.get(0)).equals("-d")) {
                arguments.remove(0);
                this.throwExceptionIfEmpty(arguments, "duplicated database kind");
                this.duplicatedDatabaseKind = (String)arguments.remove(0);
                this.throwExceptionIfEmpty(arguments, "dump file");
                this.dumpFile = new File((String)arguments.remove(0));
            }
            this.throwExceptionIfEmpty(arguments, "database kind");
            this.databaseKind = (String)arguments.remove(0);
            if (arguments.size() > 0) {
                this.indexFolder = (String)arguments.remove(0);
            }
            this.fromScratch = arguments.isEmpty() ? "false" : (String)arguments.remove(0);
        }

        private void throwExceptionIfEmpty(List<String> arguments, String entityType) {
            if (arguments.size() < 1) {
                throw new IllegalArgumentException("Missing argument <" + entityType + ">.");
            }
        }

        final File getDumpFile() {
            return this.dumpFile;
        }

        final String getDuplicatedDatabaseKind() {
            return this.duplicatedDatabaseKind;
        }

        final String getDatabaseKind() {
            return this.databaseKind;
        }

        final String getIndexFolder() {
            return this.indexFolder;
        }

        final String getFromScratch() {
            return this.fromScratch;
        }
    }
}

