/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections.map;

import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.collections.Unmodifiable;
import org.apache.commons.collections.iterators.AbstractIteratorDecorator;
import org.apache.commons.collections.keyvalue.AbstractMapEntryDecorator;
import org.apache.commons.collections.set.AbstractSetDecorator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class UnmodifiableEntrySet<K, V>
extends AbstractSetDecorator<Map.Entry<K, V>>
implements Unmodifiable {
    public static <K, V> Set<Map.Entry<K, V>> decorate(Set<Map.Entry<K, V>> set) {
        if (set instanceof Unmodifiable) {
            return set;
        }
        return new UnmodifiableEntrySet<K, V>(set);
    }

    private UnmodifiableEntrySet(Set<Map.Entry<K, V>> set) {
        super(set);
    }

    @Override
    public boolean add(Map.Entry<K, V> object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean addAll(Collection<? extends Map.Entry<K, V>> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean removeAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean retainAll(Collection<?> coll) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Iterator<Map.Entry<K, V>> iterator() {
        return new UnmodifiableEntrySetIterator(this.collection.iterator());
    }

    @Override
    public Object[] toArray() {
        Object[] array = this.collection.toArray();
        int i = 0;
        while (i < array.length) {
            array[i] = new UnmodifiableEntry((Map.Entry)array[i]);
            ++i;
        }
        return array;
    }

    @Override
    public <T> T[] toArray(T[] array) {
        Object[] result = array;
        if (array.length > 0) {
            result = (Object[])Array.newInstance(array.getClass().getComponentType(), 0);
        }
        result = this.collection.toArray(result);
        ArrayList newCollection = new ArrayList();
        int i = 0;
        while (i < result.length) {
            newCollection.add(new UnmodifiableEntry((Map.Entry)result[i]));
            ++i;
        }
        if ((result = newCollection.toArray(result)).length > array.length) {
            return result;
        }
        System.arraycopy(result, 0, array, 0, result.length);
        if (array.length > result.length) {
            array[result.length] = null;
        }
        return array;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnmodifiableEntry<K, V>
    extends AbstractMapEntryDecorator<K, V> {
        protected UnmodifiableEntry(Map.Entry<K, V> entry) {
            super(entry);
        }

        @Override
        public V setValue(V obj) {
            throw new UnsupportedOperationException();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class UnmodifiableEntrySetIterator<K, V>
    extends AbstractIteratorDecorator<Map.Entry<K, V>> {
        protected UnmodifiableEntrySetIterator(Iterator<Map.Entry<K, V>> iterator) {
            super(iterator);
        }

        @Override
        public Map.Entry<K, V> next() {
            Map.Entry entry = (Map.Entry)this.iterator.next();
            return new UnmodifiableEntry(entry);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

