/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.jython.v2;

import ch.systemsx.cisd.etlserver.TopLevelDataSetRegistratorGlobalState;
import ch.systemsx.cisd.etlserver.registrator.DataSetRegistrationContext;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDSSRegistrationLogger;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSet;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IDataSetUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IExperiment;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IExperimentUpdatable;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IMaterial;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IMetaproject;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IProject;
import ch.systemsx.cisd.etlserver.registrator.api.v2.ISample;
import ch.systemsx.cisd.etlserver.registrator.api.v2.ISpace;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IVocabulary;
import ch.systemsx.cisd.etlserver.registrator.api.v2.IVocabularyTerm;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.SimpleImageDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.FeatureListDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IFeatureVectorDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IImageDataSet;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.IImagingDataSetRegistrationTransactionV2;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.v2.SimpleFeatureVectorDataConfig;
import ch.systemsx.cisd.openbis.dss.etl.jython.v2.ImagingDataSetRegistrationTransaction;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IAttachmentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IDataSetImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExperimentImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IExternalDataManagementSystemImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IMaterialImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IProjectImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISampleImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISearchService;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.ISpaceImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.IVocabularyImmutable;
import ch.systemsx.cisd.openbis.dss.generic.shared.api.internal.v2.authorization.IAuthorizationService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.RoleWithHierarchy;
import java.io.File;
import java.io.InputStream;
import java.util.List;
import net.lemnik.eodsql.DynamicTransactionQuery;

public class ImagingDataSetRegistrationTransactionV2Delegate
implements IImagingDataSetRegistrationTransactionV2 {
    private final ImagingDataSetRegistrationTransaction transaction;

    public ImagingDataSetRegistrationTransactionV2Delegate(ImagingDataSetRegistrationTransaction transaction) {
        this.transaction = transaction;
    }

    @Override
    public IImageDataSet createNewImageDataSet(SimpleImageDataConfig imageDataSet, File incomingFolderWithImages) {
        return this.transaction.createNewImageDataSet(imageDataSet, incomingFolderWithImages);
    }

    @Override
    public IImageDataSet createNewImageDataSetAndMoveFile(SimpleImageDataConfig imageDataSet, File incomingFolderWithImages) {
        IImageDataSet dataSet = this.transaction.createNewImageDataSet(imageDataSet, incomingFolderWithImages);
        this.transaction.moveFile(incomingFolderWithImages.getPath(), dataSet);
        return dataSet;
    }

    @Override
    public IDataSet createNewOverviewImageDataSet(SimpleImageDataConfig imageDataSet, File incomingFolderWithImages) {
        return this.transaction.createNewOverviewImageDataSet(imageDataSet, incomingFolderWithImages);
    }

    @Override
    public IFeatureVectorDataSet createNewFeatureVectorDataSet(SimpleFeatureVectorDataConfig featureDataSetConfig, File featureVectorFileOrNull) {
        return this.transaction.createNewFeatureVectorDataSet(featureDataSetConfig, featureVectorFileOrNull);
    }

    public IDataSet createNewDataSet() {
        return this.transaction.createNewDataSet();
    }

    public IDataSet createNewDataSet(String dataSetType) {
        return this.transaction.createNewDataSet(dataSetType);
    }

    public IDataSet createNewDataSet(String dataSetType, String dataSetCode) {
        return this.transaction.createNewDataSet(dataSetType, dataSetCode);
    }

    public IDataSetImmutable getDataSet(String dataSetCode) {
        return this.transaction.getDataSet(dataSetCode);
    }

    public IDataSetUpdatable getDataSetForUpdate(String dataSetCode) {
        return this.transaction.getDataSetForUpdate(dataSetCode);
    }

    public IDataSetUpdatable makeDataSetMutable(IDataSetImmutable dataSet) {
        return this.transaction.makeDataSetMutable(dataSet);
    }

    public ISampleImmutable getSample(String sampleIdentifierString) {
        return this.transaction.getSample(sampleIdentifierString);
    }

    public ISample getSampleForUpdate(String sampleIdentifierString) {
        return this.transaction.getSampleForUpdate(sampleIdentifierString);
    }

    public ISample makeSampleMutable(ISampleImmutable sample) {
        return this.transaction.makeSampleMutable(sample);
    }

    public ISample createNewSample(String sampleIdentifierString, String sampleTypeCode) {
        return this.transaction.createNewSample(sampleIdentifierString, sampleTypeCode);
    }

    public ISample createNewSampleWithGeneratedCode(String spaceCode, String sampleTypeCode) {
        return this.transaction.createNewSampleWithGeneratedCode(spaceCode, sampleTypeCode);
    }

    public IExperimentImmutable getExperiment(String experimentIdentifierString) {
        return this.transaction.getExperiment(experimentIdentifierString);
    }

    public IExperimentUpdatable getExperimentForUpdate(String experimentIdentifierString) {
        return this.transaction.getExperimentForUpdate(experimentIdentifierString);
    }

    public IExperimentUpdatable makeExperimentMutable(IExperimentImmutable experiment) {
        return this.transaction.makeExperimentMutable(experiment);
    }

    public IExperiment createNewExperiment(String experimentIdentifierString, String experimentTypeCode) {
        return this.transaction.createNewExperiment(experimentIdentifierString, experimentTypeCode);
    }

    public IProject createNewProject(String projectIdentifier) {
        return this.transaction.createNewProject(projectIdentifier);
    }

    public IProjectImmutable getProject(String projectIdentifier) {
        return this.transaction.getProject(projectIdentifier);
    }

    public IProject getProjectForUpdate(String projectIdentifier) {
        return this.transaction.getProjectForUpdate(projectIdentifier);
    }

    public IProject makeProjectMutable(IProjectImmutable project) {
        return this.transaction.makeProjectMutable(project);
    }

    public ISpace createNewSpace(String spaceCode, String spaceAdminUserIdOrNull) {
        return this.transaction.createNewSpace(spaceCode, spaceAdminUserIdOrNull);
    }

    public ISpaceImmutable getSpace(String spaceCode) {
        return this.transaction.getSpace(spaceCode);
    }

    public IMaterialImmutable getMaterial(String materialCode, String materialType) {
        return this.transaction.getMaterial(materialCode, materialType);
    }

    public IMaterialImmutable getMaterial(String identifier) {
        return this.transaction.getMaterial(identifier);
    }

    public IMaterial getMaterialForUpdate(String materialCode, String materialType) {
        return this.transaction.getMaterialForUpdate(materialCode, materialType);
    }

    public IMaterial getMaterialForUpdate(String identifier) {
        return this.transaction.getMaterialForUpdate(identifier);
    }

    public IMaterial makeMaterialMutable(IMaterialImmutable material) {
        return this.transaction.makeMaterialMutable(material);
    }

    public IMaterial createNewMaterial(String materialCode, String materialType) {
        return this.transaction.createNewMaterial(materialCode, materialType);
    }

    public IMetaproject createNewMetaproject(String name, String description) {
        return this.transaction.createNewMetaproject(name, description);
    }

    public IMetaproject createNewMetaproject(String name, String description, String ownerId) {
        return this.transaction.createNewMetaproject(name, description, ownerId);
    }

    public IMetaproject getMetaproject(String name) {
        return this.transaction.getMetaproject(name);
    }

    public IMetaproject getMetaproject(String name, String ownerId) {
        return this.transaction.getMetaproject(name, ownerId);
    }

    public IVocabularyImmutable getVocabulary(String code) {
        return this.transaction.getVocabulary(code);
    }

    public IVocabulary getVocabularyForUpdate(String code) {
        return this.transaction.getVocabularyForUpdate(code);
    }

    public IVocabularyTerm createNewVocabularyTerm() {
        return this.transaction.createNewVocabularyTerm();
    }

    public String moveFile(String src, IDataSet dst) {
        return this.transaction.moveFile(src, dst);
    }

    public String moveFile(String src, IDataSet dst, String dstInDataset) {
        return this.transaction.moveFile(src, dst, dstInDataset);
    }

    public String createNewDirectory(IDataSet dst, String dirName) {
        return this.transaction.createNewDirectory(dst, dirName);
    }

    public String createNewFile(IDataSet dst, String fileName) {
        return this.transaction.createNewFile(dst, fileName);
    }

    public String createNewFile(IDataSet dst, String dstInDataset, String fileName) {
        return this.transaction.createNewFile(dst, dstInDataset, fileName);
    }

    public ISearchService getSearchService() {
        return this.transaction.getSearchService();
    }

    public ISearchService getSearchServiceUnfiltered() {
        return this.transaction.getSearchServiceUnfiltered();
    }

    public ISearchService getSearchServiceFilteredForUser(String userId) {
        return this.transaction.getSearchServiceFilteredForUser(userId);
    }

    public IAuthorizationService getAuthorizationService() {
        return this.transaction.getAuthorizationService();
    }

    public DynamicTransactionQuery getDatabaseQuery(String dataSourceName) throws IllegalArgumentException {
        return this.transaction.getDatabaseQuery(dataSourceName);
    }

    public DataSetRegistrationContext getRegistrationContext() {
        return this.transaction.getRegistrationContext();
    }

    public TopLevelDataSetRegistratorGlobalState getGlobalState() {
        return this.transaction.getGlobalState();
    }

    public File getIncoming() {
        return this.transaction.getIncoming();
    }

    public String getUserId() {
        return this.transaction.getUserId();
    }

    public void setUserId(String userIdOrNull) {
        this.transaction.setUserId(userIdOrNull);
    }

    public IExternalDataManagementSystemImmutable getExternalDataManagementSystem(String externalDataManagementSystemCode) {
        return this.transaction.getExternalDataManagementSystem(externalDataManagementSystemCode);
    }

    @Override
    public IDataSet createNewFeatureListDataSet(FeatureListDataConfig config) {
        return this.transaction.createNewFeatureListDataSet(config);
    }

    public void assignRoleToSpace(RoleWithHierarchy.RoleCode role, ISpaceImmutable space, List<String> userIds, List<String> groupCodes) {
        this.transaction.assignRoleToSpace(role, space, userIds, groupCodes);
    }

    public void revokeRoleFromSpace(RoleWithHierarchy.RoleCode role, ISpaceImmutable space, List<String> userIds, List<String> groupCodes) {
        this.transaction.revokeRoleFromSpace(role, space, userIds, groupCodes);
    }

    public InputStream getAttachmentContent(IProjectImmutable project, String fileName, Integer versionOrNull) {
        return this.transaction.getAttachmentContent(project, fileName, versionOrNull);
    }

    public InputStream getAttachmentContent(IExperimentImmutable experiment, String fileName, Integer versionOrNull) {
        return this.transaction.getAttachmentContent(experiment, fileName, versionOrNull);
    }

    public InputStream getAttachmentContent(ISampleImmutable sample, String fileName, Integer versionOrNull) {
        return this.transaction.getAttachmentContent(sample, fileName, versionOrNull);
    }

    public List<IAttachmentImmutable> listAttachments(IProjectImmutable project) {
        return this.transaction.listAttachments(project);
    }

    public List<IAttachmentImmutable> listAttachments(IExperimentImmutable experiment) {
        return this.transaction.listAttachments(experiment);
    }

    public List<IAttachmentImmutable> listAttachments(ISampleImmutable sample) {
        return this.transaction.listAttachments(sample);
    }

    public String createNewLink(IDataSet dst, String dstInDataset, String linkName, String linkTarget) {
        return this.transaction.createNewLink(dst, dstInDataset, linkName, linkTarget);
    }

    public IDSSRegistrationLogger getLogger() {
        return this.transaction.getLogger();
    }
}

