/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.impl;

import ch.systemsx.cisd.openbis.dss.etl.dto.api.BasicDataSetInformation;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.Channel;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.ChannelColorComponent;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ImageDataSetStructure;
import ch.systemsx.cisd.openbis.dss.etl.dto.api.impl.ThumbnailsInfo;
import java.io.File;
import java.util.List;

public class ImageDataSetInformation
extends BasicDataSetInformation {
    private static final long serialVersionUID = 35L;
    private File incomingDirectory;
    private File datasetRelativeImagesFolderPath;
    private ImageDataSetStructure imageDataSetStructure;
    private ThumbnailsInfo thumbnailsInfos;
    private boolean registerAsOverviewImageDataSet;
    private boolean generateOverviewImagesFromRegisteredImages;
    private int maximumImageWidth;
    private int maximumImageHeight;
    private Integer colorDepth;

    public File getIncomingDirectory() {
        return this.incomingDirectory;
    }

    public ThumbnailsInfo getThumbnailsInfos() {
        return this.thumbnailsInfos;
    }

    public ImageDataSetStructure getImageDataSetStructure() {
        return this.imageDataSetStructure;
    }

    public File getDatasetRelativeImagesFolderPath() {
        return this.datasetRelativeImagesFolderPath;
    }

    public void setIncomingDirectory(File incomingDirectory) {
        this.incomingDirectory = incomingDirectory;
    }

    public void setDatasetRelativeImagesFolderPath(File datasetRelativeImagesFolderPath) {
        this.datasetRelativeImagesFolderPath = datasetRelativeImagesFolderPath;
    }

    public void setThumbnailsInfo(ThumbnailsInfo thumbnailsInfo) {
        this.thumbnailsInfos = thumbnailsInfo;
    }

    public void setImageDataSetStructure(ImageDataSetStructure imageDataSetStructure) {
        this.imageDataSetStructure = imageDataSetStructure;
    }

    public int getMaximumImageWidth() {
        return this.maximumImageWidth;
    }

    public void setMaximumImageWidth(int maximumImageWidth) {
        this.maximumImageWidth = maximumImageWidth;
    }

    public int getMaximumImageHeight() {
        return this.maximumImageHeight;
    }

    public void setMaximumImageHeight(int maximumImageHeight) {
        this.maximumImageHeight = maximumImageHeight;
    }

    public List<Channel> getChannels() {
        return this.imageDataSetStructure.getChannels();
    }

    public List<ChannelColorComponent> getChannelColorComponents() {
        return this.imageDataSetStructure.getChannelColorComponents();
    }

    public void setChannels(List<Channel> channels) {
        this.imageDataSetStructure.setChannels(channels);
    }

    public void setChannels(List<Channel> channels, List<ChannelColorComponent> channelColorComponents) {
        this.imageDataSetStructure.setChannels(channels, channelColorComponents);
    }

    public boolean getRegisterAsOverviewImageDataSet() {
        return this.registerAsOverviewImageDataSet;
    }

    public void setRegisterAsOverviewImageDataSet(boolean registerAsOverviewImageDataSet) {
        this.registerAsOverviewImageDataSet = registerAsOverviewImageDataSet;
    }

    public boolean isGenerateOverviewImagesFromRegisteredImages() {
        return this.generateOverviewImagesFromRegisteredImages;
    }

    public void setGenerateOverviewImagesFromRegisteredImages(boolean generateOverviewImagesFromRegisteredImages) {
        this.generateOverviewImagesFromRegisteredImages = generateOverviewImagesFromRegisteredImages;
    }

    public Integer getColorDepth() {
        return this.colorDepth;
    }

    public void setColorDepth(Integer colorDepth) {
        this.colorDepth = colorDepth;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder(super.toString());
        ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"images structure", (Object)this.imageDataSetStructure);
        ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"container dataset", (Object)this.tryGetContainerDatasetPermId());
        ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"original dataset", (Object)this.getDataSetCode());
        if (this.maximumImageHeight > 0 && this.maximumImageWidth > 0) {
            ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"bounding box", (Object)(String.valueOf(this.maximumImageWidth) + "x" + this.maximumImageHeight));
        }
        if (this.getColorDepth() != null) {
            ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"color depth", (Object)this.getColorDepth());
        }
        if (this.getThumbnailsInfos() != null) {
            ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"thumbnail", (Object)this.getThumbnailsInfos());
        } else {
            ImageDataSetInformation.appendNameAndObject((StringBuilder)buffer, (String)"thumbnail", (Object)"none");
        }
        return buffer.toString();
    }
}

