/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.collections;

import java.util.Collection;
import org.apache.commons.collections.Predicate;
import org.apache.commons.collections.Transformer;
import org.apache.commons.collections.functors.AllPredicate;
import org.apache.commons.collections.functors.AndPredicate;
import org.apache.commons.collections.functors.AnyPredicate;
import org.apache.commons.collections.functors.EqualPredicate;
import org.apache.commons.collections.functors.ExceptionPredicate;
import org.apache.commons.collections.functors.FalsePredicate;
import org.apache.commons.collections.functors.IdentityPredicate;
import org.apache.commons.collections.functors.InstanceofPredicate;
import org.apache.commons.collections.functors.InvokerTransformer;
import org.apache.commons.collections.functors.NonePredicate;
import org.apache.commons.collections.functors.NotNullPredicate;
import org.apache.commons.collections.functors.NotPredicate;
import org.apache.commons.collections.functors.NullIsExceptionPredicate;
import org.apache.commons.collections.functors.NullIsFalsePredicate;
import org.apache.commons.collections.functors.NullIsTruePredicate;
import org.apache.commons.collections.functors.NullPredicate;
import org.apache.commons.collections.functors.OnePredicate;
import org.apache.commons.collections.functors.OrPredicate;
import org.apache.commons.collections.functors.TransformedPredicate;
import org.apache.commons.collections.functors.TransformerPredicate;
import org.apache.commons.collections.functors.TruePredicate;
import org.apache.commons.collections.functors.UniquePredicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateUtils {
    public static Predicate exceptionPredicate() {
        return ExceptionPredicate.INSTANCE;
    }

    public static <T> Predicate<T> truePredicate() {
        return TruePredicate.getInstance();
    }

    public static <T> Predicate<T> falsePredicate() {
        return FalsePredicate.getInstance();
    }

    public static <T> Predicate<T> nullPredicate() {
        return NullPredicate.getInstance();
    }

    public static <T> Predicate<T> notNullPredicate() {
        return NotNullPredicate.getInstance();
    }

    public static <T> Predicate<T> equalPredicate(T value) {
        return EqualPredicate.getInstance(value);
    }

    public static <T> Predicate<T> identityPredicate(T value) {
        return IdentityPredicate.getInstance(value);
    }

    public static Predicate instanceofPredicate(Class type) {
        return InstanceofPredicate.getInstance(type);
    }

    public static <T> Predicate<T> uniquePredicate() {
        return UniquePredicate.getInstance();
    }

    public static Predicate invokerPredicate(String methodName) {
        return PredicateUtils.asPredicate(InvokerTransformer.getInstance((String)methodName));
    }

    public static Predicate invokerPredicate(String methodName, Class[] paramTypes, Object[] args) {
        return PredicateUtils.asPredicate(InvokerTransformer.getInstance((String)methodName, (Class[])paramTypes, (Object[])args));
    }

    public static <T> Predicate<T> andPredicate(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return AndPredicate.getInstance(predicate1, predicate2);
    }

    public static <T> Predicate<T> allPredicate(Predicate<? super T> ... predicates) {
        return AllPredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> allPredicate(Collection<Predicate<? super T>> predicates) {
        return AllPredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> orPredicate(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return OrPredicate.getInstance(predicate1, predicate2);
    }

    public static <T> Predicate<T> anyPredicate(Predicate<? super T> ... predicates) {
        return AnyPredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> anyPredicate(Collection<Predicate<? super T>> predicates) {
        return AnyPredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> eitherPredicate(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return PredicateUtils.onePredicate(predicate1, predicate2);
    }

    public static <T> Predicate<T> onePredicate(Predicate<? super T> ... predicates) {
        return OnePredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> onePredicate(Collection<Predicate<? super T>> predicates) {
        return OnePredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> neitherPredicate(Predicate<? super T> predicate1, Predicate<? super T> predicate2) {
        return PredicateUtils.nonePredicate(predicate1, predicate2);
    }

    public static <T> Predicate<T> nonePredicate(Predicate<? super T> ... predicates) {
        return NonePredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> nonePredicate(Collection<Predicate<? super T>> predicates) {
        return NonePredicate.getInstance(predicates);
    }

    public static <T> Predicate<T> notPredicate(Predicate<T> predicate) {
        return NotPredicate.getInstance(predicate);
    }

    public static <T> Predicate<T> asPredicate(Transformer<T, Boolean> transformer) {
        return TransformerPredicate.getInstance(transformer);
    }

    public static <T> Predicate<T> nullIsExceptionPredicate(Predicate<T> predicate) {
        return NullIsExceptionPredicate.getInstance(predicate);
    }

    public static <T> Predicate<T> nullIsFalsePredicate(Predicate<T> predicate) {
        return NullIsFalsePredicate.getInstance(predicate);
    }

    public static <T> Predicate<T> nullIsTruePredicate(Predicate<T> predicate) {
        return NullIsTruePredicate.getInstance(predicate);
    }

    public static <I, O> Predicate<I> transformedPredicate(Transformer<I, ? extends O> transformer, Predicate<? super O> predicate) {
        return TransformedPredicate.getInstance(transformer, predicate);
    }
}

