/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.rpc.server;

import ch.systemsx.cisd.authentication.IAuthenticationService;
import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.base.exceptions.IOExceptionUnchecked;
import ch.systemsx.cisd.cifex.rpc.FilePreregistrationDTO;
import ch.systemsx.cisd.cifex.rpc.QuotaExceededException;
import ch.systemsx.cisd.cifex.rpc.io.ISimpleChecksummingProgressListener;
import ch.systemsx.cisd.cifex.rpc.io.ResumingAndChecksummingInputStream;
import ch.systemsx.cisd.cifex.rpc.server.IExtendedCIFEXRPCService;
import ch.systemsx.cisd.cifex.rpc.server.Session;
import ch.systemsx.cisd.cifex.rpc.server.SessionManager;
import ch.systemsx.cisd.cifex.server.AbstractCIFEXService;
import ch.systemsx.cisd.cifex.server.HttpUtils;
import ch.systemsx.cisd.cifex.server.business.FileInformation;
import ch.systemsx.cisd.cifex.server.business.IDomainModel;
import ch.systemsx.cisd.cifex.server.business.IFileManager;
import ch.systemsx.cisd.cifex.server.business.IUserActionLog;
import ch.systemsx.cisd.cifex.server.business.IUserManager;
import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import ch.systemsx.cisd.cifex.server.business.dto.UserDTO;
import ch.systemsx.cisd.cifex.server.util.FilenameUtilities;
import ch.systemsx.cisd.cifex.shared.basic.Constants;
import ch.systemsx.cisd.cifex.shared.basic.dto.FileInfoDTO;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.concurrent.ConcurrencyUtilities;
import ch.systemsx.cisd.common.exceptions.AuthorizationFailureException;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.InvalidSessionException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.reflection.BeanUtils;
import ch.systemsx.cisd.common.servlet.IRequestContextProvider;
import ch.systemsx.cisd.common.string.StringUtilities;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.Timer;
import java.util.TimerTask;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;

public class CIFEXRPCService
extends AbstractCIFEXService
implements IExtendedCIFEXRPCService {
    public static final int MIN_CLIENT_VERSION = 4;
    private static final long MB = 0x100000L;
    private static final long DELAY_AFTER_FAILED_LOGIN_MILLIS = 500L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, CIFEXRPCService.class);
    private final SessionManager sessionManager;
    private final IFileManager fileManager;
    private final IUserManager userManager;

    public CIFEXRPCService(IDomainModel domainModel, IRequestContextProvider requestContextProvider, IUserActionLog userBehaviorLog, IAuthenticationService externalAuthenticationService, SessionManager sessionManager, long cleaningTimeInterval, int sessionExpirationPeriodMinutes, String testingFlag) {
        this(domainModel.getFileManager(), domainModel, requestContextProvider, userBehaviorLog, externalAuthenticationService, sessionManager, cleaningTimeInterval, sessionExpirationPeriodMinutes, testingFlag);
    }

    public CIFEXRPCService(IFileManager fileManager, IDomainModel domainModel, IRequestContextProvider requestContextProvider, IUserActionLog userActionLog, IAuthenticationService externalAuthenticationService, SessionManager sessionManager, long cleaningTimeInterval, int sessionExpirationPeriodMinutes, String testingFlag) {
        super(domainModel, requestContextProvider, userActionLog, externalAuthenticationService, CIFEXRPCService.createLoggingContextHandler(requestContextProvider), sessionExpirationPeriodMinutes);
        this.fileManager = fileManager;
        this.userManager = domainModel.getUserManager();
        this.sessionManager = sessionManager;
        if ("true".equals(testingFlag)) {
            UserDTO userDTO = new UserDTO();
            userDTO.setID(Long.parseLong(System.getProperty("test-user.id")));
            userDTO.setUserCode(System.getProperty("test-user.code"));
            sessionManager.createSession(userDTO, "test-url");
        } else {
            this.startSessionExpirationTimer(cleaningTimeInterval, sessionExpirationPeriodMinutes);
        }
    }

    private void startSessionExpirationTimer(long cleaningTimeInterval, long sessionExpirationPeriodMinutes) {
        Timer timer = new Timer("Session Expiration", true);
        final long sessionExpirationPeriodMillis = 60000L * sessionExpirationPeriodMinutes;
        timer.schedule(new TimerTask(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                long now = System.currentTimeMillis();
                LinkedList<Session> sessionsToRemove = new LinkedList<Session>();
                SessionManager sessionManager = CIFEXRPCService.this.sessionManager;
                synchronized (sessionManager) {
                    for (Session session : CIFEXRPCService.this.sessionManager.getAllSessions()) {
                        if (now - session.getLastActiveMillis() <= sessionExpirationPeriodMillis) continue;
                        sessionsToRemove.add(session);
                    }
                    for (Session session : sessionsToRemove) {
                        CIFEXRPCService.this.logout(session, true);
                    }
                }
            }
        }, 0L, cleaningTimeInterval);
    }

    @Override
    public int getVersion() {
        return 5;
    }

    @Override
    public int getMinClientVersion() {
        return 4;
    }

    @Override
    public void checkSession(String sessionID) throws InvalidSessionException {
        try {
            this.sessionManager.getSession(sessionID);
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)(String.valueOf(this.userActionLog.getUserHostSessionDescription()) + "Keep alive ping: OK"));
            }
        }
        catch (RuntimeException ex) {
            if (operationLog.isInfoEnabled()) {
                operationLog.info((Object)(String.valueOf(this.userActionLog.getUserHostSessionDescription()) + "Keep alive ping: FAILED"));
            }
            throw ex;
        }
    }

    @Override
    public String login(String userCode, String plainPassword) throws AuthorizationFailureException, EnvironmentFailureException {
        this.logInvocation("session initialization", "Try to login user '" + userCode + "'.");
        UserDTO user = this.tryLoginUser(userCode, plainPassword);
        if (user == null) {
            this.userActionLog.logFailedLoginAttempt(userCode);
            ConcurrencyUtilities.sleep(500L);
            throw new AuthorizationFailureException("Login failed: invalid user or password");
        }
        return this.createSession(user, this.getURLForEmail());
    }

    @Override
    public void logout(String sessionID) throws InvalidSessionException {
        try {
            Session session = this.sessionManager.getSession(sessionID);
            this.logout(session, false);
        }
        catch (InvalidSessionException invalidSessionException) {}
    }

    private void logout(Session session, boolean sessionExpired) throws InvalidSessionException {
        this.sessionManager.removeSession(session.getSessionID(), sessionExpired);
    }

    private String getURLForEmail() {
        HttpServletRequest request = this.requestContextProvider.getHttpServletRequest();
        return HttpUtils.getURLForEmail(request, this.domainModel.getBusinessContext());
    }

    @Override
    public String createSession(UserDTO user, String url) {
        return this.sessionManager.createSession(user, url).getSessionID();
    }

    @Override
    public FileInfoDTO[] listDownloadFiles(String sessionID) throws InvalidSessionException {
        Session session = this.sessionManager.getSession(sessionID);
        List<FileDTO> files = this.domainModel.getFileManager().listDownloadFiles(session.getUser().getID());
        return BeanUtils.createBeanArray(FileInfoDTO.class, files);
    }

    @Override
    public FileInfoDTO[] listOwnedFiles(String sessionID) throws InvalidSessionException, EnvironmentFailureException {
        Session session = this.sessionManager.getSession(sessionID);
        List<FileDTO> files = this.domainModel.getFileManager().listOwnedFiles(session.getUser().getID());
        return BeanUtils.createBeanArray(FileInfoDTO.class, files);
    }

    @Override
    public FileInfoDTO getFileInfo(String sessionID, long fileID) throws InvalidSessionException, IOExceptionUnchecked {
        this.logInvocation(sessionID, "Download file id=" + fileID);
        FileDTO file = new FileDTO();
        file.setName("id:" + fileID);
        Session session = this.sessionManager.getSession(sessionID);
        FileInformation fileInfo = this.fileManager.getFileInformation(fileID);
        if (!fileInfo.isFileAvailable()) {
            throw new IOExceptionUnchecked(new IOException(fileInfo.getErrorMessage()));
        }
        file = fileInfo.getFileDTO();
        if (!this.fileManager.isAllowedAccess(session.getUser(), file)) {
            throw new IOExceptionUnchecked(new IOException(Constants.getErrorMessageForFileNotFound(fileID)));
        }
        FileInfoDTO fileInfoDTO = BeanUtils.createBean(FileInfoDTO.class, fileInfo.getFileDTO());
        return fileInfoDTO;
    }

    @Override
    public long upload(String sessionID, FilePreregistrationDTO file, String comment, InputStream contentStream) throws InvalidSessionException {
        boolean success = false;
        String fileName = "UNKNOWN";
        FileDTO fileDTO = null;
        try {
            Session session = this.sessionManager.getSession(sessionID);
            UserDTO requestUser = session.getUser();
            fileName = FilenameUtils.getName((String)file.getFilePathOnClient());
            this.logInvocation(sessionID, "Start uploading " + fileName);
            this.userActionLog.logUploadFileStart(fileName, null, 0L);
            this.checkQuota(sessionID, requestUser, file);
            String contentType = FilenameUtilities.getMimeType(fileName);
            fileDTO = this.fileManager.saveFile(requestUser, fileName, comment, contentType, file.getFileSize(), contentStream);
            success = true;
            long l = fileDTO.getID();
            this.userActionLog.logUploadFileFinished(fileName, fileDTO, success);
            return l;
        }
        catch (Throwable throwable) {
            this.userActionLog.logUploadFileFinished(fileName, fileDTO, success);
            throw throwable;
        }
    }

    @Override
    public void resumeUpload(String sessionID, long fileId, long startPosition, String comment, InputStream contentStream) throws InvalidSessionException {
        boolean success = false;
        String fileName = "UNKNOWN";
        FileDTO fileDTO = null;
        try {
            Session session = this.sessionManager.getSession(sessionID);
            UserDTO requestUser = session.getUser();
            FileInformation fileInfo = this.fileManager.getFileInformation(fileId);
            fileName = fileInfo.getFileDTO().getName();
            fileDTO = fileInfo.getFileDTO();
            File file = fileInfo.getFile();
            this.logInvocation(sessionID, "Resume uploading of file " + fileName + " (id=" + fileId + ")");
            this.userActionLog.logUploadFileStart(fileName, fileDTO, startPosition);
            if (!this.fileManager.isControlling(requestUser, fileInfo.getFileDTO())) {
                operationLog.error((Object)("[" + sessionID + "]: resumeUpload() failed because user " + requestUser.getUserCode() + " is not allowed to control fileId=" + fileId));
                throw new AuthorizationFailureException("Insufficient privileges for user " + requestUser.getUserCode() + ".");
            }
            this.fileManager.resumeSaveFile(requestUser, fileDTO, file, comment, startPosition, contentStream);
            success = true;
        }
        catch (Throwable throwable) {
            this.userActionLog.logUploadFileFinished(fileName, fileDTO, success);
            throw throwable;
        }
        this.userActionLog.logUploadFileFinished(fileName, fileDTO, success);
    }

    private void checkQuota(String sessionID, UserDTO requestUser, FilePreregistrationDTO file) {
        boolean sizeOK;
        this.domainModel.getUserManager().refreshQuotaInformation(requestUser);
        boolean countOK = requestUser.getMaxFileCountPerQuotaGroup() == null || requestUser.getCurrentFileCount() + 1 <= requestUser.getMaxFileCountPerQuotaGroup();
        boolean bl = sizeOK = requestUser.getMaxFileSizePerQuotaGroupInMB() == null || requestUser.getCurrentFileSize() + file.getFileSize() <= requestUser.getMaxFileSizePerQuotaGroupInMB() * 0x100000L;
        if (!countOK || !sizeOK) {
            double currentFileSizeInMB = (double)requestUser.getCurrentFileSize() / 1048576.0;
            QuotaExceededException excetion = new QuotaExceededException(requestUser.getMaxFileCountPerQuotaGroup(), requestUser.getMaxFileSizePerQuotaGroupInMB(), requestUser.getCurrentFileCount(), currentFileSizeInMB);
            operationLog.error((Object)("[" + sessionID + "]: " + excetion.getMessage()));
            throw excetion;
        }
    }

    @Override
    public FileInfoDTO tryGetUploadResumeCandidate(String sessionID, FilePreregistrationDTO fileSpecs) {
        assert (sessionID != null);
        assert (fileSpecs != null);
        Session session = this.sessionManager.getSession(sessionID);
        String fileName = FilenameUtils.getName((String)fileSpecs.getFilePathOnClient());
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)("Try to get upload resume candidate for file=" + fileName + " with complete size=" + fileSpecs.getFileSize()));
        }
        UserDTO user = session.getUser();
        return BeanUtils.createBean(FileInfoDTO.class, this.fileManager.tryGetUploadResumeCandidate(user.getID(), fileName, fileSpecs.getFileSize()));
    }

    @Override
    public void shareFiles(String sessionID, List<Long> fileIDs, String recipients) {
        assert (sessionID != null);
        this.logInvocation(sessionID, "Share files=" + CollectionUtils.abbreviate(fileIDs, 3) + " with recipients='" + recipients + "'");
        Session session = this.sessionManager.getSession(sessionID);
        List<String> recipientList = StringUtilities.tokenize(recipients);
        UserDTO user = session.getUser();
        String url = session.getUrl();
        ArrayList<FileDTO> files = new ArrayList<FileDTO>(fileIDs.size());
        for (long fileId : fileIDs) {
            try {
                files.add(this.fileManager.getFileInformation(fileId).getFileDTO());
            }
            catch (IllegalStateException ex) {
                operationLog.error((Object)("[" + sessionID + "]: shareFiles() failed because fileId=" + fileId + " is invalid: " + ex.getMessage()));
                throw ex;
            }
        }
        String comment = this.createCommentForSharingEmail(files);
        this.checkIfUserIsControllingFiles(sessionID, user, files, recipientList);
        List<String> invalidUserIdentifiers = this.fileManager.shareFilesWith(url, user, recipientList, files, comment, this.userActionLog);
        if (!invalidUserIdentifiers.isEmpty()) {
            throw new UserFailureException("Some user identifiers are invalid: " + CollectionUtils.abbreviate(invalidUserIdentifiers, 10));
        }
    }

    private void checkIfUserIsControllingFiles(String sessionID, UserDTO user, Collection<FileDTO> files, List<String> recipientList) throws AuthorizationFailureException {
        for (FileDTO file : files) {
            if (this.fileManager.isControlling(user, file)) continue;
            operationLog.error((Object)("[" + sessionID + "]: shareFiles() failed because user " + user.getUserCode() + " is not allowed to control file=" + file.toString()));
            this.userActionLog.logShareFilesAuthorizationFailure(files, recipientList);
            throw new AuthorizationFailureException("Insufficient privileges for user " + user.getUserCode() + ".");
        }
    }

    private String createCommentForSharingEmail(Collection<FileDTO> files) {
        HashSet<String> comments = new HashSet<String>();
        for (FileDTO file : files) {
            if (!StringUtils.isNotBlank((String)file.getComment())) continue;
            comments.add(file.getComment());
        }
        if (comments.size() == 1) {
            return (String)comments.iterator().next();
        }
        StringBuilder builder = new StringBuilder();
        for (String comment : comments) {
            builder.append(comment);
            builder.append('\n');
        }
        return builder.toString();
    }

    @Override
    public void deleteFile(String sessionID, long fileId) throws InvalidSessionException {
        assert (sessionID != null);
        this.logInvocation(sessionID, "Delete file id=" + fileId);
        FileInformation fileInfo = this.fileManager.getFileInformationFilestoreUnimportant(fileId);
        if (!fileInfo.isFileAvailable()) {
            throw UserFailureException.fromTemplate("File with id %d does not exist on the server.", fileId);
        }
        FileDTO file = fileInfo.getFileDTO();
        boolean success = false;
        try {
            Session session = this.sessionManager.getSession(sessionID);
            UserDTO user = session.getUser();
            if (!this.fileManager.isControlling(user, file)) {
                operationLog.error((Object)("[" + sessionID + "]: deleteFile() failed because user " + user.getUserCode() + " is not allowed to control file=" + file.toString()));
                throw new AuthorizationFailureException("Insufficient privileges for user " + user.getUserCode() + ".");
            }
            this.fileManager.deleteFile(file);
            success = true;
        }
        finally {
            this.userActionLog.logDeleteFile(file, success);
        }
    }

    @Override
    public InputStream download(final String sessionID, long fileID, long startPosition) throws InvalidSessionException, IOExceptionUnchecked {
        this.logInvocation(sessionID, "Download file id=" + fileID);
        FileDTO file = new FileDTO();
        file.setName("id:" + fileID);
        Session session = this.sessionManager.getSession(sessionID);
        FileInformation fileInfo = this.fileManager.getFileInformation(fileID);
        if (!fileInfo.isFileAvailable()) {
            this.userActionLog.logDownloadFileFailedNotFound(fileInfo.getFileDTO());
            throw new IOExceptionUnchecked(new IOException(fileInfo.getErrorMessage()));
        }
        file = fileInfo.getFileDTO();
        if (!this.fileManager.isAllowedAccess(session.getUser(), file)) {
            this.userActionLog.logDownloadFileFailedNotAuthorized(fileInfo.getFileDTO());
            throw new IOExceptionUnchecked(new IOException(Constants.getErrorMessageForFileNotFound(fileID)));
        }
        this.userActionLog.logDownloadFileStart(file, startPosition);
        try {
            final FileDTO finalFile = file;
            ResumingAndChecksummingInputStream fileContent = new ResumingAndChecksummingInputStream(fileInfo.getFile(), Long.MAX_VALUE, new ISimpleChecksummingProgressListener(){

                @Override
                public void update(long bytesRead, int crc32Value) {
                    CIFEXRPCService.this.userActionLog.logDownloadFileFinished(finalFile, true);
                }

                @Override
                public void exceptionThrown(IOException e) {
                    operationLog.error((Object)("[" + sessionID + "]: download() failed."), (Throwable)e);
                    CIFEXRPCService.this.userActionLog.logDownloadFileFinished(finalFile, false);
                }
            }, startPosition, ResumingAndChecksummingInputStream.ChecksumHandling.DONT_COMPUTE);
            return fileContent;
        }
        catch (IOException ex) {
            throw CheckedExceptionTunnel.wrapIfNecessary(ex);
        }
    }

    private void logInvocation(String sessionID, String message) {
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)("[" + sessionID + "]: " + message));
        }
    }

    @Override
    public void setSessionUser(String sessionID, String userCode) {
        boolean success = false;
        String oldUserCode = "UNKNOWN";
        try {
            Session session = this.sessionManager.getSession(sessionID);
            oldUserCode = session.getUser().getUserCode();
            if (!session.getUser().isAdmin()) {
                throw new AuthorizationFailureException("Changing session user not allowed.");
            }
            Set<String> allowedIpsForSetSessionUser = this.domainModel.getBusinessContext().getAllowedIPsForSetSessionUser();
            if (!allowedIpsForSetSessionUser.contains(this.remoteHostProvider.getRemoteHost())) {
                throw new AuthorizationFailureException("Changing session user not allowed.");
            }
            UserDTO newUserOrNull = this.userManager.tryFindUserByCode(userCode);
            if (newUserOrNull == null) {
                throw new IllegalArgumentException("User '" + userCode + "' is unknown.");
            }
            session.setUser(newUserOrNull);
            success = true;
        }
        finally {
            this.userActionLog.logSetSessionUser(oldUserCode, userCode, success);
        }
    }
}

