/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cifex.server.business;

import ch.systemsx.cisd.cifex.server.business.dto.FileDTO;
import java.io.File;

public class FileInformation {
    private final FileDTO fileDTOOrNull;
    private final File fileOrNull;
    private final long fileId;
    private final String errorMessageOrNull;

    public FileInformation(long fileId, FileDTO fileDTO, File file) {
        assert (fileId > 0L);
        this.fileId = fileId;
        this.fileDTOOrNull = fileDTO;
        this.fileOrNull = file;
        this.errorMessageOrNull = null;
    }

    public FileInformation(long fileId, String errorMessage) {
        assert (fileId > 0L);
        this.fileId = fileId;
        this.errorMessageOrNull = errorMessage;
        this.fileDTOOrNull = null;
        this.fileOrNull = null;
    }

    public boolean isFileAvailable() {
        return this.fileDTOOrNull != null;
    }

    public long getFileId() {
        return this.fileId;
    }

    public FileDTO getFileDTO() throws IllegalStateException {
        if (!this.isFileAvailable()) {
            throw new IllegalStateException(this.errorMessageOrNull);
        }
        return this.fileDTOOrNull;
    }

    public File getFile() throws IllegalStateException {
        if (!this.isFileAvailable()) {
            throw new IllegalStateException(this.errorMessageOrNull);
        }
        return this.fileOrNull;
    }

    public String getErrorMessage() {
        if (this.isFileAvailable()) {
            throw new IllegalStateException("File [id=" + this.fileId + "] is available.");
        }
        return this.errorMessageOrNull;
    }
}

