/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.hdf5;

import ch.systemsx.cisd.base.mdarray.MDArray;
import ch.systemsx.cisd.base.mdarray.MDLongArray;
import ch.systemsx.cisd.hdf5.HDF5BaseReader;
import ch.systemsx.cisd.hdf5.HDF5DataBlock;
import ch.systemsx.cisd.hdf5.HDF5DataTypeVariant;
import ch.systemsx.cisd.hdf5.HDF5LongReader;
import ch.systemsx.cisd.hdf5.HDF5MDDataBlock;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlock1DParameters;
import ch.systemsx.cisd.hdf5.HDF5NaturalBlockMDParameters;
import ch.systemsx.cisd.hdf5.HDF5TimeDuration;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationArray;
import ch.systemsx.cisd.hdf5.HDF5TimeDurationMDArray;
import ch.systemsx.cisd.hdf5.HDF5TimeUnit;
import ch.systemsx.cisd.hdf5.IHDF5TimeDurationReader;
import ch.systemsx.cisd.hdf5.MatrixUtils;
import ch.systemsx.cisd.hdf5.cleanup.ICallableWithCleanUp;
import ch.systemsx.cisd.hdf5.cleanup.ICleanUpRegistry;
import ch.systemsx.cisd.hdf5.hdf5lib.HDF5Constants;
import java.util.Iterator;
import ncsa.hdf.hdf5lib.exceptions.HDF5JavaException;

class HDF5TimeDurationReader
implements IHDF5TimeDurationReader {
    private final HDF5BaseReader baseReader;
    private final HDF5LongReader longReader;

    HDF5TimeDurationReader(HDF5BaseReader baseReader, HDF5LongReader longReader) {
        assert (baseReader != null);
        assert (longReader != null);
        this.baseReader = baseReader;
        this.longReader = longReader;
    }

    @Override
    public HDF5TimeDuration getAttr(final String objectPath, final String attributeName) {
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDuration> getAttributeRunnable = new ICallableWithCleanUp<HDF5TimeDuration>(){

            @Override
            public HDF5TimeDuration call(ICleanUpRegistry registry) {
                int objectId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openObject(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                int attributeId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openAttribute(objectId, attributeName, registry);
                HDF5TimeUnit unit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, attributeName, objectId, registry);
                long[] data = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readAttributeAsLongArray(attributeId, HDF5Constants.H5T_NATIVE_INT64, 1);
                return new HDF5TimeDuration(data[0], unit);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public boolean isTimeDuration(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeDuration();
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath, String attributeName) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath, attributeName);
        return typeVariantOrNull != null ? typeVariantOrNull.tryGetTimeUnit() : null;
    }

    @Override
    public HDF5TimeDurationArray getArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> getAttributeRunnable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int objectId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openObject(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, attributeName, objectId, registry);
                long[] data = HDF5TimeDurationReader.this.longReader.getArrayAttr(objectPath, attributeName);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public HDF5TimeDurationMDArray getMDArrayAttr(final String objectPath, final String attributeName) {
        assert (objectPath != null);
        assert (attributeName != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationMDArray> getAttributeRunnable = new ICallableWithCleanUp<HDF5TimeDurationMDArray>(){

            @Override
            public HDF5TimeDurationMDArray call(ICleanUpRegistry registry) {
                int objectId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openObject(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, attributeName, objectId, registry);
                MDLongArray data = HDF5TimeDurationReader.this.longReader.getMDArrayAttr(objectPath, attributeName);
                return new HDF5TimeDurationMDArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(getAttributeRunnable);
    }

    @Override
    public boolean isTimeDuration(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null && typeVariantOrNull.isTimeDuration();
    }

    @Override
    public HDF5TimeUnit tryGetTimeUnit(String objectPath) throws HDF5JavaException {
        HDF5DataTypeVariant typeVariantOrNull = this.baseReader.tryGetTypeVariant(objectPath);
        return typeVariantOrNull != null ? typeVariantOrNull.tryGetTimeUnit() : null;
    }

    @Override
    public HDF5TimeDuration read(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDuration> readCallable = new ICallableWithCleanUp<HDF5TimeDuration>(){

            @Override
            public HDF5TimeDuration call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                long[] data = new long[1];
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, data);
                return new HDF5TimeDuration(data[0], storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    public long readTimeDuration(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return timeUnit.convert(this.read(objectPath));
    }

    public HDF5TimeDuration readTimeDurationAndUnit(String objectPath) throws HDF5JavaException {
        return this.read(objectPath);
    }

    @Override
    public HDF5TimeDurationArray readArray(final String objectPath) throws HDF5JavaException {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5TimeDurationReader.this.baseReader.getSpaceParameters(dataSetId, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    public long[] readTimeDurationArray(String objectPath, HDF5TimeUnit timeUnit) throws HDF5JavaException {
        return timeUnit.convert(this.readArray(objectPath));
    }

    public HDF5TimeDuration[] readTimeDurationAndUnitArray(String objectPath) throws HDF5JavaException {
        HDF5TimeDurationArray durations = this.readArray(objectPath);
        return HDF5TimeDurationReader.convertTimeDurations(durations.timeUnit, durations.timeDurations);
    }

    public long[] readTimeDurationArrayBlock(String objectPath, int blockSize, long blockNumber, HDF5TimeUnit timeUnit) {
        return timeUnit.convert(this.readArrayBlock(objectPath, blockSize, blockNumber));
    }

    @Override
    public HDF5TimeDurationArray readArrayBlock(String objectPath, int blockSize, long blockNumber) {
        return this.readArrayBlockWithOffset(objectPath, blockSize, blockNumber * (long)blockSize);
    }

    @Override
    public HDF5TimeDurationArray readArrayBlockWithOffset(final String objectPath, final int blockSize, final long offset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationArray>(){

            @Override
            public HDF5TimeDurationArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5TimeDurationReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockSize, registry);
                long[] data = new long[spaceParams.blockSize];
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, data);
                return new HDF5TimeDurationArray(data, storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    public long[] readTimeDurationArrayBlockWithOffset(String objectPath, int blockSize, long offset, HDF5TimeUnit timeUnit) {
        return timeUnit.convert(this.readArrayBlockWithOffset(objectPath, blockSize, offset));
    }

    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlock(String objectPath, int blockSize, long blockNumber) throws HDF5JavaException {
        return this.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, blockSize, (long)blockSize * blockNumber);
    }

    public HDF5TimeDuration[] readTimeDurationAndUnitArrayBlockWithOffset(String objectPath, int blockSize, long offset) throws HDF5JavaException {
        HDF5TimeDurationArray durations = this.readArrayBlockWithOffset(objectPath, blockSize, offset);
        return HDF5TimeDurationReader.convertTimeDurations(durations.timeUnit, durations.timeDurations);
    }

    public Iterable<HDF5DataBlock<HDF5TimeDuration[]>> getTimeDurationAndUnitArrayNaturalBlocks(final String objectPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<HDF5TimeDuration[]>>(){

            @Override
            public Iterator<HDF5DataBlock<HDF5TimeDuration[]>> iterator() {
                return new Iterator<HDF5DataBlock<HDF5TimeDuration[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<HDF5TimeDuration[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        HDF5TimeDuration[] block = HDF5TimeDurationReader.this.readTimeDurationAndUnitArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<HDF5TimeDuration[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public HDF5TimeDurationMDArray readMDArray(final String objectPath) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationMDArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationMDArray>(){

            @Override
            public HDF5TimeDurationMDArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                return new HDF5TimeDurationMDArray(HDF5TimeDurationReader.this.longReader.readLongMDArray(dataSetId, registry), storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public HDF5TimeDurationMDArray readMDArrayBlock(String objectPath, int[] blockDimensions, long[] blockNumber) {
        long[] offset = new long[blockDimensions.length];
        int i = 0;
        while (i < offset.length) {
            offset[i] = blockNumber[i] * (long)blockDimensions[i];
            ++i;
        }
        return this.readMDArrayBlockWithOffset(objectPath, blockDimensions, offset);
    }

    @Override
    public HDF5TimeDurationMDArray readMDArrayBlockWithOffset(final String objectPath, final int[] blockDimensions, final long[] offset) {
        assert (objectPath != null);
        assert (blockDimensions != null);
        assert (offset != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<HDF5TimeDurationMDArray> readCallable = new ICallableWithCleanUp<HDF5TimeDurationMDArray>(){

            @Override
            public HDF5TimeDurationMDArray call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5TimeDurationReader.this.baseReader.getSpaceParameters(dataSetId, offset, blockDimensions, registry);
                long[] dataBlock = new long[spaceParams.blockSize];
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, HDF5Constants.H5T_NATIVE_INT64, spaceParams.memorySpaceId, spaceParams.dataSpaceId, dataBlock);
                return new HDF5TimeDurationMDArray(new MDLongArray(dataBlock, blockDimensions), storedUnit);
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayWithOffset(final String objectPath, final HDF5TimeDurationMDArray array, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5TimeDurationReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), registry);
                int nativeDataTypeId = HDF5TimeDurationReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                int[] effectiveBlockDims = MDArray.toInt((long[])spaceParams.dimensions);
                if (array.getUnit() != storedUnit) {
                    HDF5TimeDurationReader.convertUnit(array.getValues(), storedUnit, array.getUnit(), effectiveBlockDims, memoryOffset);
                }
                return effectiveBlockDims;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    @Override
    public int[] readToMDArrayBlockWithOffset(final String objectPath, final HDF5TimeDurationMDArray array, final int[] blockDimensions, final long[] offset, final int[] memoryOffset) {
        assert (objectPath != null);
        this.baseReader.checkOpen();
        ICallableWithCleanUp<int[]> readCallable = new ICallableWithCleanUp<int[]>(){

            @Override
            public int[] call(ICleanUpRegistry registry) {
                int dataSetId = ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.openDataSet(((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.fileId, objectPath, registry);
                HDF5TimeUnit storedUnit = HDF5TimeDurationReader.this.baseReader.checkIsTimeDuration(objectPath, dataSetId, registry);
                HDF5BaseReader.DataSpaceParameters spaceParams = HDF5TimeDurationReader.this.baseReader.getBlockSpaceParameters(dataSetId, memoryOffset, array.dimensions(), offset, blockDimensions, registry);
                int nativeDataTypeId = HDF5TimeDurationReader.this.baseReader.getNativeDataTypeId(dataSetId, HDF5Constants.H5T_NATIVE_INT64, registry);
                ((HDF5TimeDurationReader)HDF5TimeDurationReader.this).baseReader.h5.readDataSet(dataSetId, nativeDataTypeId, spaceParams.memorySpaceId, spaceParams.dataSpaceId, array.getAsFlatArray());
                int[] effectiveBlockDims = MDArray.toInt((long[])spaceParams.dimensions);
                if (array.getUnit() != storedUnit) {
                    HDF5TimeDurationReader.convertUnit(array.getValues(), storedUnit, array.getUnit(), effectiveBlockDims, memoryOffset);
                }
                return effectiveBlockDims;
            }
        };
        return this.baseReader.runner.call(readCallable);
    }

    static void convertUnit(MDLongArray array, HDF5TimeUnit fromUnit, HDF5TimeUnit toUnit, int[] dims, int[] offset) {
        long[] flatArray = array.getAsFlatArray();
        int[] idx = (int[])offset.clone();
        System.arraycopy(offset, 0, idx, 0, idx.length);
        do {
            int linIdx = array.computeIndex(idx);
            flatArray[linIdx] = toUnit.convert(flatArray[linIdx], fromUnit);
        } while (MatrixUtils.incrementIdx(idx, dims, offset));
    }

    @Override
    public Iterable<HDF5DataBlock<HDF5TimeDurationArray>> getArrayNaturalBlocks(final String objectPath) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<HDF5TimeDurationArray>>(){

            @Override
            public Iterator<HDF5DataBlock<HDF5TimeDurationArray>> iterator() {
                return new Iterator<HDF5DataBlock<HDF5TimeDurationArray>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<HDF5TimeDurationArray> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        HDF5TimeDurationArray block = HDF5TimeDurationReader.this.readArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset);
                        return new HDF5DataBlock<HDF5TimeDurationArray>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    public Iterable<HDF5DataBlock<long[]>> getTimeDurationArrayNaturalBlocks(final String objectPath, final HDF5TimeUnit timeUnit) throws HDF5JavaException {
        final HDF5NaturalBlock1DParameters params = new HDF5NaturalBlock1DParameters(this.baseReader.getDataSetInformation(objectPath));
        return new Iterable<HDF5DataBlock<long[]>>(){

            @Override
            public Iterator<HDF5DataBlock<long[]>> iterator() {
                return new Iterator<HDF5DataBlock<long[]>>(params){
                    final HDF5NaturalBlock1DParameters.HDF5NaturalBlock1DIndex index;
                    {
                        this.index = hDF5NaturalBlock1DParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5DataBlock<long[]> next() {
                        long offset = this.index.computeOffsetAndSizeGetOffset();
                        long[] block = HDF5TimeDurationReader.this.readTimeDurationArrayBlockWithOffset(objectPath, this.index.getBlockSize(), offset, timeUnit);
                        return new HDF5DataBlock<long[]>(block, this.index.getAndIncIndex(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    @Override
    public Iterable<HDF5MDDataBlock<HDF5TimeDurationMDArray>> getMDArrayNaturalBlocks(final String dataSetPath) {
        this.baseReader.checkOpen();
        final HDF5NaturalBlockMDParameters params = new HDF5NaturalBlockMDParameters(this.baseReader.getDataSetInformation(dataSetPath));
        return new Iterable<HDF5MDDataBlock<HDF5TimeDurationMDArray>>(){

            @Override
            public Iterator<HDF5MDDataBlock<HDF5TimeDurationMDArray>> iterator() {
                return new Iterator<HDF5MDDataBlock<HDF5TimeDurationMDArray>>(params){
                    final HDF5NaturalBlockMDParameters.HDF5NaturalBlockMDIndex index;
                    {
                        this.index = hDF5NaturalBlockMDParameters.getNaturalBlockIndex();
                    }

                    @Override
                    public boolean hasNext() {
                        return this.index.hasNext();
                    }

                    @Override
                    public HDF5MDDataBlock<HDF5TimeDurationMDArray> next() {
                        long[] offset = this.index.computeOffsetAndSizeGetOffsetClone();
                        HDF5TimeDurationMDArray data = HDF5TimeDurationReader.this.readMDArrayBlockWithOffset(dataSetPath, this.index.getBlockSize(), offset);
                        return new HDF5MDDataBlock<HDF5TimeDurationMDArray>(data, this.index.getIndexClone(), offset);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }
        };
    }

    static void convertTimeDurations(HDF5TimeUnit toTimeUnit, HDF5TimeUnit fromTimeUnit, long[] data) {
        if (toTimeUnit != fromTimeUnit) {
            int i = 0;
            while (i < data.length) {
                data[i] = toTimeUnit.convert(data[i], fromTimeUnit);
                ++i;
            }
        }
    }

    static HDF5TimeDuration[] convertTimeDurations(HDF5TimeUnit timeUnit, long[] data) {
        HDF5TimeDuration[] durations = new HDF5TimeDuration[data.length];
        int i = 0;
        while (i < data.length) {
            durations[i] = new HDF5TimeDuration(data[i], timeUnit);
            ++i;
        }
        return durations;
    }
}

