/*
 * Decompiled with CFR 0.152.
 */
package ch.ethz.bsse.cisd.dsu.tracking.main;

import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackedEntities;
import ch.ethz.bsse.cisd.dsu.tracking.dto.TrackingStateDTO;
import ch.ethz.bsse.cisd.dsu.tracking.email.Email;
import ch.ethz.bsse.cisd.dsu.tracking.email.EmailWithSummary;
import ch.ethz.bsse.cisd.dsu.tracking.email.IEntityTrackingEmailGenerator;
import ch.ethz.bsse.cisd.dsu.tracking.main.ITrackingDAO;
import ch.ethz.bsse.cisd.dsu.tracking.utils.LogUtils;
import ch.systemsx.cisd.common.collection.CollectionUtils;
import ch.systemsx.cisd.common.mail.From;
import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.openbis.generic.shared.ITrackingServer;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingDataSetCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TrackingSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class TrackingBO {
    private static final String SEQUENCING_SAMPLE_TYPE = "ILLUMINA_SEQUENCING";
    private static final String FLOW_LANE_SAMPLE_TYPE = "ILLUMINA_FLOW_LANE";
    private static final String PROCESSING_POSSIBLE_PROPERTY_CODE = "LIBRARY_PROCESSING_POSSIBLE";
    private static final String PROCESSING_SUCCESSFUL_PROPERTY_CODE = "LIBRARY_PROCESSING_SUCCESSFUL";
    private static final String TRUE = "true";
    private final ITrackingServer trackingServer;
    private final IEntityTrackingEmailGenerator emailGenerator;
    private final IMailClient mailClient;

    public TrackingBO(ITrackingServer trackingServer, IEntityTrackingEmailGenerator emailGenerator, IMailClient mailClient) {
        this.trackingServer = trackingServer;
        this.emailGenerator = emailGenerator;
        this.mailClient = mailClient;
    }

    public void trackAndNotify(ITrackingDAO trackingDAO, SessionContextDTO session) {
        TrackingStateDTO prevTrackingState = trackingDAO.getTrackingState();
        TrackedEntities changedEntities = TrackingBO.fetchChangedEntities(prevTrackingState, this.trackingServer, session);
        List<EmailWithSummary> emailsWithSummary = this.emailGenerator.generateEmails(changedEntities);
        TrackingBO.sendEmails(emailsWithSummary, this.mailClient);
        TrackingBO.saveTrackingState(prevTrackingState, changedEntities, trackingDAO);
    }

    private static void sendEmails(List<EmailWithSummary> emailsWithSummary, IMailClient mailClient) {
        for (EmailWithSummary emailWithSummary : emailsWithSummary) {
            Email email = emailWithSummary.getEmail();
            try {
                TrackingBO.logEmailSummary(emailWithSummary);
                TrackingBO.sendMessage(mailClient, email);
            }
            catch (Exception ex) {
                TrackingBO.sendErrorReport(mailClient, ex, email);
            }
        }
    }

    private static void logEmailSummary(EmailWithSummary emailWithSummary) {
        LogUtils.info("Sending an email [" + emailWithSummary.getEmail().getSubject() + "]. Summary:\n" + emailWithSummary.getSummary());
    }

    private static void sendErrorReport(IMailClient mailClient, Exception exception, Email email) {
        StringBuilder errorReportContentBuilder = new StringBuilder();
        TrackingBO.appendLine(errorReportContentBuilder, "Dear openBIS Admin,");
        TrackingBO.appendLine(errorReportContentBuilder, "This email has been generated automatically from the openBIS Changes Tracking system.");
        TrackingBO.appendLine(errorReportContentBuilder, "There was a failure while trying to send the email:");
        TrackingBO.appendLine(errorReportContentBuilder, exception.getMessage() == null ? "<no details>" : exception.getMessage());
        TrackingBO.appendLine(errorReportContentBuilder, "The possible reason is that the recipient address is not valid.");
        TrackingBO.appendLine(errorReportContentBuilder, "If you know the address of the recipient please correct it and forward this email to him.");
        TrackingBO.appendLine(errorReportContentBuilder, "!!! Note that the Tracking System will not try to send this email again !!!");
        TrackingBO.appendLine(errorReportContentBuilder, "Please correct the recipient email address in openBIS to avoid similar problems in future.");
        TrackingBO.appendLine(errorReportContentBuilder, "");
        TrackingBO.appendLine(errorReportContentBuilder, "Subject:    " + email.getSubject());
        TrackingBO.appendLine(errorReportContentBuilder, "Recipients: " + CollectionUtils.abbreviate(email.getRecipients(), -1));
        TrackingBO.appendLine(errorReportContentBuilder, "");
        TrackingBO.appendLine(errorReportContentBuilder, "Original content: ");
        TrackingBO.appendLine(errorReportContentBuilder, email.getContent());
        String errorReportContent = errorReportContentBuilder.toString();
        Email errorReportEmail = new Email("[Tracking] Sending an email failed", errorReportContent, null, email.getFromOrNull(), email.getReplyToOrNull());
        TrackingBO.sendMessage(mailClient, errorReportEmail);
    }

    private static void sendMessage(IMailClient mailClient, Email email) {
        String subject = email.getSubject();
        String content = email.getContent();
        String replyToOrNull = email.getReplyToOrNull();
        From fromOrNull = email.getFromOrNull();
        String[] recipients = email.getRecipients();
        mailClient.sendMessage(subject, content, replyToOrNull, fromOrNull, recipients);
    }

    private static void appendLine(StringBuilder sb, String msg) {
        sb.append(msg);
        sb.append("\n");
    }

    private static void saveTrackingState(TrackingStateDTO prevState, TrackedEntities changedEntities, ITrackingDAO trackingDAO) {
        TrackingStateDTO state = TrackingStateUpdateHelper.calcNewTrackingState(prevState, changedEntities);
        trackingDAO.saveTrackingState(state);
    }

    private static TrackedEntities fetchChangedEntities(TrackingStateDTO trackingState, ITrackingServer trackingServer, SessionContextDTO session) {
        List<Sample> sequencingSamplesToBeProcessed = TrackingBO.listSequencingSamples(PROCESSING_POSSIBLE_PROPERTY_CODE, trackingState.getAlreadyTrackedSampleIdsToBeProcessed(), trackingServer, session);
        List<Sample> sequencingSamplesSuccessfullyProcessed = TrackingBO.listSequencingSamples(PROCESSING_SUCCESSFUL_PROPERTY_CODE, trackingState.getAlreadyTrackedSampleIdsProcessed(), trackingServer, session);
        TrackingDataSetCriteria dataSetCriteria = new TrackingDataSetCriteria(FLOW_LANE_SAMPLE_TYPE, trackingState.getLastSeenDatasetId());
        List<AbstractExternalData> dataSets = trackingServer.listDataSets(session.getSessionToken(), dataSetCriteria);
        return new TrackedEntities(sequencingSamplesToBeProcessed, sequencingSamplesSuccessfullyProcessed, dataSets);
    }

    private static List<Sample> listSequencingSamples(String propertyTypeCode, Set<Long> alreadyTrackedSampleIds, ITrackingServer trackingServer, SessionContextDTO session) {
        return TrackingBO.listSamples(SEQUENCING_SAMPLE_TYPE, propertyTypeCode, TRUE, alreadyTrackedSampleIds, trackingServer, session);
    }

    private static List<Sample> listSamples(String sampleType, String propertyTypeCode, String propertyValue, Set<Long> alreadyTrackedSampleIds, ITrackingServer trackingServer, SessionContextDTO session) {
        TrackingSampleCriteria criteria = new TrackingSampleCriteria(sampleType, propertyTypeCode, propertyValue, alreadyTrackedSampleIds);
        return trackingServer.listSamples(session.getSessionToken(), criteria);
    }

    static class TrackingStateUpdateHelper {
        TrackingStateUpdateHelper() {
        }

        static TrackingStateDTO calcNewTrackingState(TrackingStateDTO prevState, TrackedEntities changedEntities) {
            TrackingStateDTO state = new TrackingStateDTO();
            TreeSet<Long> sequencingSamplesToBeProcessed = new TreeSet<Long>(prevState.getAlreadyTrackedSampleIdsToBeProcessed());
            TrackingStateUpdateHelper.addNewSampleIds(sequencingSamplesToBeProcessed, changedEntities.getSequencingSamplesToBeProcessed());
            state.setAlreadyTrackedSampleIdsToBeProcessed(sequencingSamplesToBeProcessed);
            TreeSet<Long> sequencingSamplesProcessed = new TreeSet<Long>(prevState.getAlreadyTrackedSampleIdsProcessed());
            TrackingStateUpdateHelper.addNewSampleIds(sequencingSamplesProcessed, changedEntities.getSequencingSamplesProcessed());
            state.setAlreadyTrackedSampleIdsProcessed(sequencingSamplesProcessed);
            long lastSeenDatasetId = TrackingStateUpdateHelper.calcMaxId(changedEntities.getDataSets(), prevState.getLastSeenDatasetId());
            state.setLastSeenDatasetId(lastSeenDatasetId);
            return state;
        }

        private static void addNewSampleIds(Set<Long> alreadyTrackedSampleIdsProcessed, List<Sample> sequencingSamplesProcessed) {
            for (Sample sample : sequencingSamplesProcessed) {
                alreadyTrackedSampleIdsProcessed.add(sample.getId());
            }
        }

        private static long calcMaxId(List<? extends IIdAndCodeHolder> entities, long initialValue) {
            long max = initialValue;
            for (IIdAndCodeHolder iIdAndCodeHolder : entities) {
                max = Math.max(max, iIdAndCodeHolder.getId());
            }
            return max;
        }
    }
}

