/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.common.fasta;

import ch.systemsx.cisd.common.fasta.SequenceType;
import ch.systemsx.cisd.common.utilities.Counters;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class FastaUtilities {
    public static final List<Character> NUCLEIC_ACID_CODES = Arrays.asList(Character.valueOf('A'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('R'), Character.valueOf('Y'), Character.valueOf('K'), Character.valueOf('M'), Character.valueOf('S'), Character.valueOf('W'), Character.valueOf('B'), Character.valueOf('D'), Character.valueOf('H'), Character.valueOf('V'), Character.valueOf('N'), Character.valueOf('X'), Character.valueOf('-'));
    public static final List<Character> AMINO_ACID_CODES = Arrays.asList(Character.valueOf('A'), Character.valueOf('B'), Character.valueOf('C'), Character.valueOf('D'), Character.valueOf('E'), Character.valueOf('F'), Character.valueOf('G'), Character.valueOf('H'), Character.valueOf('I'), Character.valueOf('J'), Character.valueOf('K'), Character.valueOf('L'), Character.valueOf('M'), Character.valueOf('N'), Character.valueOf('O'), Character.valueOf('P'), Character.valueOf('Q'), Character.valueOf('R'), Character.valueOf('S'), Character.valueOf('T'), Character.valueOf('U'), Character.valueOf('V'), Character.valueOf('W'), Character.valueOf('Y'), Character.valueOf('Z'), Character.valueOf('X'), Character.valueOf('*'), Character.valueOf('-'));
    private static final Set<Character> NUCLEIC_ACID_CODES_SET = new HashSet<Character>(NUCLEIC_ACID_CODES);
    private static final Set<Character> AMINO_ACID_CODES_SET = new HashSet<Character>(AMINO_ACID_CODES);

    public static SequenceType determineSequenceType(String line) {
        Counters<Character> counters = new Counters<Character>();
        int sequenceCharacters = 0;
        char[] cArray = line.toUpperCase().toCharArray();
        int n = cArray.length;
        int n2 = 0;
        while (n2 < n) {
            char c = cArray[n2];
            boolean isNucleicAcidCode = NUCLEIC_ACID_CODES_SET.contains(Character.valueOf(c));
            boolean isAmoniAcidCode = AMINO_ACID_CODES_SET.contains(Character.valueOf(c));
            if (isNucleicAcidCode || isAmoniAcidCode) {
                ++sequenceCharacters;
                if (!isNucleicAcidCode) {
                    return SequenceType.PROT;
                }
                counters.count(Character.valueOf(c));
            }
            ++n2;
        }
        if (counters.getNumberOfDifferentObjectsCounted() > 6 || FastaUtilities.containsUAndT(counters)) {
            return SequenceType.PROT;
        }
        int nonCommonNucleicAcidCodeSites = sequenceCharacters;
        char[] cArray2 = "ACGTUN-".toCharArray();
        int n3 = cArray2.length;
        n = 0;
        while (n < n3) {
            Character c = Character.valueOf(cArray2[n]);
            nonCommonNucleicAcidCodeSites -= counters.getCountOf(c);
            ++n;
        }
        return nonCommonNucleicAcidCodeSites == 0 ? SequenceType.NUCL : SequenceType.PROT;
    }

    private static boolean containsUAndT(Counters<Character> counters) {
        return counters.getCountOf(Character.valueOf('T')) > 0 && counters.getCountOf(Character.valueOf('U')) > 0;
    }
}

