/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard;

import ch.systemsx.cisd.common.time.TimingParameters;
import ch.systemsx.cisd.openbis.dss.generic.server.AbstractDataSetPackager;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IPackageManager;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IHierarchicalContentProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.utils.DataSetExistenceChecker;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import java.io.File;
import java.util.Collections;
import java.util.List;
import java.util.Properties;

abstract class AbstractPackageManager
implements IPackageManager {
    private transient IHierarchicalContentProvider contentProvider;
    private transient IDataSetDirectoryProvider directoryProvider;

    AbstractPackageManager() {
    }

    @Override
    public void create(File packageFile, AbstractExternalData dataSet) {
        this.create(packageFile, Collections.singletonList(dataSet), false);
    }

    @Override
    public void create(File packageFile, List<AbstractExternalData> dataSets) {
        this.create(packageFile, dataSets, true);
    }

    private void create(File packageFile, List<AbstractExternalData> dataSets, boolean withPathPrefix) {
        AbstractDataSetPackager packager = null;
        try {
            DataSetExistenceChecker existenceChecker = new DataSetExistenceChecker(this.getDirectoryProvider(), TimingParameters.create(new Properties()));
            packager = this.createPackager(packageFile, existenceChecker);
            for (AbstractExternalData dataSet : dataSets) {
                packager.addDataSetTo(withPathPrefix ? String.valueOf(dataSet.getCode()) + "/" : "", dataSet);
            }
        }
        finally {
            if (packager != null) {
                packager.close();
            }
        }
    }

    protected abstract AbstractDataSetPackager createPackager(File var1, DataSetExistenceChecker var2);

    protected IHierarchicalContentProvider getContentProvider() {
        if (this.contentProvider == null) {
            this.contentProvider = ServiceProvider.getHierarchicalContentProvider();
        }
        return this.contentProvider;
    }

    private IDataSetDirectoryProvider getDirectoryProvider() {
        if (this.directoryProvider == null) {
            this.directoryProvider = ServiceProvider.getDataStoreService().getDataSetDirectoryProvider();
        }
        return this.directoryProvider;
    }
}

