/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.property;

import ch.systemsx.cisd.openbis.generic.client.web.client.IClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.ICommonClientServiceAsync;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.AbstractAsyncCallback;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.DisposableTabContent;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.DisplayTypeIDGenerator;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.TypedTableGrid;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.DefaultResultSetConfig;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.ListEntityHistoryCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TableExportCriteria;
import ch.systemsx.cisd.openbis.generic.client.web.client.dto.TypedTableResultSet;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityHistory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.EntityKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModelRowWithObject;

public class EntityHistoryGrid
extends TypedTableGrid<EntityHistory> {
    public static final String BROWSER_ID = "openbis_entity_history_browser";
    public static final String GRID_ID = "openbis_entity_history_browser-grid";
    private EntityKind entityKind;
    private TechId entityID;

    public static DisposableTabContent createPropertiesHistorySection(IViewContext<? extends IClientServiceAsync> viewContext, final EntityKind entityKind, final TechId entityID) {
        DisposableTabContent tabContent = new DisposableTabContent(viewContext.getMessage("entity_history_tab", new Object[0]), viewContext, null){

            @Override
            protected IDisposableComponent createDisposableContent() {
                EntityHistoryGrid grid = new EntityHistoryGrid(this.viewContext.getCommonViewContext(), entityKind, entityID, null);
                return grid.asDisposableWithoutToolbar();
            }
        };
        tabContent.setIds(DisplayTypeIDGenerator.ENTITY_HISTORY_SECTION);
        return tabContent;
    }

    private EntityHistoryGrid(IViewContext<ICommonClientServiceAsync> viewContext, EntityKind entityKind, TechId entityID) {
        super(viewContext, BROWSER_ID, true, DisplayTypeIDGenerator.ENTITY_HISTORY_BROWSER_GRID);
        this.entityKind = entityKind;
        this.entityID = entityID;
    }

    @Override
    protected void listTableRows(DefaultResultSetConfig<String, TableModelRowWithObject<EntityHistory>> resultSetConfig, AbstractAsyncCallback<TypedTableResultSet<EntityHistory>> callback) {
        ListEntityHistoryCriteria criteria = new ListEntityHistoryCriteria();
        criteria.copyPagingConfig(resultSetConfig);
        criteria.setEntityKind(this.entityKind);
        criteria.setEntityID(this.entityID);
        ((ICommonClientServiceAsync)this.viewContext.getService()).listEntityHistory(criteria, callback);
    }

    @Override
    protected void prepareExportEntities(TableExportCriteria<TableModelRowWithObject<EntityHistory>> exportCriteria, AbstractAsyncCallback<String> callback) {
        ((ICommonClientServiceAsync)this.viewContext.getService()).prepareExportEntityHistory(exportCriteria, callback);
    }

    /* synthetic */ EntityHistoryGrid(IViewContext iViewContext, EntityKind entityKind, TechId techId, EntityHistoryGrid entityHistoryGrid) {
        this((IViewContext<ICommonClientServiceAsync>)iViewContext, entityKind, techId);
    }
}

