/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.business.bo;

import ch.systemsx.cisd.openbis.generic.shared.basic.IIdentifierHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Deletion;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedDataPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedExperimentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DeletedSamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IDeletablePE;
import ch.systemsx.cisd.openbis.generic.shared.translator.DeletedEntityTranslator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

final class RootEntitiesFinder {
    private List<DeletedExperimentPE> experiments = new ArrayList<DeletedExperimentPE>();
    private Set<Long> experimentIDs = new HashSet<Long>();
    private List<DeletedSamplePE> samples = new ArrayList<DeletedSamplePE>();
    private Set<Long> sampleIDs = new HashSet<Long>();
    private List<DeletedDataPE> dataSets = new ArrayList<DeletedDataPE>();

    RootEntitiesFinder() {
    }

    void addEntity(IDeletablePE entity) {
        if (entity instanceof DeletedExperimentPE) {
            this.addExperiment((DeletedExperimentPE)entity);
        }
        if (entity instanceof DeletedSamplePE) {
            this.addSample((DeletedSamplePE)entity);
        }
        if (entity instanceof DeletedDataPE) {
            this.addDataSet((DeletedDataPE)entity);
        }
    }

    private void addExperiment(DeletedExperimentPE experiment) {
        this.experiments.add(experiment);
        this.experimentIDs.add(experiment.getId());
    }

    private void addSample(DeletedSamplePE sample) {
        this.samples.add(sample);
        this.sampleIDs.add(sample.getId());
    }

    private void addDataSet(DeletedDataPE dataSet) {
        if (this.experimentIDs.contains(dataSet.getExperimentId())) {
            return;
        }
        if (this.sampleIDs.contains(dataSet.getSampleId())) {
            return;
        }
        this.dataSets.add(dataSet);
    }

    void addRootEntitiesTo(Deletion deletion) {
        Collections.sort(this.experiments, this.createIdentifierComparator());
        for (DeletedExperimentPE experiment : this.experiments) {
            deletion.addDeletedEntity(DeletedEntityTranslator.translate(experiment));
        }
        List<DeletedSamplePE> rootSamples = this.findRootSamples();
        Collections.sort(rootSamples, this.createIdentifierComparator());
        for (DeletedSamplePE sample : rootSamples) {
            deletion.addDeletedEntity(DeletedEntityTranslator.translate(sample));
        }
        Collections.sort(this.dataSets, this.createIdentifierComparator());
        for (DeletedDataPE dataSet : this.dataSets) {
            deletion.addDeletedEntity(DeletedEntityTranslator.translate(dataSet));
        }
    }

    Comparator<IIdentifierHolder> createIdentifierComparator() {
        return new Comparator<IIdentifierHolder>(){

            @Override
            public int compare(IIdentifierHolder d1, IIdentifierHolder d2) {
                return d1.getIdentifier().compareTo(d2.getIdentifier());
            }
        };
    }

    private List<DeletedSamplePE> findRootSamples() {
        ArrayList<DeletedSamplePE> rootSamples = new ArrayList<DeletedSamplePE>();
        for (DeletedSamplePE sample : this.samples) {
            List<Long> parents;
            if (this.experimentIDs.contains(sample.getExperimentId()) || this.sampleIDs.contains(sample.getContainerId()) || (parents = sample.getParents()) != null && this.atLeastOneDeleted(parents)) continue;
            rootSamples.add(sample);
        }
        return rootSamples;
    }

    private boolean atLeastOneDeleted(List<Long> parents) {
        return !Collections.disjoint(this.sampleIDs, parents);
    }
}

