/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.dataaccess.db;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IAttachmentDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.PersistencyResources;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.AbstractGenericEntityDAO;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.db.search.IndexUpdateOperation;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentHolderPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.AttachmentPE;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatabaseInstancePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.IEntityInformationWithPropertiesHolder;
import java.util.Arrays;
import java.util.List;
import org.apache.commons.lang.StringUtils;
import org.apache.log4j.Logger;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.springframework.dao.DataAccessException;
import org.springframework.orm.hibernate3.HibernateTemplate;

final class AttachmentDAO
extends AbstractGenericEntityDAO<AttachmentPE>
implements IAttachmentDAO {
    private static final Class<AttachmentPE> ATTACHMENT_CLASS = AttachmentPE.class;
    private static final String TABLE_NAME = ATTACHMENT_CLASS.getSimpleName();
    private final PersistencyResources persistencyResources;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, AttachmentDAO.class);

    AttachmentDAO(SessionFactory sessionFactory, DatabaseInstancePE databaseInstance, PersistencyResources persistencyResources) {
        super(sessionFactory, databaseInstance, ATTACHMENT_CLASS);
        this.persistencyResources = persistencyResources;
    }

    private static final String createFindLastVersionQuery(AttachmentHolderPE owner) {
        return AttachmentDAO.createFindLastVersionQuery(owner, "?");
    }

    private static final String createFindLastVersionQuery(AttachmentHolderPE owner, String fileName) {
        String ownerAsParent = AttachmentDAO.getParentName(owner);
        return String.format("select max(version) from %s where " + ownerAsParent + " = ? and fileName = %s", TABLE_NAME, fileName);
    }

    private static String getParentName(AttachmentHolderPE owner) {
        String ownerAsParent = String.valueOf(owner.getHolderName()) + "ParentInternal";
        return ownerAsParent;
    }

    @Override
    public final AttachmentHolderPE createAttachment(AttachmentPE attachment, AttachmentHolderPE ownerParam) throws DataAccessException {
        assert (attachment != null) : "Unspecified attachment";
        assert (attachment.getAttachmentContent() != null) : "Unspecified attachment content.";
        AttachmentHolderPE owner = ownerParam;
        AttachmentDAO.validatePE(attachment.getAttachmentContent());
        AttachmentPE previousAttachmentVersionOrNull = this.tryFindAttachmentByOwnerAndFileName(owner, attachment.getFileName());
        this.fillAttachmentData(attachment, previousAttachmentVersionOrNull);
        HibernateTemplate template = this.getHibernateTemplate();
        Session session = this.getSession();
        if (!session.contains((Object)owner)) {
            owner = (AttachmentHolderPE)session.merge((Object)owner);
        }
        owner.addAttachment(attachment);
        AttachmentDAO.validatePE(attachment);
        template.save((Object)attachment);
        template.flush();
        if (operationLog.isInfoEnabled()) {
            operationLog.info((Object)String.format("ADD: file attachment '%s'.", attachment));
        }
        this.scheduleDynamicPropertiesEvaluation(ownerParam);
        return owner;
    }

    private void fillAttachmentData(AttachmentPE attachment, AttachmentPE previousAttachmentVersionOrNull) {
        int previousVersion = 0;
        if (previousAttachmentVersionOrNull != null) {
            previousVersion = previousAttachmentVersionOrNull.getVersion();
            if (StringUtils.isBlank((String)attachment.getTitle())) {
                attachment.setTitle(previousAttachmentVersionOrNull.getTitle());
            }
            if (StringUtils.isBlank((String)attachment.getDescription())) {
                attachment.setDescription(previousAttachmentVersionOrNull.getDescription());
            }
        }
        attachment.setVersion(previousVersion + 1);
    }

    @Override
    public final List<AttachmentPE> listAttachments(AttachmentHolderPE owner) throws DataAccessException {
        assert (owner != null) : "Unspecified attachment holder.";
        String query = String.format("from %s where " + AttachmentDAO.getParentName(owner) + " = ?", TABLE_NAME);
        List<AttachmentPE> result = AttachmentDAO.cast(this.getHibernateTemplate().find(query, AttachmentDAO.toArray(owner)));
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%d attachment(s) found for " + owner.getHolderName() + " '%s'.", result.size(), owner));
        }
        return result;
    }

    @Override
    public final AttachmentPE tryFindAttachmentByOwnerAndFileName(AttachmentHolderPE owner, String fileName) throws DataAccessException {
        assert (fileName != null) : "Unspecified file name.";
        assert (owner != null) : "Unspecified parent attachment holder.";
        String query = String.format("from %s where " + AttachmentDAO.getParentName(owner) + " = ? and fileName = ? and version = (" + AttachmentDAO.createFindLastVersionQuery(owner) + ")", TABLE_NAME);
        List result = AttachmentDAO.cast(this.getHibernateTemplate().find(query, AttachmentDAO.toArray(owner, fileName, owner, fileName)));
        AttachmentPE attachment = (AttachmentPE)AttachmentDAO.tryFindEntity(result, "attachment", owner, fileName);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s found for " + owner.getHolderName() + " '%s' and file name '%s'.", attachment == null ? "No attachment" : "Attachment '" + attachment + "'", owner, fileName));
        }
        return attachment;
    }

    @Override
    public final AttachmentPE tryFindAttachmentByOwnerAndFileNameAndVersion(AttachmentHolderPE owner, String fileName, int version) throws DataAccessException {
        assert (owner != null) : "Unspecified attachment holder.";
        assert (fileName != null) : "Unspecified file name.";
        assert (version > 0) : "Version must be > 0.";
        String query = String.format("from %s where " + AttachmentDAO.getParentName(owner) + " = ? and fileName = ? and version = ?", TABLE_NAME);
        List result = AttachmentDAO.cast(this.getHibernateTemplate().find(query, AttachmentDAO.toArray(owner, fileName, version)));
        AttachmentPE attachment = (AttachmentPE)AttachmentDAO.tryFindEntity(result, "attachment", owner, fileName, version);
        if (operationLog.isDebugEnabled()) {
            operationLog.debug((Object)String.format("%s found for " + owner.getHolderName() + " '%s', file name '%s' and version %d.", attachment == null ? "No attachment" : "Attachment '" + attachment + "'", owner, fileName, version));
        }
        return attachment;
    }

    @Override
    public int deleteByOwnerAndFileName(AttachmentHolderPE owner, String fileName) throws DataAccessException {
        assert (owner != null) : "Unspecified attachment holder.";
        assert (fileName != null) : "Unspecified file name.";
        HibernateTemplate hibernateTemplate = this.getHibernateTemplate();
        int deletedRows = 0;
        for (AttachmentPE att : owner.getAttachments()) {
            if (!fileName.equals(att.getFileName())) continue;
            owner.removeAttachment(att);
            hibernateTemplate.delete((Object)att);
            ++deletedRows;
        }
        hibernateTemplate.flush();
        this.scheduleRemoveFromFullTextIndex(owner);
        if (operationLog.isInfoEnabled()) {
            operationLog.debug((Object)String.format("%s attachment(s) deleted for %s '%s' and file name '%s'.", deletedRows, owner.getHolderName(), owner, fileName));
        }
        return deletedRows;
    }

    private void scheduleDynamicPropertiesEvaluation(AttachmentHolderPE owner) {
        if (IEntityInformationWithPropertiesHolder.class.isAssignableFrom(owner.getClass())) {
            IEntityInformationWithPropertiesHolder entity = (IEntityInformationWithPropertiesHolder)((Object)owner);
            this.persistencyResources.getDynamicPropertyEvaluationScheduler().scheduleUpdate(DynamicPropertyEvaluationOperation.evaluate(entity.getClass(), Arrays.asList(entity.getId())));
        }
    }

    protected void scheduleRemoveFromFullTextIndex(AttachmentHolderPE owner) {
        if (IEntityInformationWithPropertiesHolder.class.isAssignableFrom(owner.getClass())) {
            IEntityInformationWithPropertiesHolder entity = (IEntityInformationWithPropertiesHolder)((Object)owner);
            this.persistencyResources.getIndexUpdateScheduler().scheduleUpdate(IndexUpdateOperation.remove(entity.getClass(), Arrays.asList(entity.getId())));
        }
    }
}

