/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.generic.server.task;

import ch.systemsx.cisd.common.filesystem.FileUtilities;
import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.common.maintenance.IMaintenanceTask;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.common.utilities.ITimeProvider;
import ch.systemsx.cisd.common.utilities.SystemTimeProvider;
import ch.systemsx.cisd.openbis.generic.server.CommonServiceProvider;
import ch.systemsx.cisd.openbis.generic.server.ICommonServerForInternalUse;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.DynamicPropertyEvaluationOperation;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationScheduler;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDynamicPropertyEvaluationSchedulerWithQueue;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.CompareType;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchCriterion;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DetailedSearchField;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Material;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.MaterialAttributeSearchFieldKind;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SearchCriteriaConnection;
import ch.systemsx.cisd.openbis.generic.shared.dto.SamplePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.SessionContextDTO;
import ch.systemsx.cisd.openbis.generic.shared.util.SimplePropertyValidator;
import java.io.File;
import java.text.ParseException;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.apache.log4j.Logger;

public class DynamicPropertyEvaluationTriggeredByMaterialChangeMaintenanceTask
implements IMaintenanceTask {
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, DynamicPropertyEvaluationTriggeredByMaterialChangeMaintenanceTask.class);
    static final String TIMESTAMP_FILE_KEY = "timestamp-file";
    static final String DEFAULT_TIMESTAMP_FILE = "../../../data/" + DynamicPropertyEvaluationTriggeredByMaterialChangeMaintenanceTask.class.getSimpleName() + "-timestamp.txt";
    static final String INITIAL_TIMESTAMP_KEY = "initial-timestamp";
    private final ICommonServerForInternalUse server;
    private final IDynamicPropertyEvaluationScheduler scheduler;
    private final ITimeProvider timeProvider;
    private File timestampFile;
    private String initialTimestamp;

    public DynamicPropertyEvaluationTriggeredByMaterialChangeMaintenanceTask() {
        this(CommonServiceProvider.getCommonServer(), CommonServiceProvider.getDAOFactory().getPersistencyResources().getDynamicPropertyEvaluationScheduler(), SystemTimeProvider.SYSTEM_TIME_PROVIDER);
    }

    DynamicPropertyEvaluationTriggeredByMaterialChangeMaintenanceTask(ICommonServerForInternalUse server, IDynamicPropertyEvaluationScheduler scheduler, ITimeProvider timeProvider) {
        this.server = server;
        this.scheduler = scheduler;
        this.timeProvider = timeProvider;
    }

    @Override
    public void setUp(String pluginName, Properties properties) {
        this.timestampFile = new File(properties.getProperty(TIMESTAMP_FILE_KEY, DEFAULT_TIMESTAMP_FILE));
        this.initialTimestamp = PropertyUtils.getMandatoryProperty(properties, INITIAL_TIMESTAMP_KEY);
    }

    @Override
    public void execute() {
        String timestamp = this.getTimestamp();
        SessionContextDTO contextOrNull = this.server.tryToAuthenticateAsSystem();
        if (contextOrNull == null) {
            operationLog.warn((Object)"Couldn't authenticate as system.");
            return;
        }
        String sessionToken = contextOrNull.getSessionToken();
        try {
            String newTimestamp = this.createTimestamp();
            Collection<TechId> allMaterialIds = this.getAllChangedMaterials(sessionToken, timestamp);
            if (!allMaterialIds.isEmpty()) {
                List<Sample> samples = this.server.listSamplesByMaterialProperties(sessionToken, allMaterialIds);
                operationLog.info((Object)(String.valueOf(samples.size()) + " samples found for changed materials."));
                if (!samples.isEmpty()) {
                    List<Long> ids = TechId.asLongs(TechId.createList(samples));
                    DynamicPropertyEvaluationOperation operation = DynamicPropertyEvaluationOperation.evaluate(SamplePE.class, ids);
                    this.scheduler.scheduleUpdate(operation);
                    if (this.scheduler instanceof IDynamicPropertyEvaluationSchedulerWithQueue) {
                        ((IDynamicPropertyEvaluationSchedulerWithQueue)this.scheduler).synchronizeThreadQueue();
                    }
                }
            }
            this.saveTimestamp(newTimestamp);
        }
        finally {
            this.server.logout(sessionToken);
        }
    }

    private Collection<TechId> getAllChangedMaterials(String sessionToken, String timestamp) {
        DetailedSearchCriteria criteria = new DetailedSearchCriteria();
        DetailedSearchCriterion criterion = new DetailedSearchCriterion(DetailedSearchField.createAttributeField(MaterialAttributeSearchFieldKind.MODIFICATION_DATE), CompareType.MORE_THAN_OR_EQUAL, timestamp);
        criteria.setCriteria(Arrays.asList(criterion));
        criteria.setConnection(SearchCriteriaConnection.MATCH_ALL);
        List<Material> materials = this.server.searchForMaterials(sessionToken, criteria);
        int numberOfChangedMaterials = materials.size();
        operationLog.info((Object)(String.valueOf(numberOfChangedMaterials) + " materials changed since [" + timestamp + "]."));
        HashSet<TechId> allMaterialIds = new HashSet<TechId>();
        Collection<TechId> materialIds = TechId.createList(materials);
        while (!materialIds.isEmpty()) {
            materialIds.removeAll(allMaterialIds);
            allMaterialIds.addAll(materialIds);
            materialIds = this.server.listMaterialIdsByMaterialProperties(sessionToken, materialIds);
        }
        if (numberOfChangedMaterials != allMaterialIds.size()) {
            operationLog.info((Object)(String.valueOf(allMaterialIds.size()) + " materials in total changed."));
        }
        return allMaterialIds;
    }

    private String getTimestamp() {
        String timestamp = null;
        if (this.timestampFile.isFile()) {
            timestamp = FileUtilities.loadToString(this.timestampFile).trim();
            try {
                DateUtils.parseDate((String)timestamp, (String[])new String[]{SimplePropertyValidator.SupportedDatePattern.CANONICAL_DATE_PATTERN.getPattern()});
            }
            catch (ParseException parseException) {
                operationLog.warn((Object)("Invalid timestamp in file '" + this.timestampFile + "': " + timestamp));
                timestamp = null;
            }
        }
        return timestamp != null ? timestamp : this.initialTimestamp;
    }

    private String createTimestamp() {
        return DateFormatUtils.format((Date)new Date(this.timeProvider.getTimeInMilliseconds()), (String)SimplePropertyValidator.SupportedDatePattern.CANONICAL_DATE_PATTERN.getPattern());
    }

    private void saveTimestamp(String newTimestamp) {
        this.timestampFile.getParentFile().mkdirs();
        FileUtilities.writeToFile(this.timestampFile, newTimestamp);
        operationLog.info((Object)("Timestamp [" + newTimestamp + "] saved in '" + this.timestampFile + "'."));
    }
}

