/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application;

import ch.systemsx.cisd.openbis.generic.client.web.client.application.IViewContext;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.framework.IDatabaseModificationObserver;
import ch.systemsx.cisd.openbis.generic.client.web.client.application.ui.grid.IDisposableComponent;
import ch.systemsx.cisd.openbis.generic.shared.basic.IIdAndCodeHolder;
import ch.systemsx.cisd.openbis.generic.shared.basic.TechId;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.IPhosphoNetXClientServiceAsync;
import ch.systemsx.cisd.openbis.plugin.proteomics.client.web.client.application.ProteinRelatedSampleGrid;
import com.extjs.gxt.ui.client.widget.ContentPanel;
import com.extjs.gxt.ui.client.widget.Layout;
import com.extjs.gxt.ui.client.widget.layout.FitLayout;

public class ProteinSamplesSection
extends ContentPanel {
    private static final String PREFIX = "protein-samples-section_";
    public static final String ID_PREFIX = "openbis_protein-samples-section_";
    private IDisposableComponent disposableComponent;

    public ProteinSamplesSection(IViewContext<IPhosphoNetXClientServiceAsync> viewContext, TechId proteinReferenceID, IIdAndCodeHolder experimentOrNull) {
        this.setHeading("Samples");
        this.setHeaderVisible(true);
        this.setCollapsible(true);
        this.setAnimCollapse(false);
        this.setBodyBorder(true);
        this.setLayout((Layout)new FitLayout());
        Long experimentID = experimentOrNull == null ? null : experimentOrNull.getId();
        this.disposableComponent = ProteinRelatedSampleGrid.createGridForProteinSamples(viewContext, proteinReferenceID, experimentID, ProteinSamplesSection.createGridId(proteinReferenceID));
        this.add(this.disposableComponent.getComponent());
    }

    static String createGridId(TechId containerId) {
        return ID_PREFIX + containerId + "-grid";
    }

    protected void onDetach() {
        if (this.disposableComponent != null) {
            this.disposableComponent.dispose();
        }
        super.onDetach();
    }

    IDatabaseModificationObserver tryGetDatabaseModificationObserver() {
        return this.disposableComponent;
    }
}

