/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.business;

import ch.systemsx.cisd.common.collection.IValidator;
import ch.systemsx.cisd.openbis.generic.server.business.bo.ICommonBusinessObjectFactory;
import ch.systemsx.cisd.openbis.generic.server.business.bo.samplelister.ISampleLister;
import ch.systemsx.cisd.openbis.generic.server.dataaccess.IDAOFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ListOrSearchSampleCriteria;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleRelationshipSkeleton;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleSkeleton;
import ch.systemsx.cisd.openbis.generic.shared.dto.SampleTypePE;
import ch.systemsx.cisd.openbis.generic.shared.dto.Session;
import ch.systemsx.cisd.openbis.generic.shared.dto.SpacePE;
import ch.systemsx.cisd.openbis.plugin.proteomics.server.business.ISampleLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class SampleLoader
implements ISampleLoader {
    private final Session session;
    private final IDAOFactory daoFactory;
    private final ICommonBusinessObjectFactory businessObjectFactory;

    public SampleLoader(Session session, IDAOFactory daoFactory, ICommonBusinessObjectFactory businessObjectFactory) {
        this.session = session;
        this.daoFactory = daoFactory;
        this.businessObjectFactory = businessObjectFactory;
    }

    @Override
    public List<Sample> listSamplesWithParentsByTypeAndSpace(String sampleTypeCode, String spaceCode) {
        ISampleLister sampleLister = this.businessObjectFactory.createSampleLister(this.session);
        Set<Long> filteredSampleIDs = this.getSampleIDs(sampleLister, sampleTypeCode, spaceCode);
        ListOrSearchSampleCriteria criteria = new ListOrSearchSampleCriteria(filteredSampleIDs);
        criteria.setEnrichDependentSamplesWithProperties(true);
        List<Sample> samples = sampleLister.list(criteria);
        ArrayList<Sample> samplesWithParent = new ArrayList<Sample>();
        for (Sample sample : samples) {
            if (sample.getParents().size() != 1) continue;
            samplesWithParent.add(sample);
        }
        return samplesWithParent;
    }

    private Set<Long> getSampleIDs(ISampleLister sampleLister, String sampleTypeCode, String spaceCode) {
        SampleTypePE sampleTypePE = this.daoFactory.getSampleTypeDAO().tryFindSampleTypeByCode(sampleTypeCode);
        if (sampleTypePE == null) {
            return Collections.emptySet();
        }
        final Long sampleTypeID = sampleTypePE.getId();
        SpacePE space = this.daoFactory.getSpaceDAO().tryFindSpaceByCodeAndDatabaseInstance(spaceCode, this.daoFactory.getHomeDatabaseInstance());
        if (space == null) {
            return Collections.emptySet();
        }
        final Long spaceID = space.getId();
        List<SampleSkeleton> sampleSkeletons = sampleLister.listSampleBy(new IValidator<SampleSkeleton>(){

            @Override
            public boolean isValid(SampleSkeleton sampleSkeleton) {
                return spaceID.equals(sampleSkeleton.getSpaceID()) && sampleTypeID.equals(sampleSkeleton.getTypeID());
            }
        });
        final HashSet<Long> sampleIDs = new HashSet<Long>();
        for (SampleSkeleton sampleSkeleton : sampleSkeletons) {
            sampleIDs.add(sampleSkeleton.getId());
        }
        final long relationshipTypeID = sampleLister.getRelationshipTypeID("$PARENT_CHILD");
        List<SampleRelationshipSkeleton> relationshipSkeletons = sampleLister.listSampleRelationshipsBy(new IValidator<SampleRelationshipSkeleton>(){

            @Override
            public boolean isValid(SampleRelationshipSkeleton skeleton) {
                return skeleton.getRelationshipTypeID() == relationshipTypeID && sampleIDs.contains(skeleton.getChildSampleID());
            }
        });
        HashSet<Long> filteredSampleIDs = new HashSet<Long>();
        for (SampleRelationshipSkeleton sampleRelationShipSkeleton : relationshipSkeletons) {
            filteredSampleIDs.add(sampleRelationShipSkeleton.getChildSampleID());
        }
        return filteredSampleIDs;
    }
}

