/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.proteomics.server.dataaccess.db.migration;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.dbmigration.java.MigrationStepAdapter;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.Occurrence;
import ch.systemsx.cisd.openbis.plugin.proteomics.shared.basic.dto.OccurrenceUtil;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.log4j.Logger;
import org.springframework.dao.DataAccessException;
import org.springframework.jdbc.core.JdbcOperations;
import org.springframework.jdbc.core.ResultSetExtractor;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class MigrationStepFrom002To003
extends MigrationStepAdapter {
    private static final long MB = 0x100000L;
    private static final Logger operationLog = LogFactory.getLogger(LogCategory.OPERATION, MigrationStepFrom002To003.class);

    @Override
    public void performPostMigration(SimpleJdbcTemplate simpleJdbcTemplate, DataSource dataSource) throws DataAccessException {
        List<Object[]> coverageValues = this.calculateCoverageValues(simpleJdbcTemplate);
        operationLog.info((Object)("update " + coverageValues.size() + " identified proteins"));
        simpleJdbcTemplate.batchUpdate("update identified_proteins set coverage = ? where id = ?", coverageValues);
    }

    private List<Object[]> calculateCoverageValues(SimpleJdbcTemplate simpleJdbcTemplate) {
        this.logMemory();
        JdbcOperations jdbcOperations = simpleJdbcTemplate.getJdbcOperations();
        final Map<Long, List<String>> peptides = this.getPeptides(jdbcOperations);
        this.logMemory();
        final ArrayList<Object[]> values = new ArrayList<Object[]>();
        jdbcOperations.query("select ip.id, ip.prot_id, s.amino_acid_sequence from identified_proteins as ip join sequences as s on ip.sequ_id = s.id where coverage is null", new ResultSetExtractor(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                while (rs.next()) {
                    long id = rs.getLong(1);
                    long proteinID = rs.getLong(2);
                    String sequence = rs.getString(3);
                    List peptideSequences = (List)peptides.get(proteinID);
                    double coverage = MigrationStepFrom002To003.this.calculateCoverage(sequence, peptideSequences);
                    values.add(new Object[]{coverage, id});
                }
                return null;
            }
        });
        this.logMemory();
        return values;
    }

    private Map<Long, List<String>> getPeptides(JdbcOperations jdbcOperations) {
        final HashMap<Long, List<String>> peptides = new HashMap<Long, List<String>>();
        jdbcOperations.query("select prot_id, sequence from peptides order by prot_id", new ResultSetExtractor(){

            public Object extractData(ResultSet rs) throws SQLException, DataAccessException {
                long currentProteinID = -1L;
                ArrayList<String> list = null;
                while (rs.next()) {
                    long proteinID = rs.getLong(1);
                    if (list == null || proteinID != currentProteinID) {
                        if (list != null) {
                            list.trimToSize();
                        }
                        currentProteinID = proteinID;
                        list = new ArrayList<String>();
                        peptides.put(proteinID, list);
                    }
                    list.add(rs.getString(2));
                }
                return null;
            }
        });
        return peptides;
    }

    private double calculateCoverage(String sequence, List<String> peptides) {
        HashSet<String> distinctPeptides = new HashSet<String>(peptides);
        List<Occurrence> list = OccurrenceUtil.getCoverage(sequence, distinctPeptides);
        int sumPeptides = 0;
        for (Occurrence occurrence : list) {
            sumPeptides += occurrence.getWord().length();
        }
        return (double)sumPeptides / (double)sequence.length();
    }

    private void logMemory() {
        Runtime runtime = Runtime.getRuntime();
        long usedMemory = (runtime.totalMemory() - runtime.freeMemory()) / 0x100000L;
        operationLog.info((Object)(String.valueOf(usedMemory) + " MB used, " + runtime.totalMemory() / 0x100000L + " MB total"));
    }
}

