/*
 * Decompiled with CFR 0.152.
 */
package com.googlecode.jsonrpc4j;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.googlecode.jsonrpc4j.AnnotationsErrorResolver;
import com.googlecode.jsonrpc4j.Base64;
import com.googlecode.jsonrpc4j.DefaultErrorResolver;
import com.googlecode.jsonrpc4j.ErrorResolver;
import com.googlecode.jsonrpc4j.JsonRpcParam;
import com.googlecode.jsonrpc4j.JsonRpcParamName;
import com.googlecode.jsonrpc4j.MultipleErrorResolver;
import com.googlecode.jsonrpc4j.NoCloseInputStream;
import com.googlecode.jsonrpc4j.NoCloseOutputStream;
import com.googlecode.jsonrpc4j.ReflectionUtil;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.portlet.ResourceRequest;
import javax.portlet.ResourceResponse;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class JsonRpcServer {
    private static final Logger LOGGER = Logger.getLogger(JsonRpcServer.class.getName());
    public static final String JSONRPC_RESPONSE_CONTENT_TYPE = "application/json-rpc";
    public static final ErrorResolver DEFAULT_ERRROR_RESOLVER = new MultipleErrorResolver(AnnotationsErrorResolver.INSTANCE, DefaultErrorResolver.INSTANCE);
    private boolean backwardsComaptible = true;
    private boolean rethrowExceptions = false;
    private boolean allowExtraParams = false;
    private boolean allowLessParams = false;
    private ErrorResolver errorResolver = null;
    private ObjectMapper mapper;
    private Object handler;
    private Class<?> remoteInterface;

    public JsonRpcServer(ObjectMapper mapper, Object handler, Class<?> remoteInterface) {
        this.mapper = mapper;
        this.handler = handler;
        this.remoteInterface = remoteInterface;
    }

    public JsonRpcServer(ObjectMapper mapper, Object handler) {
        this(mapper, handler, null);
    }

    public JsonRpcServer(Object handler, Class<?> remoteInterface) {
        this(new ObjectMapper(), handler, null);
    }

    public JsonRpcServer(Object handler) {
        this(new ObjectMapper(), handler, null);
    }

    public void handle(ResourceRequest request, ResourceResponse response) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing ResourceRequest " + request.getMethod());
        }
        response.setContentType(JSONRPC_RESPONSE_CONTENT_TYPE);
        InputStream input = null;
        OutputStream output = response.getPortletOutputStream();
        if (request.getMethod().equals("POST")) {
            input = request.getPortletInputStream();
        } else if (request.getMethod().equals("GET")) {
            input = this.createInputStream(request.getParameter("method"), request.getParameter("id"), request.getParameter("params"));
        } else {
            throw new IOException("Invalid request method, only POST and GET is supported");
        }
        this.handle(input, output);
    }

    public void handle(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing HttpServletRequest " + request.getMethod());
        }
        response.setContentType(JSONRPC_RESPONSE_CONTENT_TYPE);
        Object input = null;
        ServletOutputStream output = response.getOutputStream();
        if (request.getMethod().equals("POST")) {
            input = request.getInputStream();
        } else if (request.getMethod().equals("GET")) {
            input = this.createInputStream(request.getParameter("method"), request.getParameter("id"), request.getParameter("params"));
        } else {
            throw new IOException("Invalid request method, only POST and GET is supported");
        }
        this.handle((InputStream)input, (OutputStream)output);
    }

    public void handle(InputStream ips, OutputStream ops) throws IOException {
        this.handleNode(this.mapper.readTree((InputStream)new NoCloseInputStream(ips)), ops);
    }

    private InputStream createInputStream(String method, String id, String params) throws IOException {
        String decodedParams = URLDecoder.decode(new String(Base64.decode(params)), "UTF-8");
        String request = "{ " + "\"id\": \"" + id + "\", " + "\"method\": \"" + method + "\", " + "\"params\": " + decodedParams + " " + "}";
        return new ByteArrayInputStream(request.getBytes());
    }

    private Class<?> getHandlerClass() {
        return this.remoteInterface != null ? this.remoteInterface : this.handler.getClass();
    }

    private void handleNode(JsonNode node, OutputStream ops) throws IOException {
        if (node.isObject()) {
            this.handleObject((ObjectNode)ObjectNode.class.cast(node), ops);
        } else if (node.isArray()) {
            this.handleArray((ArrayNode)ArrayNode.class.cast(node), ops);
        } else {
            throw new IllegalArgumentException("Invalid JsonNode type: " + node.getClass().getName());
        }
    }

    private void handleArray(ArrayNode node, OutputStream ops) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Handing " + node.size() + " requests");
        }
        int i = 0;
        while (i < node.size()) {
            this.handleNode(node.get(i), ops);
            ++i;
        }
    }

    private void handleObject(ObjectNode node, OutputStream ops) throws IOException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Request: " + node.toString());
        }
        if (!this.backwardsComaptible && !node.has("jsonrpc") || !node.has("method")) {
            this.writeAndFlushValue(ops, this.createErrorResponse("jsonrpc", "null", -32600, "Invalid Request", null));
            return;
        }
        JsonNode jsonPrcNode = node.get("jsonrpc");
        JsonNode methodNode = node.get("method");
        JsonNode idNode = node.get("id");
        JsonNode paramsNode = node.get("params");
        String jsonRpc = jsonPrcNode != null && !jsonPrcNode.isNull() ? jsonPrcNode.asText() : "2.0";
        String methodName = methodNode != null && !methodNode.isNull() ? methodNode.asText() : null;
        String id = idNode != null && !idNode.isNull() ? idNode.asText() : null;
        HashSet<Method> methods = new HashSet<Method>();
        methods.addAll(ReflectionUtil.findMethods(this.getHandlerClass(), methodName));
        if (methods.isEmpty()) {
            this.writeAndFlushValue(ops, this.createErrorResponse(jsonRpc, id, -32601, "Method not found", null));
            return;
        }
        MethodAndArgs methodArgs = this.findBestMethodByParamsNode(methods, paramsNode);
        if (methodArgs == null) {
            this.writeAndFlushValue(ops, this.createErrorResponse(jsonRpc, id, -32602, "Invalid method parameters", null));
            return;
        }
        JsonNode result = null;
        Throwable thrown = null;
        try {
            result = this.invoke(methodArgs.method, methodArgs.arguments);
        }
        catch (Throwable e) {
            thrown = e;
        }
        if (id != null) {
            ErrorResolver.JsonError error = null;
            if (thrown != null) {
                Throwable e = thrown;
                if (InvocationTargetException.class.isInstance(e)) {
                    e = ((InvocationTargetException)InvocationTargetException.class.cast(e)).getTargetException();
                }
                if ((error = this.errorResolver != null ? this.errorResolver.resolveError(e, methodArgs.method, methodArgs.arguments) : DEFAULT_ERRROR_RESOLVER.resolveError(e, methodArgs.method, methodArgs.arguments)) == null) {
                    error = new ErrorResolver.JsonError(0, e.getMessage(), e.getClass().getName());
                }
            }
            ObjectNode response = null;
            if (error != null) {
                response = this.createErrorResponse(jsonRpc, id, error.getCode(), error.getMessage(), error.getData());
            } else {
                response = this.mapper.createObjectNode();
                response.put("jsonrpc", jsonRpc);
                response.put("id", id);
                response.put("result", result);
            }
            this.writeAndFlushValue(ops, response);
        }
        if (thrown != null) {
            if (LOGGER.isLoggable(Level.SEVERE)) {
                LOGGER.log(Level.SEVERE, "Error in JSON-RPC Service", thrown);
            }
            if (this.rethrowExceptions) {
                throw new RuntimeException(thrown);
            }
        }
    }

    private JsonNode invoke(Method m, List<JsonNode> params) throws IOException, IllegalAccessException, InvocationTargetException {
        if (LOGGER.isLoggable(Level.FINE)) {
            LOGGER.log(Level.FINE, "Invoking method: " + m.getName());
        }
        Object[] convertedParams = new Object[params.size()];
        Type[] parameterTypes = m.getGenericParameterTypes();
        int i = 0;
        while (i < parameterTypes.length) {
            JsonParser paramJsonParser = this.mapper.treeAsTokens((TreeNode)params.get(i));
            JavaType paramJavaType = TypeFactory.defaultInstance().constructType(parameterTypes[i]);
            convertedParams[i] = this.mapper.readValue(paramJsonParser, paramJavaType);
            ++i;
        }
        Object result = m.invoke(this.handler, convertedParams);
        return m.getGenericReturnType() != null ? this.mapper.valueToTree(result) : null;
    }

    private ObjectNode createErrorResponse(String jsonRpc, String id, int code, String message, Object data) {
        ObjectNode response = this.mapper.createObjectNode();
        ObjectNode error = this.mapper.createObjectNode();
        error.put("code", code);
        error.put("message", message);
        if (data != null) {
            error.put("data", this.mapper.valueToTree(data));
        }
        response.put("jsonrpc", jsonRpc);
        response.put("id", id);
        response.put("error", (JsonNode)error);
        return response;
    }

    private MethodAndArgs findBestMethodByParamsNode(Set<Method> methods, JsonNode paramsNode) {
        if (paramsNode == null || paramsNode.isNull()) {
            return this.findBestMethodUsingParamIndexes(methods, 0, null);
        }
        if (paramsNode.isArray()) {
            return this.findBestMethodUsingParamIndexes(methods, paramsNode.size(), (ArrayNode)ArrayNode.class.cast(paramsNode));
        }
        if (paramsNode.isObject()) {
            HashSet<String> fieldNames = new HashSet<String>();
            Iterator itr = paramsNode.fieldNames();
            while (itr.hasNext()) {
                fieldNames.add((String)itr.next());
            }
            return this.findBestMethodUsingParamNames(methods, fieldNames, (ObjectNode)ObjectNode.class.cast(paramsNode));
        }
        throw new IllegalArgumentException("Unknown params node type: " + paramsNode.toString());
    }

    private MethodAndArgs findBestMethodUsingParamIndexes(Set<Method> methods, int paramCount, ArrayNode paramNodes) {
        int numParams = paramNodes != null && !paramNodes.isNull() ? paramNodes.size() : 0;
        int bestParamNumDiff = Integer.MAX_VALUE;
        HashSet<Method> matchedMethods = new HashSet<Method>();
        for (Method method : methods) {
            Class<?>[] paramTypes = method.getParameterTypes();
            int paramNumDiff = paramTypes.length - paramCount;
            if (Math.abs(paramNumDiff) > Math.abs(bestParamNumDiff) || !this.allowExtraParams && paramNumDiff < 0 || !this.allowLessParams && paramNumDiff > 0) continue;
            if (Math.abs(paramNumDiff) < Math.abs(bestParamNumDiff)) {
                matchedMethods.clear();
            }
            matchedMethods.add(method);
            bestParamNumDiff = paramNumDiff;
        }
        if (matchedMethods.isEmpty()) {
            return null;
        }
        Method bestMethod = null;
        if (matchedMethods.size() == 1 || numParams == 0) {
            bestMethod = (Method)matchedMethods.iterator().next();
        } else {
            int mostMatches = -1;
            for (Method method : matchedMethods) {
                List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
                int numMatches = 0;
                int i = 0;
                while (i < parameterTypes.size() && i < numParams) {
                    if (this.isMatchingType(paramNodes.get(i), parameterTypes.get(i))) {
                        ++numMatches;
                    }
                    ++i;
                }
                if (numMatches <= mostMatches) continue;
                mostMatches = numMatches;
                bestMethod = method;
            }
        }
        MethodAndArgs ret = new MethodAndArgs();
        ret.method = bestMethod;
        int numParameters = bestMethod.getParameterTypes().length;
        int i = 0;
        while (i < numParameters) {
            if (i < numParams) {
                ret.arguments.add(paramNodes.get(i));
            } else {
                ret.arguments.add(NullNode.getInstance());
            }
            ++i;
        }
        return ret;
    }

    private MethodAndArgs findBestMethodUsingParamNames(Set<Method> methods, Set<String> paramNames, ObjectNode paramNodes) {
        int maxMatchingParams = -1;
        int maxMatchingParamTypes = -1;
        Method bestMethod = null;
        ArrayList<JsonRpcParam> bestAnnotations = null;
        for (Method method : methods) {
            List<List<JsonRpcParam>> methodAnnotations;
            List<Class<?>> parameterTypes = ReflectionUtil.getParameterTypes(method);
            if (!this.allowExtraParams && paramNames.size() > parameterTypes.size() || !this.allowLessParams && paramNames.size() < parameterTypes.size()) continue;
            ArrayList<JsonRpcParam> annotations = new ArrayList<JsonRpcParam>();
            List<List<JsonRpcParamName>> depMethodAnnotations = ReflectionUtil.getParameterAnnotations(method, JsonRpcParamName.class);
            if (!depMethodAnnotations.isEmpty()) {
                for (List<JsonRpcParamName> annots : depMethodAnnotations) {
                    if (annots.size() > 0) {
                        final JsonRpcParamName annotation = annots.get(0);
                        annotations.add((JsonRpcParam)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{JsonRpcParam.class}, new InvocationHandler(){

                            @Override
                            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                                if (method.getName().equals("value")) {
                                    return annotation.value();
                                }
                                throw new Exception("Unknown method: " + method.getName());
                            }
                        }));
                        continue;
                    }
                    annots.add(null);
                }
            }
            if (!(methodAnnotations = ReflectionUtil.getParameterAnnotations(method, JsonRpcParam.class)).isEmpty()) {
                for (List<JsonRpcParam> annots : methodAnnotations) {
                    if (annots.size() > 0) {
                        annotations.add(annots.get(0));
                        continue;
                    }
                    annots.add(null);
                }
            }
            int numMatchingParamTypes = 0;
            int numMatchingParams = 0;
            int i = 0;
            while (i < annotations.size()) {
                JsonRpcParam annotation = (JsonRpcParam)annotations.get(i);
                if (annotation != null) {
                    String paramName = annotation.value();
                    boolean hasParamName = paramNames.contains(paramName);
                    if (hasParamName && this.isMatchingType(paramNodes.get(paramName), parameterTypes.get(i))) {
                        ++numMatchingParamTypes;
                        ++numMatchingParams;
                    } else if (hasParamName) {
                        ++numMatchingParams;
                    }
                }
                ++i;
            }
            if (!this.allowExtraParams && numMatchingParams > parameterTypes.size() || !this.allowLessParams && numMatchingParams < parameterTypes.size() || numMatchingParams <= maxMatchingParams && (numMatchingParams != maxMatchingParams || numMatchingParamTypes <= maxMatchingParamTypes)) continue;
            bestMethod = method;
            maxMatchingParams = numMatchingParams;
            maxMatchingParamTypes = numMatchingParamTypes;
            bestAnnotations = annotations;
        }
        if (bestMethod == null) {
            return null;
        }
        MethodAndArgs ret = new MethodAndArgs();
        ret.method = bestMethod;
        int numParameters = bestMethod.getParameterTypes().length;
        int i = 0;
        while (i < numParameters) {
            JsonRpcParam param = (JsonRpcParam)bestAnnotations.get(i);
            if (param != null && paramNames.contains(param.value())) {
                ret.arguments.add(paramNodes.get(param.value()));
            } else {
                ret.arguments.add(NullNode.getInstance());
            }
            ++i;
        }
        return ret;
    }

    private boolean isMatchingType(JsonNode node, Class<?> type) {
        if (node.isNull()) {
            return true;
        }
        if (node.isNumber()) {
            return Number.class.isAssignableFrom(type);
        }
        if (node.isTextual()) {
            return String.class.isAssignableFrom(type);
        }
        if (node.isArray() && type.isArray()) {
            return node.size() > 0 ? this.isMatchingType(node.get(0), type.getComponentType()) : false;
        }
        if (node.isArray()) {
            return type.isArray() || Collection.class.isAssignableFrom(type);
        }
        if (node.isBinary()) {
            return byte[].class.isAssignableFrom(type) || Byte[].class.isAssignableFrom(type) || char[].class.isAssignableFrom(type) || Character[].class.isAssignableFrom(type);
        }
        if (node.isBoolean()) {
            return Boolean.TYPE.isAssignableFrom(type) || Boolean.class.isAssignableFrom(type);
        }
        if (node.isObject() || node.isPojo()) {
            return !type.isPrimitive() && !String.class.isAssignableFrom(type) && !Number.class.isAssignableFrom(type) && !Boolean.class.isAssignableFrom(type);
        }
        return false;
    }

    private void writeAndFlushValue(OutputStream ops, Object value) throws IOException {
        this.mapper.writeValue((OutputStream)new NoCloseOutputStream(ops), value);
        ops.flush();
    }

    public void setBackwardsComaptible(boolean backwardsComaptible) {
        this.backwardsComaptible = backwardsComaptible;
    }

    public void setRethrowExceptions(boolean rethrowExceptions) {
        this.rethrowExceptions = rethrowExceptions;
    }

    public void setAllowExtraParams(boolean allowExtraParams) {
        this.allowExtraParams = allowExtraParams;
    }

    public void setAllowLessParams(boolean allowLessParams) {
        this.allowLessParams = allowLessParams;
    }

    public void setErrorResolver(ErrorResolver errorResolver) {
        this.errorResolver = errorResolver;
    }

    private static class MethodAndArgs {
        private Method method = null;
        private List<JsonNode> arguments = new ArrayList<JsonNode>();

        private MethodAndArgs() {
        }
    }
}

