/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.dbcp.cpdsadapter;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import org.apache.commons.dbcp.DelegatingConnection;
import org.apache.commons.dbcp.DelegatingPreparedStatement;
import org.apache.commons.dbcp.cpdsadapter.PooledConnectionImpl;

class ConnectionImpl
extends DelegatingConnection {
    private final boolean accessToUnderlyingConnectionAllowed;
    private final PooledConnectionImpl pooledConnection;

    ConnectionImpl(PooledConnectionImpl pooledConnectionImpl, Connection connection, boolean bl) {
        super(connection);
        this.pooledConnection = pooledConnectionImpl;
        this.accessToUnderlyingConnectionAllowed = bl;
    }

    public void close() throws SQLException {
        if (!this._closed) {
            this._closed = true;
            this.passivate();
            this.pooledConnection.notifyListeners();
        }
    }

    public PreparedStatement prepareStatement(String string) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string, n, n2));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string, n, n2, n3));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int n) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string, n));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, int[] nArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string, nArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public PreparedStatement prepareStatement(String string, String[] stringArray) throws SQLException {
        this.checkOpen();
        try {
            return new DelegatingPreparedStatement((DelegatingConnection)this, this.pooledConnection.prepareStatement(string, stringArray));
        }
        catch (SQLException sQLException) {
            this.handleException(sQLException);
            return null;
        }
    }

    public boolean isAccessToUnderlyingConnectionAllowed() {
        return this.accessToUnderlyingConnectionAllowed;
    }

    public Connection getDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return this.getDelegateInternal();
        }
        return null;
    }

    public Connection getInnermostDelegate() {
        if (this.isAccessToUnderlyingConnectionAllowed()) {
            return super.getInnermostDelegateInternal();
        }
        return null;
    }
}

