/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.AbstractExternalData;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import eu.basysbio.cisd.dss.TimePointPropertyType;
import eu.basysbio.cisd.dss.Util;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public final class DataColumnHeader {
    static final String SEPARATOR = "::";
    static final TimePointPropertyType[] HEADER_ELEMENTS = new TimePointPropertyType[]{TimePointPropertyType.TECHNICAL_REPLICATE_CODE, TimePointPropertyType.CEL_LOC, TimePointPropertyType.TIME_SERIES_DATA_SET_TYPE, TimePointPropertyType.VALUE_TYPE, TimePointPropertyType.SCALE, TimePointPropertyType.BI_ID, TimePointPropertyType.CG};
    private static final int HEADER_PARTS = 12;
    private static final int TIME_POINT_INDEX = 3;
    private static final int TIME_POINT_TYPE_INDEX = 4;
    private final Pattern VALUE_TYPE_PATTERN = Pattern.compile("([a-zA-Z0-9]+)\\[([a-zA-Z0-9%]*)\\]");
    private final String experimentCode;
    private final String cultivationMethod;
    private final String biologicalReplicateCode;
    private final int timePoint;
    private final String timePointType;
    private final String technicalReplicateCode;
    private final String celLoc;
    private final String timeSeriesDataSetType;
    private final String valueTypeAndUnit;
    private final String scale;
    private final String biID;
    private final String controlledGene;
    private final String growthPhase;
    private final String genotype;
    private final String normalizedHeader;
    private final String header;

    DataColumnHeader(DataColumnHeader header, AbstractExternalData dataSet) {
        PropertyManager propertyManager = new PropertyManager(dataSet);
        this.experimentCode = header.getExperimentCode();
        this.cultivationMethod = header.getCultivationMethod();
        this.biologicalReplicateCode = header.getBiologicalReplicateCode();
        this.timePoint = header.getTimePoint();
        this.timePointType = header.getTimePointType();
        this.technicalReplicateCode = propertyManager.getProperty(TimePointPropertyType.TECHNICAL_REPLICATE_CODE);
        this.celLoc = propertyManager.getProperty(TimePointPropertyType.CEL_LOC);
        this.timeSeriesDataSetType = propertyManager.getProperty(TimePointPropertyType.TIME_SERIES_DATA_SET_TYPE);
        this.valueTypeAndUnit = propertyManager.getProperty(TimePointPropertyType.VALUE_TYPE);
        this.scale = propertyManager.getProperty(TimePointPropertyType.SCALE);
        this.biID = propertyManager.getProperty(TimePointPropertyType.BI_ID);
        this.controlledGene = propertyManager.getProperty(TimePointPropertyType.CG);
        this.growthPhase = null;
        this.genotype = null;
        this.header = this.normalizedHeader = this.createNormalizedHeader();
    }

    DataColumnHeader(String header) {
        this.header = header;
        String[] parts = header.split(SEPARATOR);
        if (parts.length < 12) {
            throw new IllegalArgumentException("At least 12 elements of the following header separated by '::' expected: " + header);
        }
        this.experimentCode = parts[0];
        this.cultivationMethod = parts[1];
        this.biologicalReplicateCode = parts[2];
        this.timePoint = this.parseTimePoint(parts[3], header);
        this.timePointType = parts[4];
        this.technicalReplicateCode = parts[5];
        this.celLoc = parts[6];
        this.timeSeriesDataSetType = parts[7];
        this.valueTypeAndUnit = parts[8];
        this.scale = parts[9];
        this.biID = parts[10];
        this.controlledGene = parts[11];
        this.growthPhase = parts.length > 12 ? parts[12] : null;
        this.genotype = parts.length > 13 ? parts[13] : null;
        this.normalizedHeader = this.createNormalizedHeader();
    }

    private String createNormalizedHeader() {
        StringBuilder builder = new StringBuilder();
        builder.append(this.experimentCode).append(SEPARATOR);
        builder.append(this.cultivationMethod).append(SEPARATOR);
        builder.append(this.biologicalReplicateCode).append(SEPARATOR);
        builder.append(this.timePoint).append(SEPARATOR);
        builder.append(this.timePointType);
        TimePointPropertyType[] timePointPropertyTypeArray = HEADER_ELEMENTS;
        int n = HEADER_ELEMENTS.length;
        int n2 = 0;
        while (n2 < n) {
            TimePointPropertyType type = timePointPropertyTypeArray[n2];
            builder.append(SEPARATOR).append(type.getElement(this));
            ++n2;
        }
        if (this.growthPhase != null) {
            builder.append(SEPARATOR).append(this.growthPhase).append(SEPARATOR).append(this.genotype);
        }
        return builder.toString();
    }

    private int parseTimePoint(String value, String originalHeader) {
        try {
            return Util.parseIntegerWithPlusSign(value);
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public String getExperimentCode() {
        return this.experimentCode;
    }

    public String getCultivationMethod() {
        return this.cultivationMethod;
    }

    public String getBiologicalReplicateCode() {
        return this.biologicalReplicateCode;
    }

    public int getTimePoint() {
        return this.timePoint;
    }

    public String getTimePointType() {
        return this.timePointType;
    }

    public String getTechnicalReplicateCode() {
        return this.technicalReplicateCode;
    }

    public String getCelLoc() {
        return this.celLoc;
    }

    public String getTimeSeriesDataSetType() {
        return this.timeSeriesDataSetType;
    }

    public String getValueTypeAndUnit() {
        return this.valueTypeAndUnit;
    }

    public String getValueType() {
        Matcher matcher = this.VALUE_TYPE_PATTERN.matcher(this.valueTypeAndUnit);
        return matcher.matches() ? matcher.group(1) : this.valueTypeAndUnit;
    }

    public String getUnit() {
        Matcher matcher = this.VALUE_TYPE_PATTERN.matcher(this.valueTypeAndUnit);
        return matcher.matches() ? matcher.group(2) : "?";
    }

    public String getScale() {
        return this.scale;
    }

    public String getBiID() {
        return this.biID;
    }

    public String getControlledGene() {
        return this.controlledGene;
    }

    public String getGrowthPhase() {
        return this.growthPhase;
    }

    public String getGenotype() {
        return this.genotype;
    }

    public boolean equals(Object obj) {
        return obj == this || obj instanceof DataColumnHeader && ((DataColumnHeader)obj).normalizedHeader.equals(this.normalizedHeader);
    }

    public int hashCode() {
        return this.toString().hashCode();
    }

    public String toString() {
        return this.header;
    }

    private static final class PropertyManager {
        private final Map<String, String> propertiesMap;
        private final String dataSetCode;

        PropertyManager(AbstractExternalData dataSet) {
            this.dataSetCode = dataSet.getCode();
            List properties = dataSet.getProperties();
            this.propertiesMap = new HashMap<String, String>();
            for (IEntityProperty property : properties) {
                this.propertiesMap.put(property.getPropertyType().getCode(), property.tryGetAsString());
            }
        }

        String getProperty(TimePointPropertyType timePointPropertyType) {
            String value = this.propertiesMap.get(timePointPropertyType.toString());
            if (value == null) {
                throw new UserFailureException("Data Set '" + this.dataSetCode + "' has no property " + (Object)((Object)timePointPropertyType) + ".");
            }
            return value;
        }
    }
}

