/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.properties.PropertyParametersUtil;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.etlserver.validation.IColumnHeaderValidator;
import ch.systemsx.cisd.etlserver.validation.Result;
import eu.basysbio.cisd.dss.Util;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;

public class DataColumnHeaderValidator
implements IColumnHeaderValidator {
    static final String ELEMENTS_KEY = "elements";
    static final String TYPE_KEY = "type";
    static final String TYPE_VOCABULARY = "vocabulary";
    static final String TERMS_KEY = "terms";
    static final String TYPE_INTEGER = "integer";
    static final String TYPE_STRING = "string";
    static final String PATTERN_KEY = "pattern";
    private final List<IElementValidator> elementValidators;

    public DataColumnHeaderValidator(Properties properties) {
        Map<String, IElementValidatorFactory> factories = this.createValidatorFactories();
        PropertyParametersUtil.SectionProperties[] sections = PropertyParametersUtil.extractSectionProperties((Properties)properties, (String)ELEMENTS_KEY, (boolean)false);
        this.elementValidators = new ArrayList<IElementValidator>(sections.length);
        PropertyParametersUtil.SectionProperties[] sectionPropertiesArray = sections;
        int n = sections.length;
        int n2 = 0;
        while (n2 < n) {
            PropertyParametersUtil.SectionProperties sectionProperties = sectionPropertiesArray[n2];
            String key = sectionProperties.getKey();
            Properties validatorProperties = sectionProperties.getProperties();
            String type = validatorProperties.getProperty(TYPE_KEY);
            if (type == null) {
                throw new ConfigurationFailureException("Missing property 'type' for element '" + key + "' of data column header validator.");
            }
            IElementValidatorFactory factory = factories.get(type);
            if (factory == null) {
                throw new ConfigurationFailureException("Unknown validator type '" + type + "' for element '" + key + "' of data column header validator.");
            }
            try {
                this.elementValidators.add(factory.createValidator(validatorProperties));
            }
            catch (ConfigurationFailureException e) {
                throw new ConfigurationFailureException("Error in validator definition for element '" + key + "' of data column header validator: " + e.getMessage());
            }
            ++n2;
        }
    }

    private Map<String, IElementValidatorFactory> createValidatorFactories() {
        HashMap<String, IElementValidatorFactory> map = new HashMap<String, IElementValidatorFactory>();
        this.register(map, new VocabularyValidatorFactory());
        this.register(map, new IntegerValidatorFactory());
        this.register(map, new StringValidatorFactory());
        return map;
    }

    private void register(Map<String, IElementValidatorFactory> map, IElementValidatorFactory factory) {
        map.put(factory.getType(), factory);
    }

    public Result validateHeader(String header) {
        String[] elements = header.split("::");
        if (elements.length < this.elementValidators.size()) {
            return Result.failure((String)(String.valueOf(this.elementValidators.size()) + " elements separated by '" + "::" + "' expected instead of only " + elements.length + "."));
        }
        int i = 0;
        int n = Math.min(elements.length, this.elementValidators.size());
        while (i < n) {
            String element = elements[i];
            String result = this.elementValidators.get(i).validate(element);
            if (result != null) {
                return Result.failure((String)("Element '" + element + "' is invalid: " + result));
            }
            ++i;
        }
        return Result.OK;
    }

    private static interface IElementValidator {
        public String validate(String var1);
    }

    private static interface IElementValidatorFactory {
        public String getType();

        public IElementValidator createValidator(Properties var1);
    }

    private static final class IntegerValidatorFactory
    implements IElementValidatorFactory {
        private IntegerValidatorFactory() {
        }

        @Override
        public String getType() {
            return DataColumnHeaderValidator.TYPE_INTEGER;
        }

        @Override
        public IElementValidator createValidator(Properties properties) {
            return new IElementValidator(){

                @Override
                public String validate(String element) {
                    try {
                        Util.parseIntegerWithPlusSign(element);
                        return null;
                    }
                    catch (NumberFormatException numberFormatException) {
                        return "It is not an integer number.";
                    }
                }
            };
        }
    }

    private static final class StringValidatorFactory
    implements IElementValidatorFactory {
        private StringValidatorFactory() {
        }

        @Override
        public String getType() {
            return DataColumnHeaderValidator.TYPE_STRING;
        }

        @Override
        public IElementValidator createValidator(Properties properties) {
            Pattern pattern;
            String regex = PropertyUtils.getMandatoryProperty((Properties)properties, (String)DataColumnHeaderValidator.PATTERN_KEY);
            try {
                pattern = Pattern.compile(regex);
            }
            catch (PatternSyntaxException patternSyntaxException) {
                throw new ConfigurationFailureException("Invalid regular expression: " + regex);
            }
            return new IElementValidator(){

                @Override
                public String validate(String element) {
                    if (pattern.matcher(element).matches()) {
                        return null;
                    }
                    return "It does not match the following regular expression: " + pattern;
                }
            };
        }
    }

    private static final class VocabularyValidatorFactory
    implements IElementValidatorFactory {
        private VocabularyValidatorFactory() {
        }

        @Override
        public String getType() {
            return DataColumnHeaderValidator.TYPE_VOCABULARY;
        }

        @Override
        public IElementValidator createValidator(Properties properties) {
            String termsSequence = PropertyUtils.getMandatoryProperty((Properties)properties, (String)DataColumnHeaderValidator.TERMS_KEY);
            final HashSet<String> set = new HashSet<String>();
            String[] terms = PropertyParametersUtil.parseItemisedProperty((String)termsSequence, (String)DataColumnHeaderValidator.TERMS_KEY);
            set.addAll(Arrays.asList(terms));
            return new IElementValidator(){

                @Override
                public String validate(String element) {
                    if (set.contains(element)) {
                        return null;
                    }
                    return "It is not a term from the following vocabulary: " + set;
                }
            };
        }
    }
}

