/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.rinn.restrictions.Private;
import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.filesystem.FileOperations;
import ch.systemsx.cisd.common.filesystem.IFileOperations;
import ch.systemsx.cisd.etlserver.AbstractPostRegistrationDataSetHandlerForFileBasedUndo;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import eu.basysbio.cisd.dss.DBUtils;
import eu.basysbio.cisd.dss.DataSetUploaderFactory;
import eu.basysbio.cisd.dss.IDataSetUploader;
import eu.basysbio.cisd.dss.IFileManager;
import eu.basysbio.cisd.dss.LcaMicDataSetUploader;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploader;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import java.io.File;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Pattern;
import javax.sql.DataSource;

class DataSetHandler
extends AbstractPostRegistrationDataSetHandlerForFileBasedUndo
implements ch.systemsx.cisd.etlserver.IDataSetUploader,
IFileManager {
    static final String TIME_SERIES = "TIME_SERIES";
    static final String LCA_MTP_TIME_SERIES = "LCA_MTP_TIME_SERIES";
    static final String LCA_MTP_PCAV_TIME_SERIES = "LCA_MTP_PCAV_TIME_SERIES";
    static final String LCA_MIC_TIME_SERIES = "LCA_MIC_TIME_SERIES";
    static final String LCA_MIC = "LCA_MIC";
    private final IEncapsulatedOpenBISService service;
    private final DataSource dataSource;
    private final TimeSeriesDataSetUploaderParameters parameters;
    final DataSetUploaderFactory factory;
    private IDataSetUploader uploader;

    DataSetHandler(Properties properties, IEncapsulatedOpenBISService service) {
        this(properties, DBUtils.getOrCreateDBContext(properties).getDataSource(), service);
    }

    DataSetHandler(Properties properties, DataSource dataSource, IEncapsulatedOpenBISService service) {
        super(FileOperations.getInstance());
        this.dataSource = dataSource;
        this.service = service;
        this.parameters = new TimeSeriesDataSetUploaderParameters(properties);
        Pattern patternForDefaultHandling = this.parameters.getPatternForDefaultHandling();
        this.factory = new DataSetUploaderFactory(TimeSeriesDataSetUploader.FACTORY, patternForDefaultHandling);
        this.factory.register(LCA_MIC, LcaMicDataSetUploader.FACTORY);
    }

    @Override
    public IFileOperations getFileOperations() {
        return super.getFileOperations();
    }

    @Override
    public void addFileForUndo(File file) {
        super.addFileForUndo(file);
    }

    public void commit() {
        if (this.uploader != null) {
            this.uploader.commit();
        }
    }

    public void rollback() {
        if (this.uploader != null) {
            this.uploader.rollback();
        }
    }

    public void upload(File dataSet, DataSetInformation dataSetInformation) throws EnvironmentFailureException {
        this.handle(dataSet, dataSetInformation, null);
    }

    public Status handle(File originalData, DataSetInformation dataSetInformation, Map<String, String> parameterBindings) {
        this.uploader = this.createUploader(dataSetInformation);
        this.uploader.upload(originalData, dataSetInformation);
        return Status.OK;
    }

    @Private
    IDataSetUploader createUploader(DataSetInformation dataSetInformation) {
        return this.factory.create(dataSetInformation, this.dataSource, this.service, this.parameters);
    }
}

