/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.exceptions.ConfigurationFailureException;
import ch.systemsx.cisd.common.exceptions.HighLevelException;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetTypeWithVocabularyTerms;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.PropertyTypeWithVocabulary;
import eu.basysbio.cisd.dss.TimePointPropertyType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

class DataSetPropertiesValidator {
    private final Map<String, Map<String, PropertyTypeWithVocabulary>> dataSetType2PropertyTypeMap = new HashMap<String, Map<String, PropertyTypeWithVocabulary>>();

    DataSetPropertiesValidator(Collection<String> translatedDataSetTypes, IEncapsulatedOpenBISService service) {
        StringBuilder builder = new StringBuilder();
        for (String dataSetTypeCode : translatedDataSetTypes) {
            DataSetTypeWithVocabularyTerms dataSetType = null;
            try {
                dataSetType = service.getDataSetType(dataSetTypeCode);
                this.add(dataSetType);
            }
            catch (HighLevelException ex) {
                builder.append(ex.getMessage()).append('\n');
            }
        }
        if (builder.length() > 0) {
            throw new ConfigurationFailureException(builder.toString());
        }
    }

    void assertValidFor(String dataSetType, TimePointPropertyType key, String value) {
        Set terms;
        Map<String, PropertyTypeWithVocabulary> map = this.dataSetType2PropertyTypeMap.get(dataSetType);
        if (map == null) {
            throw new IllegalArgumentException("Unknown data set type: " + dataSetType);
        }
        PropertyTypeWithVocabulary propertyType = map.get(key.toString());
        if (propertyType.isVocabulary() && !(terms = propertyType.getVocabularyTerms()).contains(value)) {
            throw new IllegalArgumentException("Value of property " + (Object)((Object)key) + " is not from the vocabulary " + terms + ": " + value);
        }
    }

    private void add(DataSetTypeWithVocabularyTerms dataSetType) {
        List assignedPropertyTypes = dataSetType.getPropertyTypes();
        HashMap<String, PropertyTypeWithVocabulary> map = new HashMap<String, PropertyTypeWithVocabulary>();
        for (PropertyTypeWithVocabulary dataSetTypePropertyType : assignedPropertyTypes) {
            map.put(dataSetTypePropertyType.getCode(), dataSetTypePropertyType);
        }
        TimePointPropertyType[] values = TimePointPropertyType.values();
        ArrayList<TimePointPropertyType> missingPropertyTypes = new ArrayList<TimePointPropertyType>();
        ArrayList<TimePointPropertyType> wrongDataTypePropertyTypes = new ArrayList<TimePointPropertyType>();
        TimePointPropertyType[] timePointPropertyTypeArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            TimePointPropertyType timePointPropertyType = timePointPropertyTypeArray[n2];
            PropertyTypeWithVocabulary propertyType = (PropertyTypeWithVocabulary)map.get(timePointPropertyType.toString());
            if (propertyType == null) {
                missingPropertyTypes.add(timePointPropertyType);
            } else if (timePointPropertyType.isVocabulary() != propertyType.isVocabulary()) {
                wrongDataTypePropertyTypes.add(timePointPropertyType);
            }
            ++n2;
        }
        StringBuilder errorMessage = this.createErrorMessage(missingPropertyTypes, wrongDataTypePropertyTypes);
        String dataSetTypeCode = dataSetType.getDataSetType().getCode();
        if (errorMessage.length() > 0) {
            throw new ConfigurationFailureException("Wrong property assignments for data set type " + dataSetTypeCode + ":\n" + errorMessage);
        }
        this.dataSetType2PropertyTypeMap.put(dataSetTypeCode, map);
    }

    private StringBuilder createErrorMessage(List<TimePointPropertyType> missingPropertyTypes, List<TimePointPropertyType> wrongDataTypePropertyTypes) {
        StringBuilder errorMessage = new StringBuilder();
        if (!missingPropertyTypes.isEmpty()) {
            this.gotoNewLine(errorMessage);
            errorMessage.append("The following property types are not assigned: ");
            errorMessage.append(missingPropertyTypes);
        }
        if (!wrongDataTypePropertyTypes.isEmpty()) {
            for (TimePointPropertyType timePointPropertyType : wrongDataTypePropertyTypes) {
                this.gotoNewLine(errorMessage);
                errorMessage.append("Property type ").append((Object)timePointPropertyType).append(" has ");
                if (timePointPropertyType.isVocabulary()) {
                    errorMessage.append("not ");
                }
                errorMessage.append("to be a vocabulary.");
            }
        }
        return errorMessage;
    }

    private void gotoNewLine(StringBuilder builder) {
        if (builder.length() != 0) {
            builder.append('\n');
        }
    }
}

