/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.etlserver.Parameters;
import ch.systemsx.cisd.etlserver.utils.Column;
import ch.systemsx.cisd.etlserver.utils.TabSeparatedValueTable;
import ch.systemsx.cisd.etlserver.validation.DataSetValidator;
import ch.systemsx.cisd.etlserver.validation.IDataSetValidator;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.DataSetType;
import ch.systemsx.cisd.openbis.generic.shared.dto.NewProperty;
import eu.basysbio.cisd.dss.AbstractDataSetUploader;
import eu.basysbio.cisd.dss.HeaderUtils;
import eu.basysbio.cisd.dss.IDataSetUploader;
import eu.basysbio.cisd.dss.IDataSetUploaderFactory;
import eu.basysbio.cisd.dss.IDatabaseFeeder;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import eu.basysbio.cisd.dss.TimeSeriesPropertyType;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import java.io.StringReader;
import java.util.Iterator;
import java.util.List;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;

class LcaMicDataSetUploader
extends AbstractDataSetUploader {
    static final String LCA_MIC_TIME_SERIES = "LCA_MIC_TIME_SERIES";
    static final IDataSetUploaderFactory FACTORY = new IDataSetUploaderFactory(){

        @Override
        public IDataSetUploader create(DataSetInformation dataSetInformation, DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
            return new LcaMicDataSetUploader(dataSource, service, parameters);
        }

        @Override
        public IDataSetUploader create(DataSetInformation dataSetInformation, ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
            return new LcaMicDataSetUploader(dao, service, parameters);
        }
    };
    private final IDataSetValidator dataSetValidator;

    LcaMicDataSetUploader(DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        super(dataSource, service, parameters);
        this.dataSetValidator = new DataSetValidator(Parameters.createParametersForApiUse().getProperties());
    }

    LcaMicDataSetUploader(ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        super(dao, service, parameters);
        this.dataSetValidator = new DataSetValidator(Parameters.createParametersForApiUse().getProperties());
    }

    LcaMicDataSetUploader(ITimeSeriesDAO dao, IDatabaseFeeder databaseFeeder, IEncapsulatedOpenBISService service, IDataSetValidator dataSetValidator, TimeSeriesDataSetUploaderParameters parameters) {
        super(dao, databaseFeeder, service, parameters);
        this.dataSetValidator = dataSetValidator;
    }

    @Override
    protected void handleTSVFile(File tsvFile, DataSetInformation dataSetInformation) {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(tsvFile);
                String fileName = tsvFile.toString();
                TabSeparatedValueTable table = new TabSeparatedValueTable((Reader)reader, fileName, this.parameters.isIgnoreEmptyLines(), true, true);
                List columns = table.getColumns();
                List timeValues = ((Column)columns.get(0)).getValues();
                List properties = dataSetInformation.getDataSetProperties();
                for (NewProperty property : properties) {
                    if (!property.getPropertyCode().equals(TimeSeriesPropertyType.TIME_POINT_LIST.toString())) continue;
                    property.setValue(HeaderUtils.join(timeValues));
                }
                String lastBBAID = null;
                String lastControlledGene = null;
                this.databaseFeeder.resetValueGroupIDGenerator();
                int i = 1;
                while (i < columns.size()) {
                    Column column = (Column)columns.get(i);
                    String header = column.getHeader();
                    Object[] items = header.split("::");
                    if (items.length < 11) {
                        throw new UserFailureException("Invalid header: Missing BBA ID: " + header);
                    }
                    String bbaIDOfColumn = items[10];
                    if (!bbaIDOfColumn.startsWith("BBA")) {
                        throw new UserFailureException("Invalid header: BBA ID doesn't start with 'BBA': " + header);
                    }
                    if (lastBBAID != null && !bbaIDOfColumn.equals(lastBBAID)) {
                        throw new UserFailureException("Invalid headers: All BBA IDs should be the same. The folowing two different BBA IDs found: " + lastBBAID + " " + bbaIDOfColumn);
                    }
                    lastBBAID = bbaIDOfColumn;
                    items[10] = "NB";
                    if (items.length > 11 && !"NC".equals(items[11])) {
                        String controlledGeneOfColumn = items[11];
                        if (lastControlledGene != null && !controlledGeneOfColumn.equals(lastControlledGene)) {
                            throw new UserFailureException("Invalid headers: All ControlledGenes should be the same. The folowing two ControlledGenes found: " + lastControlledGene + " " + controlledGeneOfColumn);
                        }
                        lastControlledGene = controlledGeneOfColumn;
                        items[11] = "NC";
                    }
                    StringBuilder builder = new StringBuilder("BBA ID");
                    if (lastControlledGene != null) {
                        builder.append("\tControlledGene");
                    }
                    Iterator iterator = timeValues.iterator();
                    while (iterator.hasNext()) {
                        String value;
                        items[3] = value = (String)iterator.next();
                        builder.append("\t").append(StringUtils.join((Object[])items, (String)"::"));
                    }
                    builder.append("\n").append(bbaIDOfColumn);
                    if (lastControlledGene != null) {
                        builder.append("\t").append(lastControlledGene);
                    }
                    List values = column.getValues();
                    for (String value : values) {
                        builder.append("\t").append(value);
                    }
                    builder.append("\n");
                    String timeSeriesDataSet = builder.toString();
                    DataSetType dataSetType = new DataSetType(LCA_MIC_TIME_SERIES);
                    String timeSeriesDataSetName = LCA_MIC_TIME_SERIES + i;
                    this.dataSetValidator.assertValidDataSet(dataSetType, (Reader)new StringReader(timeSeriesDataSet), timeSeriesDataSetName);
                    this.databaseFeeder.feedDatabase(dataSetInformation, new StringReader(timeSeriesDataSet), timeSeriesDataSetName, bbaIDOfColumn);
                    ++i;
                }
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

