/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.mail.IMailClient;
import ch.systemsx.cisd.etlserver.AbstractDelegatingStorageProcessorTransaction;
import ch.systemsx.cisd.etlserver.AbstractStrorageProcessorWithUploader;
import ch.systemsx.cisd.etlserver.DelegatingStorageProcessorWithDropbox;
import ch.systemsx.cisd.etlserver.IDataSetUploader;
import ch.systemsx.cisd.etlserver.IStorageProcessorTransactional;
import ch.systemsx.cisd.etlserver.ITypeExtractor;
import ch.systemsx.cisd.etlserver.NullStorageProcessorTransaction;
import ch.systemsx.cisd.openbis.dss.generic.shared.IPostRegistrationDatasetHandler;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.dto.StorageFormat;
import eu.basysbio.cisd.dss.DataSetHandler;
import java.io.File;
import java.util.Properties;

public class StorageProcessor
extends DelegatingStorageProcessorWithDropbox {
    public StorageProcessor(Properties properties) {
        super(properties);
    }

    public IPostRegistrationDatasetHandler createPostRegistrationDataSetHandler() {
        return new DataSetHandler(this.properties, ServiceProvider.getOpenBISService());
    }

    public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
        DelegatingStorageProcessorWithDropbox.StorageProcessorWithDropboxTransaction superTransaction = (DelegatingStorageProcessorWithDropbox.StorageProcessorWithDropboxTransaction)super.createTransaction(parameters);
        StorageProcessorWithUploader storageProcessorWithUploader = new StorageProcessorWithUploader(new DummyStorageProcessor(), (IDataSetUploader)superTransaction.getPostReigstrationHandler());
        IStorageProcessorTransactional.IStorageProcessorTransaction uploaderTransaction = storageProcessorWithUploader.createTransaction(parameters);
        return new StorageProcessorTransaction(parameters, (IStorageProcessorTransactional.IStorageProcessorTransaction)superTransaction, uploaderTransaction);
    }

    private final class DummyStorageProcessor
    implements IStorageProcessorTransactional {
        private DummyStorageProcessor() {
        }

        public File getStoreRootDirectory() {
            return null;
        }

        public void setStoreRootDirectory(File storeRootDirectory) {
        }

        public IStorageProcessorTransactional.IStorageProcessorTransaction createTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters) {
            return new NullStorageProcessorTransaction();
        }

        public StorageFormat getStorageFormat() {
            return null;
        }

        public IStorageProcessorTransactional.UnstoreDataAction getDefaultUnstoreDataAction(Throwable exception) {
            return null;
        }
    }

    static class StorageProcessorTransaction
    extends AbstractDelegatingStorageProcessorTransaction {
        private static final long serialVersionUID = 1L;
        private final IStorageProcessorTransactional.IStorageProcessorTransaction uploaderTransaction;

        StorageProcessorTransaction(IStorageProcessorTransactional.StorageProcessorTransactionParameters parameters, IStorageProcessorTransactional.IStorageProcessorTransaction nestedTransaction, IStorageProcessorTransactional.IStorageProcessorTransaction uploaderTransaction) {
            super(parameters, nestedTransaction);
            this.uploaderTransaction = uploaderTransaction;
        }

        protected File executeStoreData(ITypeExtractor typeExtractor, IMailClient mailClient) {
            this.nestedTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            this.uploaderTransaction.storeData(typeExtractor, mailClient, this.incomingDataSetDirectory);
            return this.nestedTransaction.getStoredDataDirectory();
        }

        protected IStorageProcessorTransactional.UnstoreDataAction executeRollback(Throwable ex) {
            this.nestedTransaction.rollback(ex);
            return this.uploaderTransaction.rollback(ex);
        }

        protected void executeCommit() {
            this.uploaderTransaction.commit();
            this.nestedTransaction.commit();
        }
    }

    private static final class StorageProcessorWithUploader
    extends AbstractStrorageProcessorWithUploader {
        public StorageProcessorWithUploader(IStorageProcessorTransactional processor, IDataSetUploader uploader) {
            super(processor, uploader);
        }

        protected void logDataSetFileError(File incomingDataSetDirectory, Throwable exception) {
        }
    }
}

