/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.base.exceptions.CheckedExceptionTunnel;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import eu.basysbio.cisd.dss.AbstractDataSetUploader;
import eu.basysbio.cisd.dss.IDataSetUploader;
import eu.basysbio.cisd.dss.IDataSetUploaderFactory;
import eu.basysbio.cisd.dss.ITimeSeriesDAO;
import eu.basysbio.cisd.dss.TimeSeriesDataSetUploaderParameters;
import java.io.File;
import java.io.FileReader;
import java.io.Reader;
import javax.sql.DataSource;
import org.apache.commons.io.IOUtils;

class TimeSeriesDataSetUploader
extends AbstractDataSetUploader {
    static final IDataSetUploaderFactory FACTORY = new IDataSetUploaderFactory(){

        @Override
        public IDataSetUploader create(DataSetInformation dataSetInformation, DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
            return new TimeSeriesDataSetUploader(dataSource, service, parameters);
        }

        @Override
        public IDataSetUploader create(DataSetInformation dataSetInformation, ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
            return new TimeSeriesDataSetUploader(dao, service, parameters);
        }
    };

    TimeSeriesDataSetUploader(DataSource dataSource, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        super(dataSource, service, parameters);
    }

    TimeSeriesDataSetUploader(ITimeSeriesDAO dao, IEncapsulatedOpenBISService service, TimeSeriesDataSetUploaderParameters parameters) {
        super(dao, service, parameters);
    }

    @Override
    protected void handleTSVFile(File tsvFile, DataSetInformation dataSetInformation) {
        FileReader reader = null;
        try {
            try {
                reader = new FileReader(tsvFile);
                String fileName = tsvFile.toString();
                this.databaseFeeder.resetValueGroupIDGenerator();
                this.databaseFeeder.feedDatabase(dataSetInformation, reader, fileName);
            }
            catch (RuntimeException ex) {
                throw ex;
            }
            catch (Exception ex) {
                throw CheckedExceptionTunnel.wrapIfNecessary((Exception)ex);
            }
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(reader);
            throw throwable;
        }
        IOUtils.closeQuietly((Reader)reader);
    }
}

