/*
 * Decompiled with CFR 0.152.
 */
package eu.basysbio.cisd.dss;

import ch.systemsx.cisd.common.reflection.ModifiedShortPrefixToStringStyle;
import eu.basysbio.cisd.dss.DataColumnHeader;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;

public class ValueGroupDescriptor {
    private final String experimentType;
    private final String cultivationMethod;
    private final String biologicalReplicates;
    private final int timePoint;
    private final String timePointType;
    private final String technicalReplicates;
    private final String cellLocation;
    private final String dataSetType;
    private final String biId;
    private final String controlledGene;
    private final String growthPhase;
    private final String genotype;

    public ValueGroupDescriptor(DataColumnHeader dataColumnHeader) {
        this.experimentType = dataColumnHeader.getExperimentCode();
        this.cultivationMethod = dataColumnHeader.getCultivationMethod();
        this.biologicalReplicates = dataColumnHeader.getBiologicalReplicateCode();
        this.timePoint = dataColumnHeader.getTimePoint();
        this.timePointType = dataColumnHeader.getTimePointType();
        this.technicalReplicates = dataColumnHeader.getTechnicalReplicateCode();
        this.cellLocation = dataColumnHeader.getCelLoc();
        this.dataSetType = dataColumnHeader.getTimeSeriesDataSetType();
        this.biId = dataColumnHeader.getBiID();
        this.controlledGene = dataColumnHeader.getControlledGene();
        this.growthPhase = dataColumnHeader.getGrowthPhase();
        this.genotype = dataColumnHeader.getGenotype();
    }

    public String getExperimentType() {
        return this.experimentType;
    }

    public String getCultivationMethod() {
        return this.cultivationMethod;
    }

    public String getBiologicalReplicates() {
        return this.biologicalReplicates;
    }

    public int getTimePoint() {
        return this.timePoint;
    }

    public String getTimePointType() {
        return this.timePointType;
    }

    public String getTechnicalReplicates() {
        return this.technicalReplicates;
    }

    public String getCellLocation() {
        return this.cellLocation;
    }

    public String getDataSetType() {
        return this.dataSetType;
    }

    public String getBiId() {
        return this.biId;
    }

    public String getControlledGene() {
        return this.controlledGene;
    }

    public final String getGrowthPhase() {
        return this.growthPhase;
    }

    public final String getGenotype() {
        return this.genotype;
    }

    public int hashCode() {
        int result = 1;
        result = 31 * result + (this.biId == null ? 0 : this.biId.hashCode());
        result = 31 * result + (this.biologicalReplicates == null ? 0 : this.biologicalReplicates.hashCode());
        result = 31 * result + (this.cellLocation == null ? 0 : this.cellLocation.hashCode());
        result = 31 * result + (this.controlledGene == null ? 0 : this.controlledGene.hashCode());
        result = 31 * result + (this.cultivationMethod == null ? 0 : this.cultivationMethod.hashCode());
        result = 31 * result + (this.dataSetType == null ? 0 : this.dataSetType.hashCode());
        result = 31 * result + (this.experimentType == null ? 0 : this.experimentType.hashCode());
        result = 31 * result + (this.genotype == null ? 0 : this.genotype.hashCode());
        result = 31 * result + (this.growthPhase == null ? 0 : this.growthPhase.hashCode());
        result = 31 * result + (this.technicalReplicates == null ? 0 : this.technicalReplicates.hashCode());
        result = 31 * result + this.timePoint;
        result = 31 * result + (this.timePointType == null ? 0 : this.timePointType.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ValueGroupDescriptor other = (ValueGroupDescriptor)obj;
        return this.equals(this.biId, other.biId) && this.equals(this.biologicalReplicates, other.biologicalReplicates) && this.equals(this.cellLocation, other.cellLocation) && this.equals(this.controlledGene, other.controlledGene) && this.equals(this.cultivationMethod, other.cultivationMethod) && this.equals(this.dataSetType, other.dataSetType) && this.equals(this.experimentType, other.experimentType) && this.equals(this.genotype, other.genotype) && this.equals(this.growthPhase, other.growthPhase) && this.equals(this.technicalReplicates, other.technicalReplicates) && this.timePoint == other.timePoint && this.equals(this.timePointType, other.timePointType);
    }

    private boolean equals(Object obj1, Object obj2) {
        return obj1 == null ? obj1 == obj2 : obj1.equals(obj2);
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ModifiedShortPrefixToStringStyle.MODIFIED_SHORT_PREFIX_STYLE);
    }
}

