/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.cina.dss.bundle.registrators;

import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleDataSetHelper;
import ch.systemsx.cisd.cina.dss.bundle.registrators.BundleRegistrationState;
import ch.systemsx.cisd.cina.dss.bundle.registrators.CollectionRegistrator;
import ch.systemsx.cisd.cina.shared.metadata.BundleMetadataExtractor;
import ch.systemsx.cisd.cina.shared.metadata.CollectionMetadataExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.NewSample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.SampleType;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import java.io.File;
import java.util.List;

public class GridPreparationRegistrator
extends BundleDataSetHelper {
    private final BundleMetadataExtractor bundleMetadataExtractor;
    private SampleIdentifier gridPrepSampleId;
    private Sample gridPrepSample;

    public GridPreparationRegistrator(BundleRegistrationState globalState, File dataSet) {
        super(globalState, dataSet);
        this.bundleMetadataExtractor = new BundleMetadataExtractor(dataSet);
        this.bundleMetadataExtractor.prepare();
    }

    public void register() {
        this.retrieveOrCreateGridPrepSample();
        DataSetInformation metadataDataSetInfo = this.createDataSetInformation();
        File metadataFile = new File(new File(this.dataSet, "Annotations"), "CollectionMetadata.xml");
        List<DataSetInformation> registeredBundleMetadataDataSets = this.registerDataSet(metadataFile, metadataDataSetInfo);
        DataSetInformation registeredBundleMetadataDataSet = registeredBundleMetadataDataSets.get(0);
        for (CollectionMetadataExtractor replicaMetadataExtractor : this.bundleMetadataExtractor.getReplicaMetadataExtractors()) {
            List<DataSetInformation> childRegisteredDataSets = new CollectionRegistrator(this.globalState, replicaMetadataExtractor, this.gridPrepSample, this.gridPrepSampleId, registeredBundleMetadataDataSet, this.dataSet).register();
            this.getDataSetInformation().addAll(childRegisteredDataSets);
        }
    }

    private void retrieveOrCreateGridPrepSample() {
        DataSetInformation dataSetInfo = this.getDelegator().getCallerDataSetInformation();
        ExperimentIdentifier expId = dataSetInfo.getExperimentIdentifier();
        String sampleCode = this.bundleMetadataExtractor.tryGridPrepSampleCode();
        assert (expId != null);
        assert (sampleCode != null);
        assert (sampleCode.length() > 0);
        SpaceIdentifier spaceId = new SpaceIdentifier(expId.getDatabaseInstanceCode(), expId.getSpaceCode());
        this.gridPrepSampleId = new SampleIdentifier(spaceId, sampleCode);
        this.gridPrepSample = this.getOpenbisService().tryGetSampleWithExperiment(this.gridPrepSampleId);
        if (this.gridPrepSample == null) {
            NewSample newSample = NewSample.createWithParent((String)this.gridPrepSampleId.toString(), (SampleType)this.globalState.getGridPrepSampleType(), null, null);
            newSample.setExperimentIdentifier(expId.toString());
            String userId = this.getSessionContext().getUserName();
            this.getOpenbisService().registerSample(newSample, userId);
            this.gridPrepSample = this.getOpenbisService().tryGetSampleWithExperiment(this.gridPrepSampleId);
        }
        assert (this.gridPrepSample != null);
    }

    private DataSetInformation createDataSetInformation() {
        DataSetInformation metadataDataSetInfo = new DataSetInformation();
        metadataDataSetInfo.setSampleCode(this.gridPrepSampleId.getSampleCode());
        metadataDataSetInfo.setSpaceCode(this.gridPrepSampleId.getSpaceLevel().getSpaceCode());
        metadataDataSetInfo.setInstanceCode(this.gridPrepSampleId.getSpaceLevel().getDatabaseInstanceCode());
        metadataDataSetInfo.setDataSetType(this.globalState.getMetadataDataSetType().getDataSetType());
        return metadataDataSetInfo;
    }
}

