/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.openbis.dss.etl.PlateStorageProcessor;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IEntityProperty;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.plugin.screening.shared.api.v1.dto.Geometry;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimension;
import ch.systemsx.cisd.openbis.plugin.screening.shared.dto.PlateDimensionParser;

public class HCSContainerDatasetInfo {
    private String experimentPermId;
    private String containerSamplePermId;
    private int containerSampleRows;
    private int containerSampleColumns;
    private String datasetPermId;

    public String getExperimentPermId() {
        return this.experimentPermId;
    }

    public void setExperimentPermId(String experimentPermId) {
        this.experimentPermId = experimentPermId;
    }

    public String getContainerSamplePermId() {
        return this.containerSamplePermId;
    }

    public void setContainerSamplePermId(String containerSamplePermId) {
        this.containerSamplePermId = containerSamplePermId;
    }

    public String getDatasetPermId() {
        return this.datasetPermId;
    }

    public void setDatasetPermId(String datasetPermId) {
        this.datasetPermId = datasetPermId;
    }

    public int getContainerRows() {
        return this.containerSampleRows;
    }

    public void setContainerRows(int containerRows) {
        this.containerSampleRows = containerRows;
    }

    public int getContainerColumns() {
        return this.containerSampleColumns;
    }

    public void setContainerColumns(int containerColumns) {
        this.containerSampleColumns = containerColumns;
    }

    public Geometry getContainerGeometry() {
        return Geometry.createFromRowColDimensions(this.containerSampleRows, this.containerSampleColumns);
    }

    public static HCSContainerDatasetInfo createScreeningDatasetInfoWithSample(DataSetInformation dataSetInformation, Sample sampleOrNull) {
        return HCSContainerDatasetInfo.createScreeningDatasetInfoWithSample(PlateStorageProcessor.DatasetOwnerInformation.create(dataSetInformation), sampleOrNull);
    }

    public static HCSContainerDatasetInfo createScreeningDatasetInfo(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation) {
        Sample sample = dataSetInformation.tryGetSample();
        assert (sample != null) : "no sample connected to a dataset";
        PlateDimension plateGeometry = HCSContainerDatasetInfo.getPlateGeometry(dataSetInformation);
        HCSContainerDatasetInfo info = HCSContainerDatasetInfo.createBasicScreeningDataSetInfo(dataSetInformation, sample, plateGeometry);
        return info;
    }

    public static HCSContainerDatasetInfo createScreeningDatasetInfoWithSample(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation, Sample containingSample) {
        Sample sample = containingSample;
        assert (sample != null) : "no sample connected to a dataset";
        PlateDimension plateGeometry = HCSContainerDatasetInfo.getPlateGeometry(sample);
        HCSContainerDatasetInfo info = HCSContainerDatasetInfo.createBasicScreeningDataSetInfo(dataSetInformation, sample, plateGeometry);
        return info;
    }

    private static HCSContainerDatasetInfo createBasicScreeningDataSetInfo(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation, Sample sample, PlateDimension plateGeometry) {
        Experiment experiment = dataSetInformation.tryGetExperiment();
        HCSContainerDatasetInfo info = new HCSContainerDatasetInfo();
        info.setExperimentPermId(experiment.getPermId());
        info.setContainerSamplePermId(sample.getPermId());
        info.setDatasetPermId(dataSetInformation.getDataSetCode());
        info.setContainerRows(plateGeometry.getRowsNum());
        info.setContainerColumns(plateGeometry.getColsNum());
        return info;
    }

    private static PlateDimension getPlateGeometry(Sample sample) {
        IEntityProperty[] sampleProperties = sample.getProperties().toArray(new IEntityProperty[0]);
        PlateDimension plateDimension = PlateDimensionParser.tryToGetPlateDimension(sampleProperties);
        if (plateDimension == null) {
            throw new EnvironmentFailureException("Missing plate geometry for the plate registered for sample identifier '" + sample.getIdentifier() + "'.");
        }
        return plateDimension;
    }

    public static PlateDimension getPlateGeometry(PlateStorageProcessor.DatasetOwnerInformation dataSetInformation) {
        PlateDimension plateDimension;
        IEntityProperty[] sampleProperties = dataSetInformation.getSampleProperties();
        if ((sampleProperties == null || sampleProperties.length == 0) && dataSetInformation.tryGetSample() != null) {
            sampleProperties = dataSetInformation.tryGetSample().getProperties().toArray(new IEntityProperty[0]);
        }
        if ((plateDimension = PlateDimensionParser.tryToGetPlateDimension(sampleProperties)) == null) {
            throw new EnvironmentFailureException("Missing plate geometry for the plate registered for sample identifier '" + dataSetInformation.getSampleIdentifier() + "'.");
        }
        return plateDimension;
    }
}

