/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dto.api.transformations;

import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import ch.systemsx.cisd.openbis.generic.shared.basic.CodeNormalizer;
import java.io.Serializable;

public class ImageTransformation
implements Serializable {
    private static final long serialVersionUID = 1L;
    private String code;
    private String label;
    private String description;
    private boolean isDefault;
    private final IImageTransformerFactory imageTransformerFactory;
    private final boolean isEditable;

    public ImageTransformation(String code, String label, String description, IImageTransformerFactory imageTransformerFactory) {
        assert (code != null) : "code is null";
        assert (label != null) : " label is null";
        assert (imageTransformerFactory != null) : "imageTransformerFactory is null";
        this.code = CodeNormalizer.normalize((String)code);
        this.label = label;
        this.description = description;
        this.isDefault = false;
        this.imageTransformerFactory = imageTransformerFactory;
        this.isEditable = false;
    }

    public String getCode() {
        return this.code;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.description;
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public IImageTransformerFactory getImageTransformerFactory() {
        return this.imageTransformerFactory;
    }

    public boolean isEditable() {
        return this.isEditable;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDefault(boolean isDefault) {
        this.isDefault = isDefault;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("ImageTransformation [code=" + this.code + ", label=" + this.label);
        if (this.description != null) {
            sb.append(", description=" + this.description);
        }
        sb.append(", isDefault=" + this.isDefault + "]");
        return sb.toString();
    }
}

