/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.dss.etl.dynamix;

import ch.systemsx.cisd.base.annotation.JsonObject;
import ch.systemsx.cisd.base.image.IImageTransformer;
import ch.systemsx.cisd.base.image.IImageTransformerFactory;
import java.awt.image.BufferedImage;

@JsonObject(value="IntensityRangeReductionFactory")
public class IntensityRangeReductionFactory
implements IImageTransformerFactory {
    private static final long serialVersionUID = 1L;
    private final int[] precomputedColors;

    public IntensityRangeReductionFactory(int min, int max) {
        if (min < 0 || max > 255) {
            throw new IllegalStateException(String.format("Invalid range [%d, %d]. Min should be >= 0 and max should be <= 255!", min, max));
        }
        double rescalingFactor = (double)(max - min) / 255.0;
        this.precomputedColors = new int[256];
        int i = 0;
        while (i < this.precomputedColors.length) {
            this.precomputedColors[i] = (int)(rescalingFactor * (double)i + (double)min);
            ++i;
        }
    }

    public IImageTransformer createTransformer() {
        return new IImageTransformer(){

            public BufferedImage transform(BufferedImage image) {
                return IntensityRangeReductionFactory.this.reduceIntensityRange(image);
            }
        };
    }

    private BufferedImage reduceIntensityRange(BufferedImage image) {
        if (image.getColorModel().getComponentSize(0) > 8) {
            return image;
        }
        BufferedImage newImage = new BufferedImage(image.getWidth(), image.getHeight(), 10);
        int x = 0;
        while (x < image.getWidth()) {
            int y = 0;
            while (y < image.getHeight()) {
                int color = image.getRaster().getSample(x, y, 0);
                int rescaledColor = this.precomputedColors[color];
                newImage.getRaster().setSample(x, y, 0, rescaledColor);
                ++y;
            }
            ++x;
        }
        return newImage;
    }
}

