/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.openbis.plugin.screening.shared.imaging;

import ch.systemsx.cisd.common.logging.LogCategory;
import ch.systemsx.cisd.common.logging.LogFactory;
import ch.systemsx.cisd.openbis.plugin.screening.shared.basic.dto.ImageResolution;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.IImageResolutionLoader;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.IImagingReadonlyQueryDAO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageDatasetDTO;
import ch.systemsx.cisd.openbis.plugin.screening.shared.imaging.dataaccess.ImgImageZoomLevelDTO;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;

public class HCSImageResolutionLoader
implements IImageResolutionLoader {
    protected static final Logger operationLog = LogFactory.getLogger((LogCategory)LogCategory.OPERATION, HCSImageResolutionLoader.class);
    protected final IImagingReadonlyQueryDAO query;
    protected final ImgImageDatasetDTO dataset;

    public static HCSImageResolutionLoader tryCreate(IImagingReadonlyQueryDAO query, String datasetPermId) {
        ImgImageDatasetDTO dataset = query.tryGetImageDatasetByPermId(datasetPermId);
        if (dataset == null) {
            operationLog.warn((Object)String.format("No dataset with code '%s' found in the imaging database.", datasetPermId));
            return null;
        }
        return new HCSImageResolutionLoader(query, dataset);
    }

    private HCSImageResolutionLoader(IImagingReadonlyQueryDAO query, ImgImageDatasetDTO dataset) {
        this.query = query;
        this.dataset = dataset;
    }

    @Override
    public List<ImageResolution> getImageResolutions() {
        List<ImgImageZoomLevelDTO> zoomLevels = this.query.listImageZoomLevelsWithNoTransformations(this.dataset.getId());
        if (zoomLevels == null || zoomLevels.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<ImageResolution> resolutions = new ArrayList<ImageResolution>(zoomLevels.size());
        for (ImgImageZoomLevelDTO zoomLevel : zoomLevels) {
            ImageResolution resolution = new ImageResolution(zoomLevel.getWidth(), zoomLevel.getHeight(), zoomLevel.getIsOriginal());
            resolutions.add(resolution);
        }
        return resolutions;
    }
}

