/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.yeastx.eicml.ChromatogramDTO;
import ch.systemsx.cisd.yeastx.eicml.EICMLFilenameFilter;
import ch.systemsx.cisd.yeastx.eicml.EICMLParser;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.PrintStream;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang.StringUtils;
import org.xml.sax.SAXException;

public class EICML2TabConverter {
    public static void main(String[] args) throws IOException, ParserConfigurationException, SAXException {
        final String dir = args[0];
        String[] stringArray = new File(dir).list(new EICMLFilenameFilter());
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String f = stringArray[n2];
            final String[] msRunName = new String[1];
            new EICMLParser(String.valueOf(dir) + "/" + f, new EICMLParser.IMSRunObserver(){

                @Override
                public void observe(EICMSRunDTO run) {
                    String runName = run.getRawDataFileName();
                    if (runName.endsWith(".RAW")) {
                        runName = runName.substring(0, runName.length() - 4);
                    }
                    String runDir = String.valueOf(dir) + "/" + runName;
                    new File(runDir).mkdir();
                    msRunName[0] = runDir;
                    try {
                        PrintStream out = new PrintStream(new File(String.valueOf(runDir) + "/msrun_" + runName + ".tsv"));
                        if (StringUtils.isNotBlank((String)run.getRawDataFilePath())) {
                            out.println("filePath\t" + run.getRawDataFilePath());
                        }
                        if (StringUtils.isNotBlank((String)run.getRawDataFileName())) {
                            out.println("fileName\t" + run.getRawDataFileName());
                        }
                        if (StringUtils.isNotBlank((String)run.getInstrumentType())) {
                            out.println("instrumentType\t" + run.getInstrumentType());
                        }
                        if (StringUtils.isNotBlank((String)run.getInstrumentManufacturer())) {
                            out.println("instrumentManufacturer\t" + run.getInstrumentManufacturer());
                        }
                        if (StringUtils.isNotBlank((String)run.getInstrumentModel())) {
                            out.println("instrumentModel\t" + run.getInstrumentModel());
                        }
                        if (StringUtils.isNotBlank((String)run.getMethodIonisation())) {
                            out.println("methodIonisation\t" + run.getMethodIonisation());
                        }
                        if (StringUtils.isNotBlank((String)run.getMethodSeparation())) {
                            out.println("methodSeparation\t" + run.getMethodSeparation());
                        }
                        if (run.getAcquisitionDate() != null) {
                            out.println("acquisitionDate\t" + EICMLParser.getDateFormat().format(run.getAcquisitionDate()));
                        }
                        if (run.getChromCount() >= 0) {
                            out.println("chromCount\t" + run.getChromCount());
                        }
                        if (!Float.isNaN(run.getStartTime())) {
                            out.println("startTime\t" + run.getStartTime());
                        }
                        if (!Float.isNaN(run.getEndTime())) {
                            out.println("endTime\t" + run.getEndTime());
                        }
                        if (run.getId() >= 0L) {
                            out.println("msRunId\t" + run.getId());
                        }
                        out.close();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            }, new EICMLParser.IChromatogramObserver(){

                @Override
                public void observe(ChromatogramDTO chromatogram) {
                    try {
                        PrintStream out = new PrintStream(new File(String.valueOf(msRunName[0]) + "/" + chromatogram.getLabel() + ".tsv"));
                        if (!Float.isNaN(chromatogram.getQ1Mz())) {
                            out.println("#\tQ1Mz\t" + chromatogram.getQ1Mz());
                        }
                        if (!Float.isNaN(chromatogram.getQ3LowMz())) {
                            out.println("#\tQ3LowMz\t" + chromatogram.getQ3LowMz());
                        }
                        if (!Float.isNaN(chromatogram.getQ3HighMz())) {
                            out.println("#\tQ3HighMz\t" + chromatogram.getQ3HighMz());
                        }
                        if (StringUtils.isNotBlank((String)chromatogram.getLabel())) {
                            out.println("#\tLabel\t" + chromatogram.getLabel());
                        }
                        if (chromatogram.getPolarity() != '\u0000') {
                            out.println("#\tPolarity\t" + chromatogram.getPolarity());
                        }
                        int i = 0;
                        while (i < chromatogram.getRunTimes().length) {
                            out.println(String.valueOf(chromatogram.getRunTimes()[i]) + "\t" + chromatogram.getIntensities()[i]);
                            ++i;
                        }
                        out.close();
                    }
                    catch (FileNotFoundException ex) {
                        ex.printStackTrace();
                    }
                }
            });
            ++n2;
        }
    }
}

