/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.eicml;

import ch.systemsx.cisd.openbis.generic.shared.basic.dto.ISerializableComparable;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.TableModel;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.util.SimpleTableModelBuilder;
import ch.systemsx.cisd.yeastx.eicml.AbstractEICMLDatastoreReportingPlugin;
import ch.systemsx.cisd.yeastx.eicml.EICMSRunDTO;
import ch.systemsx.cisd.yeastx.eicml.IEICMSRunDAO;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Properties;

public class EICMLRunsReporter
extends AbstractEICMLDatastoreReportingPlugin {
    private static final long serialVersionUID = 1L;

    public EICMLRunsReporter(Properties properties, File storeRoot) {
        super(properties, storeRoot);
    }

    @Override
    protected final TableModel createReport(List<DatasetDescription> datasets, IEICMSRunDAO query) {
        SimpleTableModelBuilder builder = new SimpleTableModelBuilder();
        EICMLRunsReporter.addReportHeaders(builder);
        for (DatasetDescription dataset : datasets) {
            EICMSRunDTO run = query.getMSRunByDatasetPermId(dataset.getDataSetCode());
            if (run == null) continue;
            builder.addRow(EICMLRunsReporter.createRow(run, dataset));
        }
        return builder.getTableModel();
    }

    private static List<ISerializableComparable> createRow(EICMSRunDTO run, DatasetDescription dataset) {
        ArrayList<ISerializableComparable> row = new ArrayList<ISerializableComparable>();
        row.add(SimpleTableModelBuilder.asText((String)dataset.getDataSetCode()));
        row.add(SimpleTableModelBuilder.asText((String)run.getRawDataFilePath()));
        row.add(SimpleTableModelBuilder.asText((String)run.getRawDataFileName()));
        row.add(SimpleTableModelBuilder.asText((String)run.getInstrumentType()));
        row.add(SimpleTableModelBuilder.asText((String)run.getInstrumentManufacturer()));
        row.add(SimpleTableModelBuilder.asText((String)run.getInstrumentModel()));
        row.add(SimpleTableModelBuilder.asText((String)run.getMethodIonisation()));
        row.add(SimpleTableModelBuilder.asText((String)run.getMethodSeparation()));
        row.add(SimpleTableModelBuilder.asDate((Date)run.getAcquisitionDate()));
        row.add(SimpleTableModelBuilder.asDouble((double)run.getStartTime()));
        row.add(SimpleTableModelBuilder.asDouble((double)run.getEndTime()));
        row.add(SimpleTableModelBuilder.asText((String)run.getOperator()));
        return row;
    }

    private static void addReportHeaders(SimpleTableModelBuilder builder) {
        builder.addHeader("Dataset");
        builder.addHeader("Raw data file path");
        builder.addHeader("Raw data file name");
        builder.addHeader("Instrument type");
        builder.addHeader("Instrument manufacturer");
        builder.addHeader("Instrument model");
        builder.addHeader("Method ionisation");
        builder.addHeader("Method separation");
        builder.addHeader("Acquisition date");
        builder.addHeader("Start time");
        builder.addHeader("End time");
        builder.addHeader("Operator");
    }
}

