/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.Status;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.filesystem.BooleanStatus;
import ch.systemsx.cisd.common.properties.PropertyUtils;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.AbstractArchiverProcessingPlugin;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.HighWaterMarkChecker;
import ch.systemsx.cisd.openbis.dss.generic.server.plugins.standard.IStatusChecker;
import ch.systemsx.cisd.openbis.dss.generic.shared.ArchiverTaskContext;
import ch.systemsx.cisd.openbis.dss.generic.shared.DataSourceProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.IDataSetDirectoryProvider;
import ch.systemsx.cisd.openbis.dss.generic.shared.ServiceProvider;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Experiment;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.IDatasetLocation;
import ch.systemsx.cisd.openbis.generic.shared.basic.dto.Sample;
import ch.systemsx.cisd.openbis.generic.shared.dto.DatasetDescription;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.ExperimentIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SampleIdentifier;
import ch.systemsx.cisd.openbis.generic.shared.dto.identifier.SpaceIdentifier;
import ch.systemsx.cisd.yeastx.db.DBUtils;
import ch.systemsx.cisd.yeastx.db.generic.IDMGenericDAO;
import ch.systemsx.cisd.yeastx.etl.ML2DatabaseUploader;
import java.io.File;
import java.util.List;
import java.util.Properties;
import javax.sql.DataSource;

public class MLArchiverTask
extends AbstractArchiverProcessingPlugin {
    private static final long serialVersionUID = 1L;
    private static final String HIGHWATER_MARK_PROPERTY_KEY = "dataset-unarchiving-highwater-mark";
    private final String dataSourceName;

    public MLArchiverTask(Properties properties, File storeRoot) {
        super(properties, storeRoot, null, MLArchiverTask.tryCreateUnarchivingStatusChecker(properties, storeRoot));
        this.dataSourceName = DataSourceProvider.extractDataSourceName((Properties)properties);
    }

    private static IStatusChecker tryCreateUnarchivingStatusChecker(Properties properties, File storeRoot) {
        long archiveHighWaterMark = PropertyUtils.getLong((Properties)properties, (String)HIGHWATER_MARK_PROPERTY_KEY, (long)-1L);
        if (archiveHighWaterMark == -1L) {
            return null;
        }
        return new HighWaterMarkChecker(archiveHighWaterMark, storeRoot);
    }

    private Status removeFromYeastXDatabase(DatasetDescription dataset, IDMGenericDAO dao) {
        try {
            dao.deleteDataSet(dataset.getDataSetCode());
            dao.commit();
        }
        catch (Exception ex) {
            dao.rollback();
            return this.createErrorStatus(ex);
        }
        return Status.OK;
    }

    private static DataSource getDataSource(String dataSourceName) {
        return ServiceProvider.getDataSourceProvider().getDataSource(dataSourceName);
    }

    private Status uploadToYeastXDatabase(DatasetDescription dataset, IDataSetDirectoryProvider directoryProvider, ML2DatabaseUploader databaseUploader) {
        try {
            Sample sample = null;
            if (dataset.getSampleCode() != null) {
                sample = this.fetchSample(dataset);
            }
            Experiment experiment = this.getOrFetchExperiment(dataset, sample);
            File dataFile = this.getDataFile(dataset, directoryProvider);
            databaseUploader.upload(dataFile, sample, experiment, dataset.getDataSetCode());
            databaseUploader.commit();
        }
        catch (Exception ex) {
            if (databaseUploader != null) {
                databaseUploader.rollback();
            }
            return this.createErrorStatus(ex);
        }
        return Status.OK;
    }

    private Status createErrorStatus(Exception ex) {
        return Status.createError((String)(ex.getMessage() == null ? "unknown reason " + ex.getClass().getName() : ex.getMessage()));
    }

    private Sample fetchSample(DatasetDescription dataset) {
        SampleIdentifier sampleIdentifier = new SampleIdentifier(new SpaceIdentifier(dataset.getDatabaseInstanceCode(), dataset.getSpaceCode()), dataset.getSampleCode());
        Sample sample = ServiceProvider.getOpenBISService().tryGetSampleWithExperiment(sampleIdentifier);
        return sample;
    }

    private Experiment getOrFetchExperiment(DatasetDescription dataset, Sample sample) {
        if (sample != null && sample.getExperiment() != null) {
            return sample.getExperiment();
        }
        ExperimentIdentifier experimentIdentifier = new ExperimentIdentifier(dataset.getDatabaseInstanceCode(), dataset.getSpaceCode(), dataset.getProjectCode(), dataset.getExperimentCode());
        Experiment experiment = ServiceProvider.getOpenBISService().tryGetExperiment(experimentIdentifier);
        return experiment;
    }

    private File getDataFile(DatasetDescription dataset, IDataSetDirectoryProvider directoryProvider) {
        File datasetDir = this.getDataSubDir(directoryProvider, dataset);
        File[] files = datasetDir.listFiles();
        if (files == null || files.length < 1) {
            throw new UserFailureException("Data set directory contains no files (exactly one expected)");
        }
        if (files.length > 1) {
            throw new UserFailureException("Data set directory contains more than one file (exactly one expected)");
        }
        return files[0];
    }

    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doArchive(List<DatasetDescription> datasets, ArchiverTaskContext context, boolean removeFromDataStore) {
        return MLArchiverTask.createStatuses((Status)Status.OK, datasets, (AbstractArchiverProcessingPlugin.Operation)AbstractArchiverProcessingPlugin.Operation.ARCHIVE);
    }

    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doUnarchive(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        ML2DatabaseUploader databaseUploader = new ML2DatabaseUploader(this.properties);
        int counter = 0;
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (DatasetDescription dataset : datasets) {
            Status status = this.uploadToYeastXDatabase(dataset, context.getDirectoryProvider(), databaseUploader);
            statuses.addResult(dataset.getDataSetCode(), status, "Uploading to YeastX database");
            if (++counter % 100 != 0) continue;
            operationLog.info((Object)("Uploading to YeastX database status: " + counter + "/" + datasets.size()));
        }
        return statuses;
    }

    public BooleanStatus isDataSetSynchronizedWithArchive(DatasetDescription dataset, ArchiverTaskContext context) {
        return BooleanStatus.createTrue();
    }

    protected BooleanStatus isDataSetPresentInArchive(DatasetDescription dataset) {
        return BooleanStatus.createTrue();
    }

    protected void removeFromDataStore(List<DatasetDescription> datasets, ArchiverTaskContext context) {
        DataSource dataSource = MLArchiverTask.getDataSource(this.dataSourceName);
        IDMGenericDAO dao = DBUtils.getQuery(dataSource, IDMGenericDAO.class);
        try {
            int counter = 0;
            for (DatasetDescription dataset : datasets) {
                this.removeFromYeastXDatabase(dataset, dao);
                if (++counter % 100 != 0) continue;
                operationLog.info((Object)("Removing data from YeastX database status : " + counter + "/" + datasets.size()));
            }
        }
        finally {
            dao.close();
        }
    }

    protected AbstractArchiverProcessingPlugin.DatasetProcessingStatuses doDeleteFromArchive(List<? extends IDatasetLocation> datasets) {
        AbstractArchiverProcessingPlugin.DatasetProcessingStatuses statuses = new AbstractArchiverProcessingPlugin.DatasetProcessingStatuses();
        for (IDatasetLocation iDatasetLocation : datasets) {
            statuses.addResult(iDatasetLocation.getDataSetCode(), Status.OK, AbstractArchiverProcessingPlugin.Operation.DELETE_FROM_ARCHIVE);
        }
        return statuses;
    }
}

