/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.etl;

import ch.systemsx.cisd.common.exceptions.EnvironmentFailureException;
import ch.systemsx.cisd.common.exceptions.UserFailureException;
import ch.systemsx.cisd.common.xml.JaxbXmlParser;
import ch.systemsx.cisd.etlserver.DefaultDataSetInfoExtractor;
import ch.systemsx.cisd.etlserver.IDataSetInfoExtractor;
import ch.systemsx.cisd.openbis.dss.generic.shared.IEncapsulatedOpenBISService;
import ch.systemsx.cisd.openbis.dss.generic.shared.dto.DataSetInformation;
import ch.systemsx.cisd.yeastx.etl.QuantMLStorageProcessor;
import ch.systemsx.cisd.yeastx.quant.dto.MSConcentrationDTO;
import ch.systemsx.cisd.yeastx.quant.dto.MSQuantificationDTO;
import ch.systemsx.cisd.yeastx.quant.dto.MSQuantificationsDTO;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;

public class QuantMLDataSetInfoExtractor
implements IDataSetInfoExtractor {
    private final IDataSetInfoExtractor defaultExtractor;

    public QuantMLDataSetInfoExtractor(Properties properties) {
        this.defaultExtractor = new DefaultDataSetInfoExtractor(properties);
    }

    public DataSetInformation getDataSetInformation(File incomingDataSetPath, IEncapsulatedOpenBISService openbisService) throws UserFailureException, EnvironmentFailureException {
        DataSetInformation dataSetInformation = this.defaultExtractor.getDataSetInformation(incomingDataSetPath, openbisService);
        List<String> parentDatasetCodes = QuantMLDataSetInfoExtractor.extractParentDatasetCodes(incomingDataSetPath);
        dataSetInformation.setParentDataSetCodes(parentDatasetCodes);
        return dataSetInformation;
    }

    private static List<String> extractParentDatasetCodes(File incomingDataSetPath) {
        File quantML = QuantMLStorageProcessor.findFile(incomingDataSetPath, "quantML");
        MSQuantificationsDTO quantifications = (MSQuantificationsDTO)JaxbXmlParser.parse(MSQuantificationsDTO.class, (File)quantML, (boolean)true);
        ArrayList<String> parentDatasets = new ArrayList<String>();
        for (MSQuantificationDTO q : quantifications.getQuantifications()) {
            for (MSConcentrationDTO c : q.getConcentrations()) {
                parentDatasets.add(c.getParentDatasetCode());
            }
        }
        return parentDatasets;
    }
}

