/*
 * Decompiled with CFR 0.152.
 */
package ch.systemsx.cisd.yeastx.fiaml;

import ch.systemsx.cisd.yeastx.db.AbstractDatasetLoader;
import ch.systemsx.cisd.yeastx.db.generic.DMDataSetDTO;
import ch.systemsx.cisd.yeastx.fiaml.FIAMLParser;
import ch.systemsx.cisd.yeastx.fiaml.FIAMSRunDTO;
import ch.systemsx.cisd.yeastx.fiaml.FIAMSRunDataDTO;
import ch.systemsx.cisd.yeastx.fiaml.IFIAMSRunDAO;
import ch.systemsx.cisd.yeastx.fiaml.ProfileDTO;
import java.io.File;
import java.sql.SQLException;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import javax.sql.DataSource;

public class FIAML2Database
extends AbstractDatasetLoader<IFIAMSRunDAO> {
    private static final int PROFILE_CHUNK_SIZE = 250;

    private static Collection<ProfileDTO> profileChunk(final FIAMSRunDataDTO runData) {
        return new AbstractCollection<ProfileDTO>(){

            @Override
            public Iterator<ProfileDTO> iterator() {
                return new Iterator<ProfileDTO>(){
                    int i = 0;

                    @Override
                    public boolean hasNext() {
                        return this.i < runData.getProfileMz().length;
                    }

                    @Override
                    public ProfileDTO next() {
                        int imax = Math.min(runData.getProfileMz().length, this.i + 250);
                        int imin = this.i;
                        this.i = imax;
                        return ProfileDTO.split(runData.getProfileMz(), runData.getProfileIntensities(), imin, imax);
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }

            @Override
            public int size() {
                return runData.getProfileMz().length;
            }
        };
    }

    public FIAML2Database(DataSource dataSource) {
        super(dataSource, IFIAMSRunDAO.class);
    }

    @Override
    public void upload(File fiaMLFile, final DMDataSetDTO dataSet) throws SQLException {
        try {
            this.createDataSet(dataSet);
            new FIAMLParser(fiaMLFile.getPath(), new FIAMLParser.IMSRunObserver(){

                @Override
                public void observe(FIAMSRunDTO run, FIAMSRunDataDTO runData) {
                    run.setExperimentId(dataSet.getExperimentId());
                    run.setSampleId(dataSet.getSampleId());
                    run.setDataSetId(dataSet.getId());
                    long fiaMsRunId = ((IFIAMSRunDAO)FIAML2Database.this.getDao()).addMSRun(run);
                    ((IFIAMSRunDAO)FIAML2Database.this.getDao()).addProfiles(fiaMsRunId, FIAML2Database.profileChunk(runData));
                    ((IFIAMSRunDAO)FIAML2Database.this.getDao()).addCentroids(fiaMsRunId, runData.getCentroidMz(), runData.getCentroidIntensities(), runData.getCentroidCorrelations());
                }
            });
        }
        catch (Throwable th) {
            this.rollbackAndRethrow(th);
        }
    }
}

